/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.state;

import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;

public class TopExtensionDependency {
    private final ArtifactCoords coords;
    private final Extension catalogMetadata;
    private final boolean transitive;
    private final String providerKey;

    public static Builder builder() {
        return new Builder();
    }

    private TopExtensionDependency(ArtifactCoords coords, Extension metadata, String providerKey, boolean transitive) {
        this.coords = coords;
        this.catalogMetadata = metadata;
        this.providerKey = providerKey;
        this.transitive = transitive;
    }

    public ArtifactKey getKey() {
        return this.coords.getKey();
    }

    public ArtifactCoords getArtifact() {
        return this.coords;
    }

    public ExtensionOrigin getOrigin() {
        if (this.catalogMetadata == null || this.catalogMetadata.getOrigins().isEmpty()) {
            return null;
        }
        ExtensionOrigin origin = (ExtensionOrigin)this.catalogMetadata.getOrigins().get(0);
        if (origin.isPlatform()) {
            return origin;
        }
        if (this.catalogMetadata.getOrigins().size() > 1) {
            for (int i = 1; i < this.catalogMetadata.getOrigins().size(); ++i) {
                ExtensionOrigin o = (ExtensionOrigin)this.catalogMetadata.getOrigins().get(i);
                if (!o.isPlatform()) continue;
                origin = o;
                break;
            }
        }
        return origin;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public String getVersion() {
        return this.coords.getVersion();
    }

    public String getCatalogVersion() {
        return this.catalogMetadata == null ? null : this.catalogMetadata.getArtifact().getVersion();
    }

    public boolean isNonRecommendedVersion() {
        String catalogVersion = this.getCatalogVersion();
        return catalogVersion == null ? false : !catalogVersion.equals(this.getVersion());
    }

    public boolean isPlatformExtension() {
        ExtensionOrigin origin = this.getOrigin();
        return origin == null ? false : origin.isPlatform();
    }

    public Extension getCatalogMetadata() {
        return this.catalogMetadata;
    }

    public String getProviderKey() {
        return this.providerKey;
    }

    public static class Builder {
        private ArtifactCoords coords;
        private ResolvedDependency resolvedDep;
        private Extension catalogMetadata;
        private boolean transitive;

        private Builder() {
        }

        public Builder setResolvedDependency(ResolvedDependency resolvedDep) {
            this.resolvedDep = resolvedDep;
            return this.setArtifact((ArtifactCoords)new GACTV(resolvedDep.getGroupId(), resolvedDep.getArtifactId(), resolvedDep.getClassifier(), resolvedDep.getType(), resolvedDep.getVersion()));
        }

        public Builder setArtifact(ArtifactCoords coords) {
            this.coords = coords;
            return this;
        }

        public Builder setCatalogMetadata(Extension metadata) {
            this.catalogMetadata = metadata;
            return this;
        }

        public Builder setTransitive(boolean transitive) {
            this.transitive = transitive;
            return this;
        }

        public TopExtensionDependency build() {
            if (this.catalogMetadata == null) {
                this.catalogMetadata = (Extension)this.resolvedDep.getContentTree().apply("META-INF/quarkus-extension.yaml", visit -> {
                    if (visit == null) {
                        return null;
                    }
                    try {
                        return Extension.fromFile((Path)visit.getPath());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to deserialize extension metadata from " + visit.getUrl(), e);
                    }
                });
            }
            return new TopExtensionDependency(this.coords, this.catalogMetadata, ExtensionProvider.key(Builder.getOrigin(this.catalogMetadata)), this.transitive);
        }

        public ArtifactKey getKey() {
            return this.resolvedDep == null ? null : this.resolvedDep.getKey();
        }

        private static ExtensionOrigin getOrigin(Extension metadata) {
            if (metadata == null || metadata.getOrigins().isEmpty()) {
                return null;
            }
            ExtensionOrigin origin = (ExtensionOrigin)metadata.getOrigins().get(0);
            if (origin.isPlatform()) {
                return origin;
            }
            if (metadata.getOrigins().size() > 1) {
                for (int i = 1; i < metadata.getOrigins().size(); ++i) {
                    ExtensionOrigin o = (ExtensionOrigin)metadata.getOrigins().get(i);
                    if (!o.isPlatform()) continue;
                    origin = o;
                    break;
                }
            }
            return origin;
        }
    }
}

