/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CreateProjectCodestartDataConverter implements DataKey
{
    PROJECT_GROUP_ID("project.group-id"),
    PROJECT_ARTIFACT_ID("project.artifact-id"),
    PROJECT_VERSION("project.version"),
    PROJECT_NAME("project.name"),
    PROJECT_DESCRIPTION("project.description"),
    PROJECT_PACKAGE_NAME("project.package-name"),
    QUARKUS_VERSION("quarkus-version"),
    JAVA_VERSION("project.java-version"),
    APP_CONFIG("project.app-config", Collections.emptyMap()),
    QUARKUS_MAVEN_PLUGIN_GROUP_ID("maven-plugin-groupId"),
    QUARKUS_MAVEN_PLUGIN_ARTIFACT_ID("maven-plugin-artifactId"),
    QUARKUS_MAVEN_PLUGIN_VERSION("maven-plugin-version"),
    QUARKUS_GRADLE_PLUGIN_ID("gradle-plugin-id"),
    QUARKUS_GRADLE_PLUGIN_VERSION("gradle-plugin-version"),
    KOTLIN_VERSION("kotlin-version"),
    SCALA_VERSION("scala-version"),
    SCALA_MAVEN_PLUGIN_VERSION("scala-plugin-version"),
    MAVEN_COMPILER_PLUGIN_VERSION("compiler-plugin-version"),
    MAVEN_SUREFIRE_PLUGIN_VERSION("surefire-plugin-version"),
    BOM_GROUP_ID("bom.group-id"),
    BOM_ARTIFACT_ID("bom.artifact-id"),
    BOM_VERSION("bom.version"),
    RESTEASY_CODESTART_RESOURCE_PATH("project.resource.path"),
    RESTEASY_CODESTART_RESOURCE_CLASS_NAME(CreateProjectCodestartDataConverter::convertClassName),
    RESTEASY_REACTIVE_CODESTART_RESOURCE_PATH("project.resource.path"),
    RESTEASY_REACTIVE_CODESTART_RESOURCE_CLASS_NAME(CreateProjectCodestartDataConverter::convertClassName),
    SPRING_WEB_CODESTART_RESOURCE_PATH("project.resource.path"),
    SPRING_WEB_CODESTART_RESOURCE_CLASS_NAME(CreateProjectCodestartDataConverter::convertClassName);

    private final String key = QuarkusCodestartData.QuarkusDataKey.valueOf(this.name()).key();
    private final Function<Map<String, Object>, Object> converter;

    private CreateProjectCodestartDataConverter(String createProjectKey) {
        this((Map<String, Object> m) -> m.get(createProjectKey));
    }

    private CreateProjectCodestartDataConverter(String createProjectKey, Object defaultValue) {
        this((Map<String, Object> m) -> m.getOrDefault(createProjectKey, defaultValue));
    }

    private CreateProjectCodestartDataConverter(Function<Map<String, Object>, Object> converter) {
        this.converter = converter;
    }

    public String key() {
        return this.key;
    }

    public static Map<String, Object> toCodestartData(Map<String, Object> createProjectData) {
        return NestedMaps.unflatten(Stream.of(CreateProjectCodestartDataConverter.values()).map(v -> new AbstractMap.SimpleImmutableEntry<String, Object>(v.key(), v.converter.apply(createProjectData))).filter(v -> v.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static String convertClassName(Map<String, Object> createProjectData) {
        String className = (String)createProjectData.get("project.resource.class-name");
        if (className != null) {
            int idx = className.lastIndexOf(46);
            if (idx < 0) {
                return className;
            }
            return className.substring(idx + 1);
        }
        return null;
    }

    public static interface CatalogKey {
        public static final String BOM_GROUP_ID = "bom.group-id";
        public static final String BOM_ARTIFACT_ID = "bom.artifact-id";
        public static final String BOM_VERSION = "bom.version";
    }

    public static interface PlatformPropertiesKey {
        public static final String QUARKUS_MAVEN_PLUGIN_GROUP_ID = "maven-plugin-groupId";
        public static final String QUARKUS_MAVEN_PLUGIN_ARTIFACT_ID = "maven-plugin-artifactId";
        public static final String QUARKUS_MAVEN_PLUGIN_VERSION = "maven-plugin-version";
        public static final String QUARKUS_GRADLE_PLUGIN_VERSION = "gradle-plugin-version";
        public static final String KOTLIN_VERSION = "kotlin-version";
        public static final String SCALA_VERSION = "scala-version";
        public static final String QUARKUS_GRADLE_PLUGIN_ID = "gradle-plugin-id";
        public static final String SCALA_MAVEN_PLUGIN_VERSION = "scala-plugin-version";
        public static final String MAVEN_COMPILER_PLUGIN_VERSION = "compiler-plugin-version";
        public static final String MAVEN_SUREFIRE_PLUGIN_VERSION = "surefire-plugin-version";
    }
}

