/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.devtools.project.state.ModuleState;
import io.quarkus.devtools.project.state.ProjectState;
import io.quarkus.devtools.project.state.ProjectStates;
import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.devtools.project.update.PlatformInfo;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class ProjectInfoCommandHandler
implements QuarkusCommandHandler {
    public static final String RECOMMENDATIONS_AVAILABLE = "recommendations-available";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        ApplicationModel appModel = (ApplicationModel)invocation.getValue("quarkus.project-info.app-model");
        boolean logStatePerModule = invocation.getValue("quarkus.project-info.per-module", false);
        boolean recommendationsAvailable = ProjectInfoCommandHandler.logState(ProjectStates.resolveProjectState(appModel, invocation.getExtensionsCatalog()), logStatePerModule, false, invocation.log());
        return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue(RECOMMENDATIONS_AVAILABLE, recommendationsAvailable);
    }

    protected static boolean logState(ProjectState projectState, boolean perModule, boolean rectify, MessageWriter log) {
        boolean recommendationsAvailable = false;
        LinkedHashMap<ArtifactKey, PlatformInfo> providerInfo = new LinkedHashMap<ArtifactKey, PlatformInfo>();
        for (ArtifactCoords artifactCoords : projectState.getPlatformBoms()) {
            providerInfo.computeIfAbsent(artifactCoords.getKey(), k -> new PlatformInfo(bom, null));
        }
        for (TopExtensionDependency topExtensionDependency : projectState.getExtensions()) {
            ExtensionOrigin origin = topExtensionDependency.getOrigin();
            if (origin == null || !origin.isPlatform()) continue;
            providerInfo.compute(origin.getBom().getKey(), (k, v) -> {
                if (v == null) {
                    return new PlatformInfo(null, origin.getBom());
                }
                return new PlatformInfo(v.getImported(), origin.getBom());
            });
        }
        if (providerInfo.isEmpty()) {
            log.info("No Quarkus platform BOMs found");
        } else {
            log.info("Quarkus platform BOMs:");
            boolean recommendExtraImports = false;
            for (PlatformInfo platform : providerInfo.values()) {
                if (!platform.isImported()) {
                    recommendExtraImports = true;
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                if (platform.getRecommended() == null) {
                    if (rectify) {
                        sb.append(String.format("%-7s %s", "Remove:", platform.getImported().toCompactCoords()));
                        recommendationsAvailable = true;
                    } else {
                        sb.append("  ");
                        sb.append(platform.getImported().toCompactCoords());
                        if (!projectState.getExtensions().isEmpty()) {
                            sb.append(" | unnecessary");
                            recommendationsAvailable = true;
                        }
                    }
                } else if (platform.isVersionUpdateRecommended()) {
                    sb.append(String.format("%-7s %s", rectify ? "Update:" : "", platform.getImported().toCompactCoords()));
                    if (rectify) {
                        sb.append(platform.getImported().toCompactCoords()).append(" -> ").append(platform.getRecommendedVersion());
                    } else {
                        sb.append(" ").append(MessageIcons.OUT_OF_DATE_ICON.iconOrMessage());
                    }
                    recommendationsAvailable = true;
                } else {
                    sb.append(String.format("%-7s %s", "", platform.getImported().toCompactCoords())).append(" ").append(MessageIcons.UP_TO_DATE_ICON.iconOrMessage());
                }
                log.info(sb.toString());
            }
            if (rectify && recommendExtraImports) {
                for (PlatformInfo platform : providerInfo.values()) {
                    if (platform.getImported() != null) continue;
                    log.info(String.format("%-7s %s", "Add:", platform.getRecommended().toCompactCoords()));
                }
                recommendationsAvailable = true;
            }
        }
        if (projectState.getExtensions().isEmpty()) {
            log.info("");
            log.info("No Quarkus extensions found among the project dependencies");
            return recommendationsAvailable;
        }
        log.info("");
        if (perModule) {
            ModuleState mainModule = projectState.getMainModule();
            Path path = mainModule.getModuleDir();
            recommendationsAvailable |= ProjectInfoCommandHandler.logModuleInfo(projectState, mainModule, path, log, rectify);
            for (ModuleState module : projectState.getModules()) {
                if (module.isMain()) continue;
                recommendationsAvailable |= ProjectInfoCommandHandler.logModuleInfo(projectState, module, path, log, rectify);
            }
        } else {
            for (ExtensionProvider extensionProvider : projectState.getExtensionProviders()) {
                if (!extensionProvider.isPlatform()) continue;
                recommendationsAvailable = ProjectInfoCommandHandler.logProvidedExtensions(extensionProvider, rectify, log, recommendationsAvailable);
            }
            for (ExtensionProvider extensionProvider : projectState.getExtensionProviders()) {
                if (extensionProvider.isPlatform()) continue;
                recommendationsAvailable = ProjectInfoCommandHandler.logProvidedExtensions(extensionProvider, rectify, log, recommendationsAvailable);
            }
        }
        return recommendationsAvailable;
    }

    private static boolean logProvidedExtensions(ExtensionProvider provider, boolean rectify, MessageWriter log, boolean recommendationsAvailable) {
        if (provider.getExtensions().isEmpty()) {
            return recommendationsAvailable;
        }
        log.info("Extensions from " + provider.getKey() + ":");
        StringBuilder sb = new StringBuilder();
        for (TopExtensionDependency dep : provider.getExtensions()) {
            sb.setLength(0);
            recommendationsAvailable = ProjectInfoCommandHandler.logExtensionInfo(dep, rectify, sb, recommendationsAvailable);
            log.info(sb.toString());
        }
        log.info("");
        return recommendationsAvailable;
    }

    private static boolean logExtensionInfo(TopExtensionDependency dep, boolean rectify, StringBuilder sb, boolean recommendationsAvailable) {
        if (dep.isPlatformExtension()) {
            if (rectify) {
                if (dep.isNonRecommendedVersion()) {
                    sb.append(String.format("%-7s %s", "Update:", ""));
                } else {
                    sb.append(String.format("%-7s %s", "", ""));
                }
                sb.append(dep.getArtifact().getGroupId()).append(':').append(dep.getArtifact().getArtifactId());
                if (!dep.getArtifact().getClassifier().isEmpty()) {
                    sb.append(':').append(dep.getArtifact().getClassifier());
                }
                if (dep.isNonRecommendedVersion()) {
                    sb.append(':').append(dep.getArtifact().getVersion());
                    if (rectify) {
                        sb.append(" -> drop version (managed by platform)");
                    }
                    recommendationsAvailable = true;
                } else {
                    sb.append(" ").append(MessageIcons.UP_TO_DATE_ICON.iconOrMessage());
                }
            } else {
                sb.append(String.format("%-7s %s", "", "")).append(dep.getArtifact().getGroupId()).append(':').append(dep.getArtifact().getArtifactId());
                if (!dep.getArtifact().getClassifier().isEmpty()) {
                    sb.append(':').append(dep.getArtifact().getClassifier());
                }
                if (dep.isNonRecommendedVersion()) {
                    sb.append(':').append(dep.getArtifact().getVersion());
                    sb.append(" ").append(MessageIcons.OUT_OF_DATE_ICON.iconOrMessage());
                    recommendationsAvailable = true;
                } else {
                    sb.append(" ").append(MessageIcons.UP_TO_DATE_ICON.iconOrMessage());
                }
            }
        } else {
            sb.append(String.format("%-7s %s", "", ""));
            sb.append(dep.getArtifact().toCompactCoords());
        }
        if (dep.isTransitive()) {
            sb.append(" | transitive");
        }
        return recommendationsAvailable;
    }

    private static boolean logModuleInfo(ProjectState project, ModuleState module, Path baseDir, MessageWriter log, boolean rectify) {
        if (module.getExtensions().isEmpty() && module.getPlatformBoms().isEmpty() && !module.isMain()) {
            return false;
        }
        boolean recommendationsAvailable = false;
        StringBuilder sb = new StringBuilder();
        if (module.isMain()) {
            sb.append("Main application module ");
        } else {
            sb.append("Module ");
        }
        sb.append(module.getId().getGroupId()).append(':').append(module.getId().getArtifactId()).append(':');
        log.info(sb.toString());
        Iterator i = module.getWorkspaceModule().getBuildFiles().iterator();
        if (i.hasNext()) {
            sb.setLength(0);
            sb.append("  Build file: ");
            sb.append(baseDir.relativize((Path)i.next()));
            while (i.hasNext()) {
                sb.append(", ").append(baseDir.relativize((Path)i.next()));
            }
            log.info(sb.toString());
        }
        if (!module.getPlatformBoms().isEmpty()) {
            log.info("  Platform BOMs:");
            for (ArtifactCoords bom : module.getPlatformBoms()) {
                log.info("    " + bom.toCompactCoords());
            }
        }
        if (!module.getExtensions().isEmpty()) {
            List extList;
            LinkedHashMap extDepsByProvider = new LinkedHashMap();
            for (TopExtensionDependency dep : module.getExtensions()) {
                extDepsByProvider.computeIfAbsent(dep.getProviderKey(), k -> new ArrayList()).add(dep);
            }
            for (ExtensionProvider provider : project.getExtensionProviders()) {
                if (!provider.isPlatform() || (extList = extDepsByProvider.getOrDefault(provider.getKey(), Collections.emptyList())).isEmpty()) continue;
                log.info("  Extensions from " + provider.getKey() + ":");
                for (TopExtensionDependency dep : extList) {
                    sb.setLength(0);
                    sb.append("  ");
                    recommendationsAvailable = ProjectInfoCommandHandler.logExtensionInfo(dep, rectify, sb, recommendationsAvailable);
                    log.info(sb.toString());
                }
                log.info("");
            }
            for (ExtensionProvider provider : project.getExtensionProviders()) {
                if (provider.isPlatform() || (extList = extDepsByProvider.getOrDefault(provider.getKey(), Collections.emptyList())).isEmpty()) continue;
                log.info("  Extensions from " + provider.getKey() + ":");
                for (TopExtensionDependency dep : extList) {
                    sb.setLength(0);
                    sb.append("  ");
                    recommendationsAvailable = ProjectInfoCommandHandler.logExtensionInfo(dep, rectify, sb, recommendationsAvailable);
                    log.info(sb.toString());
                }
                log.info("");
            }
        }
        return recommendationsAvailable;
    }
}

