/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config;

import io.quarkus.annotation.processor.ExtensionProcessor;
import io.quarkus.annotation.processor.Outputs;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.model.ResolvedModel;
import io.quarkus.annotation.processor.documentation.config.resolver.ConfigResolver;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigAnnotationScanner;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class ConfigDocExtensionProcessor
implements ExtensionProcessor {
    private Config config;
    private Utils utils;
    private ConfigAnnotationScanner configAnnotationScanner;

    @Override
    public void init(Config config, Utils utils) {
        this.config = config;
        this.utils = utils;
        this.configAnnotationScanner = new ConfigAnnotationScanner(config, utils);
    }

    @Override
    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Optional<TypeElement> configGroup = this.findAnnotation(annotations, "io.quarkus.runtime.annotations.ConfigGroup");
        Optional<TypeElement> configRoot = this.findAnnotation(annotations, "io.quarkus.runtime.annotations.ConfigRoot");
        Optional<TypeElement> configMapping = this.findAnnotation(annotations, "io.smallrye.config.ConfigMapping");
        if (configGroup.isPresent()) {
            this.configAnnotationScanner.scanConfigGroups(roundEnv, configGroup.get());
        }
        if (configRoot.isPresent()) {
            this.configAnnotationScanner.scanConfigRoots(roundEnv, configRoot.get());
        }
        if (configMapping.isPresent()) {
            this.configAnnotationScanner.scanConfigMappingsWithoutConfigRoot(roundEnv, configMapping.get());
        }
    }

    private Optional<TypeElement> findAnnotation(Set<? extends TypeElement> annotations, String annotationName) {
        for (TypeElement typeElement : annotations) {
            if (!annotationName.equals(typeElement.getQualifiedName().toString())) continue;
            return Optional.of(typeElement);
        }
        return Optional.empty();
    }

    @Override
    public void finalizeProcessing() {
        ResolvedModel resolvedModel;
        ConfigCollector configCollector = this.configAnnotationScanner.finalizeProcessing();
        Properties javadocProperties = new Properties();
        for (Map.Entry<String, JavadocElements.JavadocElement> javadocElementEntry : configCollector.getJavadocElements().entrySet()) {
            javadocProperties.put(javadocElementEntry.getKey(), javadocElementEntry.getValue().rawJavadoc());
        }
        this.utils.filer().write("META-INF/quarkus-javadoc.properties", javadocProperties);
        ConfigResolver configResolver = new ConfigResolver(this.config, this.utils, configCollector);
        JavadocElements javadocElements = configResolver.resolveJavadoc();
        if (!javadocElements.elements().isEmpty()) {
            this.utils.filer().writeModel(Outputs.QUARKUS_CONFIG_DOC_JAVADOC, javadocElements);
        }
        if (!(resolvedModel = configResolver.resolveModel()).getConfigRoots().isEmpty()) {
            Path resolvedModelPath = this.utils.filer().writeModel(Outputs.QUARKUS_CONFIG_DOC_MODEL, resolvedModel);
            if (this.config.isDebug()) {
                try {
                    this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.NOTE, "Resolved model:\n\n" + Files.readString(resolvedModelPath));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read the resolved model from: " + resolvedModelPath, e);
                }
            }
        }
    }
}

