/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxb.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.jaxb.runtime.JaxbContextConfigRecorder;
import io.quarkus.jaxb.runtime.JaxbContextCustomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

@ApplicationScoped
public class JaxbContextProducer {
    @DefaultBean
    @Singleton
    @Produces
    public JAXBContext jaxbContext(Instance<JaxbContextCustomizer> customizers) {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            List<JaxbContextCustomizer> sortedCustomizers = this.sortCustomizersInDescendingPriorityOrder(customizers);
            for (JaxbContextCustomizer customizer : sortedCustomizers) {
                customizer.customizeContextProperties(properties);
            }
            String[] classNamesToBeBounded = JaxbContextConfigRecorder.getClassesToBeBound();
            ArrayList classes = new ArrayList();
            for (int i = 0; i < classNamesToBeBounded.length; ++i) {
                Class<?> clazz = this.getClassByName(classNamesToBeBounded[i]);
                if (clazz.isPrimitive()) continue;
                classes.add(clazz);
            }
            return JAXBContext.newInstance((Class[])classes.toArray(new Class[0]), properties);
        }
        catch (ClassNotFoundException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @DefaultBean
    @RequestScoped
    @Produces
    public Marshaller marshaller(JAXBContext jaxbContext, Instance<JaxbContextCustomizer> customizers) {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            List<JaxbContextCustomizer> sortedCustomizers = this.sortCustomizersInDescendingPriorityOrder(customizers);
            for (JaxbContextCustomizer customizer : sortedCustomizers) {
                customizer.customizeMarshaller(marshaller);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @DefaultBean
    @RequestScoped
    @Produces
    public Unmarshaller unmarshaller(JAXBContext jaxbContext, Instance<JaxbContextCustomizer> customizers) {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            List<JaxbContextCustomizer> sortedCustomizers = this.sortCustomizersInDescendingPriorityOrder(customizers);
            for (JaxbContextCustomizer customizer : sortedCustomizers) {
                customizer.customizeUnmarshaller(unmarshaller);
            }
            return unmarshaller;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private List<JaxbContextCustomizer> sortCustomizersInDescendingPriorityOrder(Instance<JaxbContextCustomizer> customizers) {
        ArrayList<JaxbContextCustomizer> sortedCustomizers = new ArrayList<JaxbContextCustomizer>();
        for (JaxbContextCustomizer customizer : customizers) {
            sortedCustomizers.add(customizer);
        }
        Collections.sort(sortedCustomizers);
        return sortedCustomizers;
    }

    private Class<?> getClassByName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
    }
}

