/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultDockerContainerLauncher;
import io.quarkus.test.common.DockerContainerArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.launcher.ConfigUtil;
import io.quarkus.test.junit.launcher.DefaultInitContextBase;
import io.smallrye.config.SmallRyeConfig;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;

public class DockerContainerLauncherProvider
implements ArtifactLauncherProvider {
    @Override
    public boolean supportsArtifactType(String type) {
        return ArtifactTypeUtil.isContainer(type);
    }

    public DockerContainerArtifactLauncher create(ArtifactLauncherProvider.CreateContext context) {
        String containerImage = context.quarkusArtifactProperties().getProperty("metadata.container-image");
        boolean pullRequired = Boolean.parseBoolean(context.quarkusArtifactProperties().getProperty("metadata.pull-required", "false"));
        if (containerImage != null && !containerImage.isEmpty()) {
            ServiceLoader<DockerContainerArtifactLauncher> loader = ServiceLoader.load(DockerContainerArtifactLauncher.class);
            Iterator<DockerContainerArtifactLauncher> iterator = loader.iterator();
            Object launcher = iterator.hasNext() ? iterator.next() : new DefaultDockerContainerLauncher();
            SmallRyeConfig config = (SmallRyeConfig)LauncherUtil.installAndGetSomeConfig();
            launcher.init((ArtifactLauncher.InitContext)new DefaultDockerInitContext(((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081), ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444), ConfigUtil.waitTimeValue((Config)config), config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null), ConfigUtil.argLineValue((Config)config), context.devServicesLaunchResult(), containerImage, pullRequired, this.additionalExposedPorts(config)));
            return launcher;
        }
        throw new IllegalStateException("The container image to be launched could not be determined");
    }

    private Map<Integer, Integer> additionalExposedPorts(SmallRyeConfig config) {
        try {
            return config.getValues("quarkus.test.container.additional-exposed-ports", Integer.class, Integer.class);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyMap();
        }
    }

    static class DefaultDockerInitContext
    extends DefaultInitContextBase
    implements DockerContainerArtifactLauncher.DockerInitContext {
        private final String containerImage;
        private final boolean pullRequired;
        private final Map<Integer, Integer> additionalExposedPorts;

        public DefaultDockerInitContext(int httpPort, int httpsPort, Duration waitTime, String testProfile, List<String> argLine, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult, String containerImage, boolean pullRequired, Map<Integer, Integer> additionalExposedPorts) {
            super(httpPort, httpsPort, waitTime, testProfile, argLine, devServicesLaunchResult);
            this.containerImage = containerImage;
            this.pullRequired = pullRequired;
            this.additionalExposedPorts = additionalExposedPorts;
        }

        public String containerImage() {
            return this.containerImage;
        }

        public boolean pullRequired() {
            return this.pullRequired;
        }

        public Map<Integer, Integer> additionalExposedPorts() {
            return this.additionalExposedPorts;
        }
    }
}

