/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.components;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.DependencyFilter;
import io.smallrye.beanbag.Scope;
import io.smallrye.beanbag.maven.MavenFactory;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.building.ModelBuilder;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;

@Singleton
@Named
public class QuarkusWorkspaceProvider {
    private final VersionResolver versionResolver;
    private final VersionRangeResolver versionRangeResolver;
    private final ArtifactResolver artifactResolver;
    private final MetadataResolver metadataResolver;
    private final Deployer deployer;
    private final RemoteRepositoryManager remoteRepoManager;
    private volatile BootstrapMavenContext ctx;

    @Inject
    public QuarkusWorkspaceProvider(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, Deployer deployer, RemoteRepositoryManager remoteRepoManager) {
        this.versionResolver = versionResolver;
        this.versionRangeResolver = versionRangeResolver;
        this.artifactResolver = artifactResolver;
        this.metadataResolver = metadataResolver;
        this.deployer = deployer;
        this.remoteRepoManager = remoteRepoManager;
    }

    public BootstrapMavenContext getMavenContext() {
        return this.ctx == null ? (this.ctx = this.createMavenContext(BootstrapMavenContext.config())) : this.ctx;
    }

    public RepositorySystem getRepositorySystem() {
        try {
            return this.getMavenContext().getRepositorySystem();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven repository system", e);
        }
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        return this.remoteRepoManager;
    }

    public BootstrapMavenContext createMavenContext(BootstrapMavenContextConfig<?> config) {
        try {
            return new BootstrapMavenContext(config){

                protected MavenFactory configureMavenFactory() {
                    final 1 ctx = this;
                    return MavenFactory.create(List.of(RepositorySystem.class.getClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()), builder -> builder.addBeanInstance((Object)QuarkusWorkspaceProvider.this.versionResolver).addBeanInstance((Object)QuarkusWorkspaceProvider.this.versionRangeResolver).addBeanInstance((Object)QuarkusWorkspaceProvider.this.artifactResolver).addBeanInstance((Object)QuarkusWorkspaceProvider.this.metadataResolver).addBeanInstance((Object)QuarkusWorkspaceProvider.this.deployer).addBeanInstance((Object)QuarkusWorkspaceProvider.this.remoteRepoManager).addBean(ModelBuilder.class).setSupplier((BeanSupplier)new BeanSupplier<ModelBuilder>(){

                        public ModelBuilder get(Scope scope) {
                            return new MavenModelBuilder(ctx);
                        }
                    }).setPriority(100).build(), (DependencyFilter)DependencyFilter.ACCEPT);
                }
            };
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Quarkus Maven context", e);
        }
    }

    public MavenArtifactResolver createArtifactResolver(BootstrapMavenContextConfig<?> config) {
        try {
            return new MavenArtifactResolver(this.createMavenContext(config));
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
        }
    }
}

