/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.commands.CreateProject;
import io.quarkus.devtools.commands.CreateProjectHelper;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.components.Prompter;
import io.quarkus.maven.components.QuarkusWorkspaceProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.platform.tools.maven.MojoMessageWriter;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.fusesource.jansi.Ansi;

@Mojo(name="create", requiresProject=false)
public class CreateProjectMojo
extends AbstractMojo {
    static final String BAD_IDENTIFIER = "The specified %s identifier (%s) contains invalid characters. Valid characters are alphanumeric characters (A-Za-z0-9), underscores, dashes and dots.";
    static final Pattern OK_ID = Pattern.compile("[0-9A-Za-z_.-]+");
    private static final String DEFAULT_GROUP_ID = "org.acme";
    private static final String DEFAULT_ARTIFACT_ID = "code-with-quarkus";
    private static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    private static final String DEFAULT_EXTENSIONS = "rest";
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projectGroupId")
    private String projectGroupId;
    @Parameter(property="projectArtifactId")
    private String projectArtifactId;
    @Parameter(property="projectVersion")
    private String projectVersion;
    @Parameter(property="projectName")
    private String projectName;
    @Parameter(property="projectDescription")
    private String projectDescription;
    @Parameter(property="noCode", defaultValue="false")
    private boolean noCode;
    @Parameter(property="example")
    private String example;
    @Parameter(property="platformGroupId", required=false)
    private String bomGroupId;
    @Parameter(property="platformArtifactId", required=false)
    private String bomArtifactId;
    @Parameter(property="platformVersion", required=false)
    private String bomVersion;
    @Parameter(property="javaVersion")
    private String javaVersion;
    @Parameter(property="path")
    private String path;
    @Parameter(property="className")
    private String className;
    @Parameter(property="packageName")
    private String packageName;
    @Parameter(property="buildTool", defaultValue="MAVEN")
    private String buildTool;
    @Parameter(property="extensions")
    private Set<String> extensions;
    @Parameter(property="outputDirectory", defaultValue="${basedir}")
    private File outputDirectory;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(property="appConfig")
    private String appConfig;
    @Parameter(property="data")
    private String data;
    @Component
    QuarkusWorkspaceProvider workspaceProvider;

    public void execute() throws MojoExecutionException {
        boolean success;
        BuildTool buildToolEnum;
        Model parentPomModel;
        File pom;
        File projectRoot;
        ExtensionCatalog catalog;
        MojoMessageWriter log;
        MavenArtifactResolver mvn;
        block26: {
            ExtensionCatalogResolver catalogResolver;
            this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
            try {
                Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create directory " + this.outputDirectory, (Exception)e);
            }
            try {
                mvn = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.getLog().isDebugEnabled() ? this.repoSession : MojoUtils.muteTransferListener((RepositorySystemSession)this.repoSession))).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).build();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to initialize Maven artifact resolver", e);
            }
            log = new MojoMessageWriter(this.getLog());
            try {
                catalogResolver = QuarkusProjectHelper.isRegistryClientEnabled() ? QuarkusProjectHelper.getCatalogResolver((MavenArtifactResolver)mvn, (MessageWriter)log) : ExtensionCatalogResolver.empty();
            }
            catch (RegistryResolutionException e) {
                catalogResolver = ExtensionCatalogResolver.empty();
            }
            catalog = CreateProjectMojo.resolveExtensionsCatalog(this, this.bomGroupId, this.bomArtifactId, this.bomVersion, catalogResolver, mvn, log);
            projectRoot = this.outputDirectory;
            pom = this.project != null ? this.project.getFile() : null;
            parentPomModel = null;
            boolean containsAtLeastOneGradleFile = false;
            for (String gradleFile : Arrays.asList("build.gradle", "settings.gradle", "build.gradle.kts", "settings.gradle.kts")) {
                containsAtLeastOneGradleFile |= new File(projectRoot, gradleFile).isFile();
            }
            buildToolEnum = BuildTool.findTool((String)this.buildTool);
            if (buildToolEnum == null) {
                String validBuildTools = String.join((CharSequence)",", Arrays.asList(BuildTool.values()).stream().map(Enum::toString).collect(Collectors.toList()));
                throw new IllegalArgumentException("Choose a valid build tool. Accepted values are: " + validBuildTools);
            }
            if (BuildTool.MAVEN.equals((Object)buildToolEnum)) {
                if (pom != null && pom.isFile()) {
                    try {
                        parentPomModel = MojoUtils.readPom((File)pom);
                        if (!"pom".equals(parentPomModel.getPackaging())) {
                            throw new MojoExecutionException("The parent project must have a packaging type of POM. Current packaging: " + parentPomModel.getPackaging());
                        }
                        break block26;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Could not access parent pom.", (Exception)e);
                    }
                }
                if (containsAtLeastOneGradleFile) {
                    throw new MojoExecutionException("You are trying to create a Maven project in a directory that contains only Gradle build files.");
                }
            } else if (BuildTool.GRADLE.equals((Object)buildToolEnum) || BuildTool.GRADLE_KOTLIN_DSL.equals((Object)buildToolEnum)) {
                if (containsAtLeastOneGradleFile) {
                    throw new MojoExecutionException("Adding subprojects to gradle projects is not implemented.");
                }
                if (pom != null && pom.isFile()) {
                    throw new MojoExecutionException("You are trying to create gradle project in a directory that contains only maven build files.");
                }
            }
        }
        this.askTheUserForMissingValues();
        if (!DEFAULT_ARTIFACT_ID.equals(this.projectArtifactId) && !OK_ID.matcher(this.projectArtifactId).matches()) {
            throw new MojoExecutionException(String.format(BAD_IDENTIFIER, "artifactId", this.projectArtifactId));
        }
        if (!DEFAULT_GROUP_ID.equals(this.projectGroupId) && !OK_ID.matcher(this.projectGroupId).matches()) {
            throw new MojoExecutionException(String.format(BAD_IDENTIFIER, "groupId", this.projectGroupId));
        }
        projectRoot = new File(this.outputDirectory, this.projectArtifactId);
        if (projectRoot.exists()) {
            throw new MojoExecutionException("Unable to create the project, the directory " + projectRoot.getAbsolutePath() + " already exists");
        }
        Path projectDirPath = projectRoot.toPath();
        try {
            this.extensions = CreateProjectHelper.sanitizeExtensions(this.extensions);
            catalog = CreateProjectHelper.completeCatalog((ExtensionCatalog)catalog, this.extensions, (MavenArtifactResolver)mvn);
            this.sanitizeOptions();
            List codestartsResourceLoader = CodestartResourceLoadersBuilder.codestartLoadersBuilder().catalog(catalog).artifactResolver(mvn).build();
            QuarkusProject newProject = QuarkusProject.of((Path)projectDirPath, (ExtensionCatalog)catalog, (List)codestartsResourceLoader, (MessageWriter)log, (BuildTool)buildToolEnum, (JavaVersion)new JavaVersion(this.javaVersion));
            CreateProject createProject = new CreateProject(newProject).groupId(this.projectGroupId).artifactId(this.projectArtifactId).version(this.projectVersion).name(this.projectName).description(this.projectDescription).javaVersion(this.javaVersion).resourceClassName(this.className).packageName(this.packageName).extensions(this.extensions).resourcePath(this.path).example(this.example).noCode(this.noCode).appConfig(this.appConfig).data(this.data);
            success = createProject.execute().isSuccess();
            if (success && parentPomModel != null && BuildTool.MAVEN.equals((Object)buildToolEnum)) {
                if (!parentPomModel.getModules().contains(this.projectArtifactId)) {
                    parentPomModel.addModule(this.projectArtifactId);
                }
                File subModulePomFile = new File(projectRoot, buildToolEnum.getDependenciesFile());
                Model subModulePomModel = MojoUtils.readPom((File)subModulePomFile);
                Parent parent = new Parent();
                parent.setGroupId(parentPomModel.getGroupId());
                parent.setArtifactId(parentPomModel.getArtifactId());
                parent.setVersion(parentPomModel.getVersion());
                subModulePomModel.setParent(parent);
                MojoUtils.writeFormatted((Model)parentPomModel, (File)pom);
                MojoUtils.writeFormatted((Model)subModulePomModel, (File)subModulePomFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate Quarkus project", e);
        }
        if (!success) {
            throw new MojoExecutionException("The project was created but (some of) the requested extensions couldn't be added.");
        }
        this.printUserInstructions(projectRoot);
    }

    static ExtensionCatalog resolveExtensionsCatalog(AbstractMojo mojo, String groupId, String artifactId, String version, ExtensionCatalogResolver catalogResolver, MavenArtifactResolver artifactResolver, MessageWriter log) throws MojoExecutionException {
        if (catalogResolver.hasRegistries()) {
            try {
                return CreateProjectMojo.isBlank(groupId) && CreateProjectMojo.isBlank(artifactId) && CreateProjectMojo.isBlank(version) ? catalogResolver.resolveExtensionCatalog() : catalogResolver.resolveExtensionCatalog(List.of(ArtifactCoords.pom((String)CreateProjectMojo.getPlatformGroupId(mojo, groupId), (String)CreateProjectMojo.getPlatformArtifactId(artifactId), (String)CreateProjectMojo.getPlatformVersion(mojo, version))));
            }
            catch (RegistryResolutionException e) {
                log.warn(e.getLocalizedMessage());
                mojo.getLog().debug((Throwable)e);
            }
        }
        return CreateProjectMojo.resolveExtensionCatalogDirectly(mojo, groupId, artifactId, version, catalogResolver, artifactResolver, log);
    }

    private static ExtensionCatalog resolveExtensionCatalogDirectly(AbstractMojo mojo, String groupId, String artifactId, String version, ExtensionCatalogResolver catalogResolver, MavenArtifactResolver artifactResolver, MessageWriter log) {
        groupId = CreateProjectMojo.getPlatformGroupId(mojo, groupId);
        artifactId = CreateProjectMojo.getPlatformArtifactId(artifactId);
        version = CreateProjectMojo.getPlatformVersion(mojo, version);
        ExtensionCatalog catalog = ToolsUtils.resolvePlatformDescriptorDirectly((String)groupId, (String)artifactId, (String)version, (MavenArtifactResolver)artifactResolver, (MessageWriter)log);
        StringBuilder buf = new StringBuilder();
        buf.append("The extension catalog will be narrowed to the ").append(groupId).append(":").append(artifactId).append(":").append(version).append(" platform release.");
        if (!QuarkusProjectHelper.isRegistryClientEnabled()) {
            buf.append(" To enable the complete Quarkiverse extension catalog along with the latest recommended platform releases, please, make sure the extension registry client is enabled.");
        }
        log.warn(buf.toString());
        return catalog;
    }

    private void askTheUserForMissingValues() throws MojoExecutionException {
        if (!this.session.getRequest().isInteractiveMode() || this.shouldUseDefaults()) {
            this.setProperDefaults();
            return;
        }
        try {
            Prompter prompter = new Prompter();
            if (CreateProjectMojo.isBlank(this.projectGroupId)) {
                prompter.addPrompt("Set the project groupId: ", DEFAULT_GROUP_ID, input -> {
                    this.projectGroupId = input;
                });
            }
            if (CreateProjectMojo.isBlank(this.projectArtifactId)) {
                prompter.addPrompt("Set the project artifactId: ", DEFAULT_ARTIFACT_ID, input -> {
                    this.projectArtifactId = input;
                });
            }
            if (CreateProjectMojo.isBlank(this.projectVersion)) {
                prompter.addPrompt("Set the project version: ", DEFAULT_VERSION, input -> {
                    this.projectVersion = input;
                });
            }
            if (!this.noCode && CreateProjectMojo.isBlank(this.example)) {
                if (this.extensions.isEmpty()) {
                    prompter.addPrompt("What extensions do you wish to add (comma separated list): ", DEFAULT_EXTENSIONS, input -> {
                        this.extensions = Arrays.stream(input.split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.toSet());
                    });
                }
                prompter.addPrompt("Would you like some code to start (yes), or just an empty Quarkus project (no): ", "yes", input -> {
                    this.noCode = input.startsWith("n");
                });
                prompter.collectInput();
            } else {
                this.setProperDefaults();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to get user input", (Exception)e);
        }
    }

    private void setProperDefaults() {
        if (CreateProjectMojo.isBlank(this.projectArtifactId)) {
            this.projectArtifactId = DEFAULT_ARTIFACT_ID;
        }
        if (CreateProjectMojo.isBlank(this.projectGroupId)) {
            this.projectGroupId = DEFAULT_GROUP_ID;
        }
        if (CreateProjectMojo.isBlank(this.projectVersion)) {
            this.projectVersion = DEFAULT_VERSION;
        }
    }

    private boolean shouldUseDefaults() {
        return this.projectArtifactId != null;
    }

    private void sanitizeOptions() {
        if (this.className != null) {
            this.className = this.className.replaceAll("\\.(java|kotlin|scala)$", "");
            int idx = this.className.lastIndexOf(46);
            if (idx >= 0 && CreateProjectMojo.isBlank(this.packageName)) {
                this.packageName = this.className.substring(0, idx);
                this.className = this.className.substring(idx + 1);
            }
            if (CreateProjectMojo.isBlank(this.path)) {
                this.path = "/hello";
            } else if (!this.path.startsWith("/")) {
                this.path = "/" + this.path;
            }
        }
    }

    private void printUserInstructions(File root) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"========================================================================================");
        this.getLog().info((CharSequence)Ansi.ansi().a("Your new application has been created in ").bold().a(root.getAbsolutePath()).boldOff().toString());
        this.getLog().info((CharSequence)Ansi.ansi().a("Navigate into this directory and launch your application with ").bold().fg(Ansi.Color.CYAN).a("mvn quarkus:dev").reset().toString());
        this.getLog().info((CharSequence)Ansi.ansi().a("Your application will be accessible on ").bold().fg(Ansi.Color.CYAN).a("http://localhost:8080").reset().toString());
        this.getLog().info((CharSequence)"========================================================================================");
        this.getLog().info((CharSequence)"");
    }

    public static String getPlatformVersion(AbstractMojo mojo, String version) {
        return CreateProjectMojo.isBlank(version) ? CreateProjectMojo.getPluginVersion(mojo) : version;
    }

    public static String getPlatformArtifactId(String artifactId) {
        return CreateProjectMojo.isBlank(artifactId) ? "quarkus-bom" : artifactId;
    }

    public static String getPlatformGroupId(AbstractMojo mojo, String groupId) {
        return CreateProjectMojo.isBlank(groupId) ? CreateProjectMojo.getPluginGroupId(mojo) : groupId;
    }

    private static String getPluginGroupId(AbstractMojo mojo) {
        return CreateProjectMojo.getPluginDescriptor(mojo).getGroupId();
    }

    private static String getPluginVersion(AbstractMojo mojo) {
        return CreateProjectMojo.getPluginDescriptor(mojo).getVersion();
    }

    private static PluginDescriptor getPluginDescriptor(AbstractMojo mojo) {
        return (PluginDescriptor)mojo.getPluginContext().get("pluginDescriptor");
    }

    private static boolean isBlank(String s) {
        return s == null || s.isBlank();
    }
}

