/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingState;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingStateCodec;
import io.vertx.core.json.jackson.DatabindCodec;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;

public class DatabindProcessingStateCodec
implements ProcessingStateCodec {
    private final ObjectReader reader;
    private final ObjectWriter writer;

    public DatabindProcessingStateCodec(ObjectReader reader, ObjectWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public ProcessingState<?> decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (ProcessingState)this.reader.readValue(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encode(ProcessingState<?> object) {
        try {
            return this.writer.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @ApplicationScoped
    public static class Factory
    implements ProcessingStateCodec.Factory {
        public ProcessingStateCodec create(Class<?> stateType) {
            ObjectMapper mapper = DatabindCodec.mapper();
            TypeFactory typeFactory = mapper.getTypeFactory();
            JavaType javaType = stateType != null ? typeFactory.constructParametricType(ProcessingState.class, new Class[]{stateType}) : typeFactory.constructType(ProcessingState.class);
            ObjectReader reader = mapper.readerFor(javaType);
            ObjectWriter writer = mapper.writerFor(javaType);
            return new DatabindProcessingStateCodec(reader, writer);
        }
    }
}

