/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.security.identity.SecurityIdentity;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Priority(value=2)
@Alternative
@RequestScoped
public class VertxJwtPrincipalProducer {
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    JsonWebToken currentJWTPrincipalOrNull() {
        if (this.identity.isAnonymous()) {
            return new NullJsonWebToken();
        }
        if (this.identity.getPrincipal() instanceof JsonWebToken) {
            return (JsonWebToken)this.identity.getPrincipal();
        }
        throw new IllegalStateException("Current principal " + this.identity.getPrincipal() + " is not a JSON web token");
    }

    private static class NullJsonWebToken
    implements JsonWebToken {
        private NullJsonWebToken() {
        }

        public String getName() {
            return null;
        }

        public Set<String> getClaimNames() {
            return null;
        }

        public <T> T getClaim(String claimName) {
            return null;
        }
    }
}

