/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.oidc.OidcConfig;
import io.quarkus.oidc.VertxOAuth2AuthenticationMechanism;
import io.quarkus.oidc.VertxOAuth2IdentityProvider;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.providers.KeycloakAuth;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;

@Recorder
public class VertxKeycloakRecorder {
    public void setup(OidcConfig config, RuntimeValue<Vertx> vertx, BeanContainer beanContainer) {
        OAuth2ClientOptions options = new OAuth2ClientOptions();
        options.setSite(config.authServerUrl);
        if (config.introspectionPath.isPresent()) {
            options.setIntrospectionPath(config.introspectionPath.get());
        }
        if (config.jwksPath.isPresent()) {
            options.setJwkPath(config.jwksPath.get());
        }
        if (config.clientId.isPresent()) {
            options.setClientID(config.clientId.get());
        }
        if (config.credentials.secret.isPresent()) {
            options.setClientSecret(config.credentials.secret.get());
        }
        if (config.publicKey.isPresent()) {
            options.addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setPublicKey(config.publicKey.get()));
        }
        final CompletableFuture cf = new CompletableFuture();
        KeycloakAuth.discover((Vertx)((Vertx)vertx.getValue()), (OAuth2ClientOptions)options, (Handler)new Handler<AsyncResult<OAuth2Auth>>(){

            public void handle(AsyncResult<OAuth2Auth> event) {
                if (event.failed()) {
                    cf.completeExceptionally(event.cause());
                } else {
                    cf.complete(event.result());
                }
            }
        });
        OAuth2Auth auth = (OAuth2Auth)cf.join();
        ((VertxOAuth2IdentityProvider)beanContainer.instance(VertxOAuth2IdentityProvider.class, new Annotation[0])).setAuth(auth);
        VertxOAuth2AuthenticationMechanism mechanism = (VertxOAuth2AuthenticationMechanism)beanContainer.instance(VertxOAuth2AuthenticationMechanism.class, new Annotation[0]);
        mechanism.setAuth(auth);
        mechanism.setAuthServerURI(config.authServerUrl);
        mechanism.setConfig(config);
    }
}

