/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.runtime.OidcConfig;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public final class OidcUtils {
    private OidcUtils() {
    }

    public static List<String> findRoles(String clientId, OidcConfig.Roles rolesConfig, JsonObject json) throws Exception {
        if (rolesConfig.getRoleClaimPath().isPresent()) {
            return OidcUtils.findClaimWithRoles(rolesConfig, rolesConfig.getRoleClaimPath().get(), json, true);
        }
        List<String> groups = OidcUtils.findClaimWithRoles(rolesConfig, "groups", json, false);
        if (!groups.isEmpty()) {
            return groups.stream().map(v -> v.toString()).collect(Collectors.toList());
        }
        LinkedList<String> allRoles = new LinkedList<String>();
        allRoles.addAll(OidcUtils.findClaimWithRoles(rolesConfig, "realm_access/roles", json, false));
        if (clientId != null) {
            allRoles.addAll(OidcUtils.findClaimWithRoles(rolesConfig, "resource_access/" + clientId + "/roles", json, false));
        }
        return allRoles;
    }

    private static List<String> findClaimWithRoles(OidcConfig.Roles rolesConfig, String claimPath, JsonObject json, boolean mustExist) {
        Object claimValue = OidcUtils.findClaimValue(claimPath, json, claimPath.split("/"), 0, mustExist);
        if (claimValue instanceof JsonArray) {
            return ((JsonArray)claimValue).stream().map(v -> v.toString()).collect(Collectors.toList());
        }
        if (claimValue != null) {
            String sep = rolesConfig.getRoleClaimSeparator().isPresent() ? rolesConfig.getRoleClaimSeparator().get() : " ";
            return Arrays.asList(claimValue.toString().split(sep));
        }
        return Collections.emptyList();
    }

    private static Object findClaimValue(String claimPath, JsonObject json, String[] pathArray, int step, boolean mustExist) {
        Object claimValue = json.getValue(pathArray[step]);
        if (claimValue == null) {
            if (mustExist) {
                throw new OIDCException("No claim exists at the path " + claimPath + " at the path segment " + pathArray[step]);
            }
        } else if (step + 1 < pathArray.length) {
            if (claimValue instanceof JsonObject) {
                int nextStep = step + 1;
                return OidcUtils.findClaimValue(claimPath, (JsonObject)claimValue, pathArray, nextStep, mustExist);
            }
            throw new OIDCException("Claim value at the path " + claimPath + " is not a json object");
        }
        return claimValue;
    }
}

