/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class OidcConfig {
    @ConfigItem
    String authServerUrl;
    @ConfigItem
    Optional<String> introspectionPath;
    @ConfigItem
    Optional<String> jwksPath;
    @ConfigItem
    Optional<String> publicKey;
    @ConfigItem
    Optional<String> clientId;
    @ConfigItem
    public Optional<Duration> connectionDelay;
    @ConfigItem
    Roles roles;
    @ConfigItem
    Token token;
    @ConfigItem
    Credentials credentials;
    Authentication authentication;

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Roles getRoles() {
        return this.roles;
    }

    @ConfigGroup
    public static class Token {
        @ConfigItem
        public Optional<String> issuer;
        @ConfigItem
        public Optional<List<String>> audience;

        public static Token fromIssuer(String issuer) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.of(issuer);
            tokenClaims.audience = Optional.ofNullable(null);
            return tokenClaims;
        }

        public static Token fromAudience(String ... audience) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.ofNullable(null);
            tokenClaims.audience = Optional.of(Arrays.asList(audience));
            return tokenClaims;
        }
    }

    @ConfigGroup
    public static class Authentication {
        @ConfigItem
        public Optional<String> redirectPath;
        @ConfigItem
        public Optional<List<String>> scopes;
    }

    @ConfigGroup
    public static class Roles {
        @ConfigItem
        Optional<String> roleClaimPath;
        @ConfigItem
        Optional<String> roleClaimSeparator;

        public Optional<String> getRoleClaimPath() {
            return this.roleClaimPath;
        }

        public Optional<String> getRoleClaimSeparator() {
            return this.roleClaimSeparator;
        }

        public static Roles fromClaimPath(String path) {
            return Roles.fromClaimPathAndSeparator(path, null);
        }

        public static Roles fromClaimPathAndSeparator(String path, String sep) {
            Roles roles = new Roles();
            roles.roleClaimPath = Optional.ofNullable(path);
            roles.roleClaimSeparator = Optional.ofNullable(sep);
            return roles;
        }
    }

    @ConfigGroup
    public static class Credentials {
        @ConfigItem
        Optional<String> secret;

        public Optional<String> getSecret() {
            return this.secret;
        }
    }
}

