/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import java.security.Principal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    private volatile OAuth2Auth auth;
    private volatile OidcConfig config;

    public OAuth2Auth getAuth() {
        return this.auth;
    }

    public OidcIdentityProvider setAuth(OAuth2Auth auth) {
        this.auth = auth;
        return this;
    }

    public OidcIdentityProvider setConfig(OidcConfig config) {
        this.config = config;
        return this;
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public CompletionStage<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        final CompletableFuture<SecurityIdentity> result = new CompletableFuture<SecurityIdentity>();
        this.auth.decodeToken(request.getToken().getToken(), (Handler)new Handler<AsyncResult<AccessToken>>(){

            public void handle(AsyncResult<AccessToken> event) {
                OidcJwtCallerPrincipal jwtPrincipal;
                if (event.failed()) {
                    result.completeExceptionally((Throwable)new AuthenticationFailedException());
                    return;
                }
                AccessToken token = (AccessToken)event.result();
                try {
                    OidcUtils.validateClaims(((OidcIdentityProvider)OidcIdentityProvider.this).config.token, token.accessToken());
                }
                catch (OIDCException e) {
                    result.completeExceptionally((Throwable)new AuthenticationFailedException((Throwable)e));
                    return;
                }
                QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                try {
                    jwtPrincipal = new OidcJwtCallerPrincipal(JwtClaims.parse((String)token.accessToken().encode()));
                }
                catch (InvalidJwtException e) {
                    result.completeExceptionally((Throwable)new AuthenticationFailedException((Throwable)e));
                    return;
                }
                builder.setPrincipal((Principal)((Object)jwtPrincipal));
                try {
                    String clientId = OidcIdentityProvider.this.config.getClientId().isPresent() ? OidcIdentityProvider.this.config.getClientId().get() : null;
                    for (String role : OidcUtils.findRoles(clientId, OidcIdentityProvider.this.config.getRoles(), token.accessToken())) {
                        builder.addRole(role);
                    }
                }
                catch (Exception e) {
                    result.completeExceptionally((Throwable)new ForbiddenException((Throwable)e));
                    return;
                }
                builder.addCredential((Credential)request.getToken());
                result.complete(builder.build());
            }
        });
        return result;
    }
}

