/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcBuildTimeConfig;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcIdentityProvider;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.providers.KeycloakAuth;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import org.jboss.logging.Logger;

@Recorder
public class OidcRecorder {
    private static final Logger LOG = Logger.getLogger(OidcRecorder.class);

    public void setup(OidcConfig config, OidcBuildTimeConfig btConfig, RuntimeValue<Vertx> vertx, BeanContainer beanContainer) {
        long connectionRetryCount;
        OAuth2ClientOptions options = new OAuth2ClientOptions();
        options.setSite(config.authServerUrl);
        if (config.introspectionPath.isPresent()) {
            options.setIntrospectionPath(config.introspectionPath.get());
        }
        if (config.jwksPath.isPresent()) {
            options.setJwkPath(config.jwksPath.get());
        }
        if (config.clientId.isPresent()) {
            options.setClientID(config.clientId.get());
        }
        if (config.credentials.secret.isPresent()) {
            options.setClientSecret(config.credentials.secret.get());
        }
        if (config.publicKey.isPresent()) {
            options.addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setPublicKey(config.publicKey.get()));
        }
        if (config.token.issuer.isPresent()) {
            options.setValidateIssuer(false);
        }
        long connectionDelayInSecs = config.connectionDelay.isPresent() ? config.connectionDelay.get().toMillis() / 1000L : 0L;
        long l = connectionRetryCount = connectionDelayInSecs > 1L ? connectionDelayInSecs / 2L : 1L;
        if (connectionRetryCount > 1L) {
            LOG.infof("Connecting to IDP for up to %d times every 2 seconds", (Object)connectionRetryCount);
        }
        OAuth2Auth auth = null;
        for (long i = 0L; i < connectionRetryCount; ++i) {
            try {
                final CompletableFuture cf = new CompletableFuture();
                KeycloakAuth.discover((Vertx)((Vertx)vertx.getValue()), (OAuth2ClientOptions)options, (Handler)new Handler<AsyncResult<OAuth2Auth>>(){

                    public void handle(AsyncResult<OAuth2Auth> event) {
                        if (event.failed()) {
                            cf.completeExceptionally(OidcRecorder.toOidcException(event.cause()));
                        } else {
                            cf.complete(event.result());
                        }
                    }
                });
                auth = (OAuth2Auth)cf.join();
                break;
            }
            catch (OIDCException ex) {
                if (i + 1L < connectionRetryCount) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw ex;
            }
        }
        OidcIdentityProvider identityProvider = (OidcIdentityProvider)beanContainer.instance(OidcIdentityProvider.class, new Annotation[0]);
        identityProvider.setAuth(auth);
        identityProvider.setConfig(config);
        AbstractOidcAuthenticationMechanism mechanism = null;
        if (OidcBuildTimeConfig.ApplicationType.SERVICE.equals((Object)btConfig.applicationType)) {
            mechanism = (AbstractOidcAuthenticationMechanism)beanContainer.instance(BearerAuthenticationMechanism.class, new Annotation[0]);
        } else if (OidcBuildTimeConfig.ApplicationType.WEB_APP.equals((Object)btConfig.applicationType)) {
            mechanism = (AbstractOidcAuthenticationMechanism)beanContainer.instance(CodeAuthenticationMechanism.class, new Annotation[0]);
        }
        mechanism.setAuth(auth, config);
    }

    protected static OIDCException toOidcException(Throwable cause) {
        String message = "OIDC server is not available at the 'quarkus.oidc.auth-server-url' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'";
        return new OIDCException("OIDC server is not available at the 'quarkus.oidc.auth-server-url' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'", cause);
    }
}

