/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.ext.web.RoutingContext;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class DefaultTokenStateManager
implements TokenStateManager {
    private static final String SESSION_AT_COOKIE_NAME = "q_session_at";
    private static final String SESSION_RT_COOKIE_NAME = "q_session_rt";

    @Override
    public String createTokenState(RoutingContext routingContext, OidcTenantConfig oidcConfig, AuthorizationCodeTokens tokens) {
        StringBuilder sb = new StringBuilder();
        sb.append(tokens.getIdToken());
        if (oidcConfig.tokenStateManager.strategy == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (!oidcConfig.tokenStateManager.splitTokens) {
                sb.append("|").append(tokens.getAccessToken()).append("|").append(tokens.getRefreshToken());
            } else {
                CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig.getTenantId().get()), tokens.getAccessToken(), (Long)routingContext.get("session-max-age"));
                if (tokens.getRefreshToken() != null) {
                    CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig.getTenantId().get()), tokens.getRefreshToken(), (Long)routingContext.get("session-max-age"));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public AuthorizationCodeTokens getTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState) {
        String[] tokens = CodeAuthenticationMechanism.COOKIE_PATTERN.split(tokenState);
        String idToken = tokens[0];
        String accessToken = null;
        String refreshToken = null;
        if (oidcConfig.tokenStateManager.strategy == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (!oidcConfig.tokenStateManager.splitTokens) {
                accessToken = tokens[1];
                refreshToken = tokens[2];
            } else {
                ServerCookie rtCookie;
                ServerCookie atCookie = DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig);
                if (atCookie != null) {
                    accessToken = atCookie.getValue();
                }
                if ((rtCookie = DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig)) != null) {
                    refreshToken = rtCookie.getValue();
                }
            }
        }
        return new AuthorizationCodeTokens(idToken, accessToken, refreshToken);
    }

    @Override
    public void deleteTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState) {
        if (oidcConfig.tokenStateManager.splitTokens) {
            CodeAuthenticationMechanism.removeCookie(DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig), oidcConfig);
            CodeAuthenticationMechanism.removeCookie(DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig), oidcConfig);
        }
    }

    private static ServerCookie getAccessTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        return (ServerCookie)routingContext.request().getCookie(DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig.getTenantId().get()));
    }

    private static ServerCookie getRefreshTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        return (ServerCookie)routingContext.request().getCookie(DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig.getTenantId().get()));
    }

    private static String getAccessTokenCookieName(String tenantId) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(tenantId);
        return SESSION_AT_COOKIE_NAME + cookieSuffix;
    }

    private static String getRefreshTokenCookieName(String tenantId) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(tenantId);
        return SESSION_RT_COOKIE_NAME + cookieSuffix;
    }
}

