/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.JsonWebKeyCache;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import org.jboss.logging.Logger;

public class OidcProviderClient {
    private static final Logger LOG = Logger.getLogger(OidcProviderClient.class);
    private static final Duration REQUEST_RETRY_BACKOFF_DURATION = Duration.ofSeconds(1L);
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private final WebClient client;
    private final OidcConfigurationMetadata metadata;
    private final OidcTenantConfig oidcConfig;
    private final String clientSecretBasicAuthScheme;
    private final Key clientJwtKey;

    public OidcProviderClient(WebClient client, OidcConfigurationMetadata metadata, OidcTenantConfig oidcConfig) {
        this.client = client;
        this.metadata = metadata;
        this.oidcConfig = oidcConfig;
        this.clientSecretBasicAuthScheme = OidcCommonUtils.initClientSecretBasicAuth((OidcCommonConfig)oidcConfig);
        this.clientJwtKey = OidcCommonUtils.initClientJwtKey((OidcCommonConfig)oidcConfig);
    }

    public OidcConfigurationMetadata getMetadata() {
        return this.metadata;
    }

    public Uni<JsonWebKeyCache> getJsonWebKeySet() {
        return this.client.getAbs(this.metadata.getJsonWebKeySetUri()).send().onItem().transform(resp -> this.getJsonWebKeyCache((HttpResponse<Buffer>)resp));
    }

    public Uni<JsonObject> getUserInfo(String token) {
        return this.client.postAbs(this.metadata.getUserInfoUri()).putHeader(AUTHORIZATION_HEADER, "Bearer " + token).send().onItem().transform(resp -> this.getUserInfo((HttpResponse<Buffer>)resp));
    }

    public Uni<JsonObject> introspectToken(String token) {
        MultiMap introspectionParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        introspectionParams.add("token", token);
        introspectionParams.add("token_type_hint", "access_token");
        return this.getHttpResponse(this.metadata.getIntrospectionUri(), introspectionParams).transform(resp -> this.getTokenIntrospection((HttpResponse<Buffer>)resp));
    }

    private JsonWebKeyCache getJsonWebKeyCache(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            return new JsonWebKeyCache(resp.bodyAsString(StandardCharsets.UTF_8.name()));
        }
        throw new OIDCException();
    }

    public OidcTenantConfig getOidcConfig() {
        return this.oidcConfig;
    }

    public Uni<AuthorizationCodeTokens> getAuthorizationCodeTokens(String code, String redirectUri) {
        MultiMap codeGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        codeGrantParams.add("grant_type", "authorization_code");
        codeGrantParams.add("code", code);
        codeGrantParams.add("redirect_uri", redirectUri);
        return this.getHttpResponse(this.metadata.getTokenUri(), codeGrantParams).transform(resp -> this.getAuthorizationCodeTokens((HttpResponse<Buffer>)resp));
    }

    public Uni<AuthorizationCodeTokens> refreshAuthorizationCodeTokens(String refreshToken) {
        MultiMap refreshGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        refreshGrantParams.add("grant_type", "refresh_token");
        refreshGrantParams.add("refresh_token", refreshToken);
        return this.getHttpResponse(this.metadata.getTokenUri(), refreshGrantParams).transform(resp -> this.getAuthorizationCodeTokens((HttpResponse<Buffer>)resp));
    }

    private UniOnItem<HttpResponse<Buffer>> getHttpResponse(String uri, MultiMap formBody) {
        HttpRequest request = this.client.postAbs(uri);
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
        if (this.clientSecretBasicAuthScheme != null) {
            request.putHeader(AUTHORIZATION_HEADER, this.clientSecretBasicAuthScheme);
        } else if (this.clientJwtKey != null) {
            formBody.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            formBody.add("client_assertion", OidcCommonUtils.signJwtWithKey((OidcCommonConfig)this.oidcConfig, (Key)this.clientJwtKey));
        } else if (OidcCommonUtils.isClientSecretPostAuthRequired((OidcCommonConfig.Credentials)this.oidcConfig.credentials)) {
            formBody.add("client_id", (String)this.oidcConfig.clientId.get());
            formBody.add("client_secret", OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)this.oidcConfig.credentials));
        } else {
            formBody.add("client_id", (String)this.oidcConfig.clientId.get());
        }
        Uni response = request.sendBuffer(OidcCommonUtils.encodeForm((MultiMap)formBody)).onFailure(ConnectException.class).retry().atMost(3L);
        return response.onItem();
    }

    private AuthorizationCodeTokens getAuthorizationCodeTokens(HttpResponse<Buffer> resp) {
        JsonObject json = this.getJsonObject(resp);
        String idToken = json.getString("id_token");
        String accessToken = json.getString("access_token");
        String refreshToken = json.getString("refresh_token");
        return new AuthorizationCodeTokens(idToken, accessToken, refreshToken);
    }

    private JsonObject getUserInfo(HttpResponse<Buffer> resp) {
        return this.getJsonObject(resp);
    }

    private JsonObject getTokenIntrospection(HttpResponse<Buffer> resp) {
        return this.getJsonObject(resp);
    }

    private JsonObject getJsonObject(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            return resp.bodyAsJsonObject();
        }
        String errorMessage = resp.bodyAsString();
        LOG.debugf("Request has failed: status: %d, error message: %s", resp.statusCode(), (Object)errorMessage);
        throw new OIDCException(errorMessage);
    }
}

