/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.runtime.ContextAwareTokenCredential;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    @Inject
    DefaultTenantConfigResolver tenantResolver;

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public CompletionStage<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<SecurityIdentity>(){

            @Override
            public SecurityIdentity get() {
                final CompletableFuture result = new CompletableFuture();
                final ContextAwareTokenCredential credential = (ContextAwareTokenCredential)request.getToken();
                RoutingContext vertxContext = credential.getContext();
                TenantConfigContext resolvedContext = OidcIdentityProvider.this.tenantResolver.resolve(vertxContext);
                final OidcTenantConfig config = resolvedContext.oidcConfig;
                resolvedContext.auth.decodeToken(request.getToken().getToken(), (Handler)new Handler<AsyncResult<AccessToken>>(){

                    public void handle(AsyncResult<AccessToken> event) {
                        OidcJwtCallerPrincipal jwtPrincipal;
                        if (event.failed()) {
                            result.completeExceptionally((Throwable)new AuthenticationFailedException());
                            return;
                        }
                        AccessToken token = (AccessToken)event.result();
                        try {
                            OidcUtils.validateClaims(config.getToken(), token.accessToken());
                        }
                        catch (OIDCException e) {
                            result.completeExceptionally((Throwable)new AuthenticationFailedException((Throwable)e));
                            return;
                        }
                        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                        builder.addCredential((Credential)request.getToken());
                        try {
                            JwtClaims jwtClaims = JwtClaims.parse((String)token.accessToken().encode());
                            jwtClaims.setClaim(Claims.raw_token.name(), (Object)credential.getToken());
                            jwtPrincipal = new OidcJwtCallerPrincipal(jwtClaims, request.getToken(), config.token.principalClaim.isPresent() ? config.token.principalClaim.get() : null);
                        }
                        catch (InvalidJwtException e) {
                            result.completeExceptionally((Throwable)new AuthenticationFailedException((Throwable)e));
                            return;
                        }
                        builder.setPrincipal((Principal)((Object)jwtPrincipal));
                        try {
                            String clientId = config.getClientId().isPresent() ? config.getClientId().get() : null;
                            for (String role : OidcUtils.findRoles(clientId, config.getRoles(), token.accessToken())) {
                                builder.addRole(role);
                            }
                        }
                        catch (Exception e) {
                            result.completeExceptionally((Throwable)new ForbiddenException((Throwable)e));
                            return;
                        }
                        result.complete(builder.build());
                    }
                });
                return (SecurityIdentity)result.join();
            }
        });
    }
}

