/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_TENANT_CONFIG = "io.quarkus.oidc.current.tenant.config";
    @Inject
    Instance<TenantResolver> tenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    private volatile Map<String, TenantConfigContext> staticTenantsConfig;
    private volatile TenantConfigContext defaultTenant;
    private volatile Function<OidcTenantConfig, TenantConfigContext> tenantConfigContextFactory;
    private volatile Map<String, TenantConfigContext> dynamicTenantsConfig;

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable()) {
            if (this.tenantConfigResolver.isAmbiguous()) {
                throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
            }
            this.dynamicTenantsConfig = new HashMap<String, TenantConfigContext>();
        }
        if (this.tenantResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
        }
    }

    TenantConfigContext resolve(RoutingContext context, boolean create) {
        TenantConfigContext config = this.getTenantConfigFromConfigResolver(context, create);
        if (config == null) {
            config = this.getTenantConfigFromTenantResolver(context);
        }
        return config;
    }

    void setTenantsConfig(Map<String, TenantConfigContext> tenantsConfig) {
        this.staticTenantsConfig = tenantsConfig;
    }

    void setDefaultTenant(TenantConfigContext defaultTenant) {
        this.defaultTenant = defaultTenant;
    }

    void setTenantConfigContextFactory(Function<OidcTenantConfig, TenantConfigContext> tenantConfigContextFactory) {
        this.tenantConfigContextFactory = tenantConfigContextFactory;
    }

    private TenantConfigContext getTenantConfigFromTenantResolver(RoutingContext context) {
        TenantConfigContext configContext;
        if (this.staticTenantsConfig == null) {
            throw new IllegalStateException("staticTenantsConfig is null");
        }
        String tenantId = null;
        if (this.tenantResolver.isResolvable()) {
            tenantId = ((TenantResolver)this.tenantResolver.get()).resolve(context);
        }
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.staticTenantsConfig.get(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty()) {
                LOG.debugf("No configuration with a tenant id '%s' has been found, using the default configuration", new Object[0]);
            }
            configContext = this.defaultTenant;
        }
        return configContext;
    }

    boolean isBlocking(RoutingContext context) {
        return this.getTenantConfigFromConfigResolver(context, false) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TenantConfigContext getTenantConfigFromConfigResolver(RoutingContext context, boolean create) {
        if (this.tenantConfigResolver.isResolvable()) {
            OidcTenantConfig tenantConfig;
            if (context.get(CURRENT_TENANT_CONFIG) != null) {
                tenantConfig = (OidcTenantConfig)context.get(CURRENT_TENANT_CONFIG);
            } else {
                OidcTenantConfig newTenantConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context);
                if (newTenantConfig != null && !newTenantConfig.tenantEnabled) {
                    newTenantConfig = null;
                }
                tenantConfig = newTenantConfig;
                context.put(CURRENT_TENANT_CONFIG, (Object)tenantConfig);
            }
            if (tenantConfig != null) {
                String tenantId = tenantConfig.getTenantId().orElseThrow(() -> new IllegalStateException("You must provide a tenant id"));
                TenantConfigContext tenantContext = this.dynamicTenantsConfig.get(tenantId);
                if (tenantContext == null && create) {
                    Map<String, TenantConfigContext> map = this.dynamicTenantsConfig;
                    synchronized (map) {
                        return this.dynamicTenantsConfig.computeIfAbsent(tenantId, clientId -> this.tenantConfigContextFactory.apply(tenantConfig));
                    }
                }
                return tenantContext;
            }
        }
        return null;
    }
}

