/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public class OidcTenantConfig {
    @ConfigItem
    Optional<String> tenantId = Optional.empty();
    @ConfigItem(defaultValue="true")
    public boolean tenantEnabled = true;
    @ConfigItem(defaultValue="service")
    public ApplicationType applicationType;
    @ConfigItem
    public Optional<Duration> connectionDelay = Optional.empty();
    @ConfigItem
    Optional<String> authServerUrl = Optional.empty();
    @ConfigItem
    Optional<String> introspectionPath = Optional.empty();
    @ConfigItem
    Optional<String> jwksPath = Optional.empty();
    @ConfigItem
    Optional<String> publicKey = Optional.empty();
    @ConfigItem
    Optional<String> clientId = Optional.empty();
    @ConfigItem
    Roles roles = new Roles();
    @ConfigItem
    Token token = new Token();
    @ConfigItem
    Credentials credentials = new Credentials();
    Authentication authentication = new Authentication();

    public Optional<Duration> getConnectionDelay() {
        return this.connectionDelay;
    }

    public void setConnectionDelay(Duration connectionDelay) {
        this.connectionDelay = Optional.of(connectionDelay);
    }

    public Optional<String> getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = Optional.of(authServerUrl);
    }

    public Optional<String> getIntrospectionPath() {
        return this.introspectionPath;
    }

    public void setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = Optional.of(introspectionPath);
    }

    public Optional<String> getJwksPath() {
        return this.jwksPath;
    }

    public void setJwksPath(String jwksPath) {
        this.jwksPath = Optional.of(jwksPath);
    }

    public Optional<String> getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = Optional.of(publicKey);
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = Optional.of(clientId);
    }

    public Roles getRoles() {
        return this.roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Optional<String> getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = Optional.of(tenantId);
    }

    public static enum ApplicationType {
        WEB_APP,
        SERVICE;

    }

    @ConfigGroup
    public static class Token {
        @ConfigItem
        public Optional<String> issuer = Optional.empty();
        @ConfigItem
        public Optional<List<String>> audience = Optional.empty();
        @ConfigItem
        public Optional<Integer> expirationGrace = Optional.empty();
        @ConfigItem
        public Optional<String> principalClaim = Optional.empty();

        public static Token fromIssuer(String issuer) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.of(issuer);
            tokenClaims.audience = Optional.ofNullable(null);
            return tokenClaims;
        }

        public static Token fromAudience(String ... audience) {
            Token tokenClaims = new Token();
            tokenClaims.issuer = Optional.ofNullable(null);
            tokenClaims.audience = Optional.of(Arrays.asList(audience));
            return tokenClaims;
        }

        public Optional<String> getIssuer() {
            return this.issuer;
        }

        public void setIssuer(String issuer) {
            this.issuer = Optional.of(issuer);
        }

        public Optional<List<String>> getAudience() {
            return this.audience;
        }

        public void setAudience(List<String> audience) {
            this.audience = Optional.of(audience);
        }

        public Optional<Integer> getExpirationGrace() {
            return this.expirationGrace;
        }

        public void setExpirationGrace(int expirationGrace) {
            this.expirationGrace = Optional.of(expirationGrace);
        }

        public Optional<String> getPrincipalClaim() {
            return this.principalClaim;
        }

        public void setPrincipalClaim(String principalClaim) {
            this.principalClaim = Optional.of(principalClaim);
        }
    }

    @ConfigGroup
    public static class Authentication {
        @ConfigItem
        public Optional<String> redirectPath = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean restorePathAfterRedirect;
        @ConfigItem
        public Optional<List<String>> scopes = Optional.empty();
        @ConfigItem
        public Map<String, String> extraParams;
        @ConfigItem
        public Optional<String> cookiePath = Optional.empty();

        public Optional<String> getRedirectPath() {
            return this.redirectPath;
        }

        public void setRedirectPath(String redirectPath) {
            this.redirectPath = Optional.of(redirectPath);
        }

        public Optional<List<String>> getScopes() {
            return this.scopes;
        }

        public void setScopes(Optional<List<String>> scopes) {
            this.scopes = scopes;
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public boolean isRestorePathAfterRedirect() {
            return this.restorePathAfterRedirect;
        }

        public void setRestorePathAfterRedirect(boolean restorePathAfterRedirect) {
            this.restorePathAfterRedirect = restorePathAfterRedirect;
        }

        public Optional<String> getCookiePath() {
            return this.cookiePath;
        }

        public void setCookiePath(Optional<String> cookiePath) {
            this.cookiePath = cookiePath;
        }
    }

    @ConfigGroup
    public static class Roles {
        @ConfigItem
        Optional<String> roleClaimPath = Optional.empty();
        @ConfigItem
        Optional<String> roleClaimSeparator = Optional.empty();

        public static Roles fromClaimPath(String path) {
            return Roles.fromClaimPathAndSeparator(path, null);
        }

        public static Roles fromClaimPathAndSeparator(String path, String sep) {
            Roles roles = new Roles();
            roles.roleClaimPath = Optional.ofNullable(path);
            roles.roleClaimSeparator = Optional.ofNullable(sep);
            return roles;
        }

        public Optional<String> getRoleClaimPath() {
            return this.roleClaimPath;
        }

        public void setRoleClaimPath(String roleClaimPath) {
            this.roleClaimPath = Optional.of(roleClaimPath);
        }

        public Optional<String> getRoleClaimSeparator() {
            return this.roleClaimSeparator;
        }

        public void setRoleClaimSeparator(String roleClaimSeparator) {
            this.roleClaimSeparator = Optional.of(roleClaimSeparator);
        }
    }

    @ConfigGroup
    public static class Credentials {
        @ConfigItem
        Optional<String> secret = Optional.empty();
        @ConfigItem
        Secret clientSecret = new Secret();

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public Secret getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(Secret clientSecret) {
            this.clientSecret = clientSecret;
        }

        @ConfigGroup
        public static class Secret {
            @ConfigItem
            Optional<String> value = Optional.empty();
            @ConfigItem
            Optional<Method> method = Optional.empty();

            public Optional<String> getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = Optional.of(value);
            }

            public Optional<Method> getMethod() {
                return this.method;
            }

            public void setMethod(Method method) {
                this.method = Optional.of(method);
            }

            public static enum Method {
                BASIC,
                POST;

            }
        }
    }
}

