/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.AuthenticationCompletionException;
import io.quarkus.vertx.http.runtime.security.AuthenticationRedirectException;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private static final String STATE_COOKIE_NAME = "q_auth";
    private static final String SESSION_COOKIE_NAME = "q_session";
    private static final String COOKIE_DELIM = "___";

    private static QuarkusSecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, String accessToken, String refreshToken, RoutingContext context) {
        RefreshToken refreshTokenCredential = new RefreshToken(refreshToken);
        return QuarkusSecurityIdentity.builder().setPrincipal(securityIdentity.getPrincipal()).addCredentials(securityIdentity.getCredentials()).addCredential((Credential)new AccessTokenCredential(accessToken, refreshTokenCredential, context)).addCredential((Credential)refreshTokenCredential).addRoles(securityIdentity.getRoles()).addAttributes(securityIdentity.getAttributes()).addPermissionChecker((Function)new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission permission) {
                return securityIdentity.checkPermission(permission);
            }
        }).build();
    }

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, IdentityProviderManager identityProviderManager, DefaultTenantConfigResolver resolver) {
        io.vertx.core.http.Cookie sessionCookie = context.request().getCookie(SESSION_COOKIE_NAME);
        if (sessionCookie != null) {
            final String[] tokens = sessionCookie.getValue().split(COOKIE_DELIM);
            return this.authenticate(identityProviderManager, new IdTokenCredential(tokens[0], context)).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                @Override
                public SecurityIdentity apply(SecurityIdentity securityIdentity) {
                    return CodeAuthenticationMechanism.augmentIdentity(securityIdentity, tokens[1], tokens[2], context);
                }
            });
        }
        return this.performCodeFlow(identityProviderManager, context, resolver);
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context, DefaultTenantConfigResolver resolver) {
        TenantConfigContext configContext = resolver.resolve(context, false);
        this.removeCookie(context, configContext, SESSION_COOKIE_NAME);
        JsonObject params = new JsonObject();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        configContext.oidcConfig.getAuthentication().scopes.ifPresent(scopes::addAll);
        params.put("scopes", new JsonArray(scopes));
        URI absoluteUri = URI.create(context.request().absoluteURI());
        String redirectPath = this.getRedirectPath(configContext, absoluteUri);
        String redirectUriParam = this.buildRedirectUri(context, absoluteUri, redirectPath);
        LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        params.put("state", this.generateState(context, configContext, absoluteUri, redirectPath));
        if (configContext.oidcConfig.authentication.getExtraParams() != null) {
            for (Map.Entry<String, String> entry : configContext.oidcConfig.authentication.getExtraParams().entrySet()) {
                params.put(entry.getKey(), entry.getValue());
            }
        }
        ChallengeData challenge = new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, configContext.auth.authorizeURL(params));
        return Uni.createFrom().item((Object)challenge);
    }

    private Uni<SecurityIdentity> performCodeFlow(final IdentityProviderManager identityProviderManager, final RoutingContext context, DefaultTenantConfigResolver resolver) {
        final TenantConfigContext configContext = resolver.resolve(context, true);
        final JsonObject params = new JsonObject();
        String code = context.request().getParam("code");
        if (code == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        URI absoluteUri = URI.create(context.request().absoluteURI());
        Cookie stateCookie = context.getCookie(STATE_COOKIE_NAME);
        if (stateCookie != null) {
            List values = context.queryParam("state");
            if (values.size() != 1) {
                LOG.debug((Object)"State parameter can not be empty or multi-valued");
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
            }
            if (!stateCookie.getValue().startsWith((String)values.get(0))) {
                LOG.debug((Object)"State cookie does not match the state parameter");
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
            }
            if (context.queryParam("pathChecked").isEmpty()) {
                String[] pair = stateCookie.getValue().split(COOKIE_DELIM);
                if (pair.length == 2) {
                    String extraPath = pair[1];
                    String extraQuery = "?pathChecked=true";
                    if (absoluteUri.getRawQuery() != null) {
                        extraQuery = extraQuery + "&" + absoluteUri.getRawQuery();
                    }
                    String localRedirectUri = this.buildRedirectUri(context, absoluteUri, extraPath + extraQuery);
                    LOG.debugf("Local redirect URI: %s", (Object)localRedirectUri);
                    return Uni.createFrom().failure((Throwable)new AuthenticationRedirectException(localRedirectUri));
                }
                this.removeCookie(context, configContext, STATE_COOKIE_NAME);
            } else {
                this.removeCookie(context, configContext, STATE_COOKIE_NAME);
            }
        } else {
            LOG.debug((Object)"The state cookie is missing after a redirect from IDP");
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
        }
        params.put("code", code);
        String redirectPath = this.getRedirectPath(configContext, absoluteUri);
        String redirectUriParam = this.buildRedirectUri(context, absoluteUri, redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        OidcTenantConfig.Credentials creds = configContext.oidcConfig.getCredentials();
        if (creds.clientSecret.value.isPresent() && OidcTenantConfig.Credentials.Secret.Method.POST == creds.clientSecret.method.orElse(null)) {
            params.put("client_secret", creds.clientSecret.value.get());
        } else if (creds.jwt.secret.isPresent()) {
            params.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            params.put("client_assertion", this.signJwtWithClientSecret(configContext.oidcConfig));
        }
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                configContext.auth.authenticate(params, userAsyncResult -> {
                    if (userAsyncResult.failed()) {
                        if (userAsyncResult.cause() != null) {
                            LOG.debugf("Exception during the code to token exchange: %s", (Object)userAsyncResult.cause().getMessage());
                        }
                        uniEmitter.fail((Throwable)new AuthenticationCompletionException(userAsyncResult.cause()));
                    } else {
                        final AccessToken result = (AccessToken)AccessToken.class.cast(userAsyncResult.result());
                        CodeAuthenticationMechanism.this.authenticate(identityProviderManager, new IdTokenCredential(result.opaqueIdToken(), context)).subscribe().with((Consumer)new Consumer<SecurityIdentity>(){

                            @Override
                            public void accept(SecurityIdentity securityIdentity) {
                                if (!result.idToken().containsKey("exp") || !result.idToken().containsKey("iat")) {
                                    LOG.debug((Object)"ID Token is required to contain 'exp' and 'iat' claims");
                                    uniEmitter.fail((Throwable)new AuthenticationCompletionException());
                                }
                                CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, (UniEmitter<? super SecurityIdentity>)uniEmitter, result, securityIdentity);
                            }
                        }, (Consumer)new Consumer<Throwable>(){

                            @Override
                            public void accept(Throwable throwable) {
                                uniEmitter.fail(throwable);
                            }
                        });
                    }
                });
            }
        });
    }

    private String signJwtWithClientSecret(OidcTenantConfig cfg) {
        byte[] keyBytes = cfg.credentials.jwt.secret.get().getBytes(StandardCharsets.UTF_8);
        SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, "HMACSHA256");
        long iat = System.currentTimeMillis() / 1000L;
        long exp = iat + (long)cfg.credentials.jwt.lifespan;
        return Jwt.claims().issuer(cfg.clientId.get()).subject(cfg.clientId.get()).audience(cfg.authServerUrl.get()).issuedAt(iat).expiresAt(exp).sign((SecretKey)key);
    }

    private void processSuccessfulAuthentication(RoutingContext context, TenantConfigContext configContext, UniEmitter<? super SecurityIdentity> cf, AccessToken result, SecurityIdentity securityIdentity) {
        this.removeCookie(context, configContext, SESSION_COOKIE_NAME);
        CookieImpl cookie = new CookieImpl(SESSION_COOKIE_NAME, result.opaqueIdToken() + COOKIE_DELIM + result.opaqueAccessToken() + COOKIE_DELIM + result.opaqueRefreshToken());
        long maxAge = result.idToken().getLong("exp") - result.idToken().getLong("iat");
        if (configContext.oidcConfig.token.expirationGrace.isPresent()) {
            maxAge += (long)configContext.oidcConfig.token.expirationGrace.get().intValue();
        }
        LOG.debugf("Session cookie 'max-age' parameter is set to %d", maxAge);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(context.request().isSSL());
        cookie.setHttpOnly(true);
        if (configContext.oidcConfig.authentication.cookiePath.isPresent()) {
            cookie.setPath(configContext.oidcConfig.authentication.cookiePath.get());
        }
        context.response().addCookie((io.vertx.core.http.Cookie)cookie);
        cf.complete((Object)CodeAuthenticationMechanism.augmentIdentity(securityIdentity, result.opaqueAccessToken(), result.opaqueRefreshToken(), context));
    }

    private String getRedirectPath(TenantConfigContext configContext, URI absoluteUri) {
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        return auth.getRedirectPath().isPresent() ? auth.getRedirectPath().get() : absoluteUri.getRawPath();
    }

    private String generateState(RoutingContext context, TenantConfigContext configContext, URI absoluteUri, String redirectPath) {
        String uuid;
        String cookieValue = uuid = UUID.randomUUID().toString();
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        if (auth.isRestorePathAfterRedirect() && !redirectPath.equals(absoluteUri.getRawPath())) {
            cookieValue = cookieValue + COOKIE_DELIM + absoluteUri.getRawPath();
        }
        CookieImpl cookie = new CookieImpl(STATE_COOKIE_NAME, cookieValue);
        cookie.setHttpOnly(true);
        cookie.setSecure(context.request().isSSL());
        cookie.setMaxAge(1800L);
        if (auth.cookiePath.isPresent()) {
            cookie.setPath(auth.getCookiePath().get());
        }
        context.response().addCookie((io.vertx.core.http.Cookie)cookie);
        return uuid;
    }

    private String buildRedirectUri(RoutingContext context, URI absoluteUri, String path) {
        return context.request().scheme() + "://" + absoluteUri.getAuthority() + path;
    }

    private void removeCookie(RoutingContext context, TenantConfigContext configContext, String cookieName) {
        ServerCookie cookie = (ServerCookie)context.cookieMap().get(cookieName);
        if (cookie != null) {
            cookie.setValue("");
            cookie.setMaxAge(0L);
            OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
            if (auth.cookiePath.isPresent()) {
                cookie.setPath(auth.cookiePath.get());
            }
        }
    }
}

