/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.runtime.ContextAwareTokenCredential;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    @Inject
    DefaultTenantConfigResolver tenantResolver;

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, final AuthenticationRequestContext context) {
        ContextAwareTokenCredential credential = (ContextAwareTokenCredential)request.getToken();
        final RoutingContext vertxContext = credential.getContext();
        return Uni.createFrom().deferred((Supplier)new Supplier<Uni<SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> get() {
                if (OidcIdentityProvider.this.tenantResolver.isBlocking(vertxContext)) {
                    return context.runBlocking((Supplier)new Supplier<SecurityIdentity>(){

                        @Override
                        public SecurityIdentity get() {
                            return (SecurityIdentity)OidcIdentityProvider.this.authenticate(request, vertxContext).await().indefinitely();
                        }
                    });
                }
                return OidcIdentityProvider.this.authenticate(request, vertxContext);
            }
        });
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, RoutingContext vertxContext) {
        TenantConfigContext resolvedContext = this.tenantResolver.resolve(vertxContext, true);
        if (resolvedContext.oidcConfig.publicKey.isPresent()) {
            return this.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        return this.validateTokenWithOidcServer(request, resolvedContext);
    }

    private Uni<SecurityIdentity> validateTokenWithOidcServer(final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                resolvedContext.auth.decodeToken(request.getToken().getToken(), (Handler)new Handler<AsyncResult<AccessToken>>(){

                    public void handle(AsyncResult<AccessToken> event) {
                        if (event.failed()) {
                            uniEmitter.fail((Throwable)new AuthenticationFailedException(event.cause()));
                            return;
                        }
                        JsonObject tokenJson = ((AccessToken)event.result()).accessToken();
                        try {
                            uniEmitter.complete((Object)OidcUtils.validateAndCreateIdentity(request.getToken(), resolvedContext.oidcConfig, tokenJson));
                        }
                        catch (Throwable ex) {
                            uniEmitter.fail(ex);
                        }
                    }
                });
            }
        });
    }

    private Uni<SecurityIdentity> validateTokenWithoutOidcServer(TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        OAuth2AuthProviderImpl auth = (OAuth2AuthProviderImpl)resolvedContext.auth;
        JWT jwt = auth.getJWT();
        JsonObject tokenJson = null;
        try {
            tokenJson = jwt.decode(request.getToken().getToken());
        }
        catch (Throwable ex) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(ex));
        }
        if (jwt.isExpired(tokenJson, auth.getConfig().getJWTOptions())) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
        }
        try {
            return Uni.createFrom().item((Object)OidcUtils.validateAndCreateIdentity(request.getToken(), resolvedContext.oidcConfig, tokenJson));
        }
        catch (Throwable ex) {
            return Uni.createFrom().failure(ex);
        }
    }
}

