/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.runtime.ContextAwareTokenCredential;
import io.quarkus.oidc.runtime.OidcUtils;
import io.vertx.ext.web.RoutingContext;

public class AccessTokenCredential
extends ContextAwareTokenCredential {
    private RefreshToken refreshToken;
    private boolean opaque;

    public AccessTokenCredential() {
        this(null, null);
    }

    public AccessTokenCredential(String accessToken, RoutingContext context) {
        this(accessToken, (RefreshToken)null, context);
    }

    public AccessTokenCredential(String accessToken, RefreshToken refreshToken, RoutingContext context) {
        super(accessToken, "bearer", context);
        this.refreshToken = refreshToken;
        if (accessToken != null) {
            this.opaque = OidcUtils.isOpaqueToken(accessToken);
        }
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isOpaque() {
        return this.opaque;
    }
}

