/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.OidcProviderClient;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.security.Key;
import java.time.Duration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class OidcProvider {
    private static final Logger LOG = Logger.getLogger(OidcProvider.class);
    private static final String ANY_ISSUER = "any";
    private static final String[] SUPPORTED_ALGORITHMS = new String[]{SignatureAlgorithm.RS256.getAlgorithm(), SignatureAlgorithm.RS384.getAlgorithm(), SignatureAlgorithm.RS512.getAlgorithm(), SignatureAlgorithm.ES256.getAlgorithm(), SignatureAlgorithm.ES384.getAlgorithm(), SignatureAlgorithm.ES512.getAlgorithm()};
    private static final AlgorithmConstraints ALGORITHM_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, SUPPORTED_ALGORITHMS);
    final OidcProviderClient client;
    final RefreshableVerificationKeyResolver keyResolver;
    final OidcTenantConfig oidcConfig;
    final String issuer;
    final String[] audience;

    public OidcProvider(OidcProviderClient client, OidcTenantConfig oidcConfig, JsonWebKeySet jwks) {
        this.client = client;
        this.oidcConfig = oidcConfig;
        this.keyResolver = jwks == null ? null : new JsonWebKeyResolver(jwks, oidcConfig.token.forcedJwkRefreshInterval);
        this.issuer = this.checkIssuerProp();
        this.audience = this.checkAudienceProp();
    }

    public OidcProvider(String publicKeyEnc, OidcTenantConfig oidcConfig) {
        this.client = null;
        this.oidcConfig = oidcConfig;
        this.keyResolver = new LocalPublicKeyResolver(publicKeyEnc);
        this.issuer = this.checkIssuerProp();
        this.audience = this.checkAudienceProp();
    }

    private String checkIssuerProp() {
        String issuerProp = null;
        if (this.oidcConfig != null && (issuerProp = (String)this.oidcConfig.token.issuer.orElse(null)) == null && this.client != null) {
            issuerProp = this.client.getMetadata().getIssuer();
        }
        return ANY_ISSUER.equals(issuerProp) ? null : issuerProp;
    }

    private String[] checkAudienceProp() {
        List audienceProp = this.oidcConfig != null ? (List)this.oidcConfig.token.audience.orElse(null) : null;
        return audienceProp != null ? audienceProp.toArray(new String[0]) : null;
    }

    public TokenVerificationResult verifyJwtToken(String token) throws InvalidJwtException {
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setVerificationKeyResolver((VerificationKeyResolver)this.keyResolver);
        builder.setJwsAlgorithmConstraints(ALGORITHM_CONSTRAINTS);
        builder.setRequireExpirationTime();
        builder.setRequireIssuedAt();
        if (this.issuer != null) {
            builder.setExpectedIssuer(this.issuer);
        }
        if (this.audience != null) {
            builder.setExpectedAudience(this.audience);
        } else {
            builder.setSkipDefaultAudienceValidation();
        }
        if (this.oidcConfig.token.lifespanGrace.isPresent()) {
            int lifespanGrace = this.oidcConfig.token.lifespanGrace.getAsInt();
            builder.setAllowedClockSkewInSeconds(lifespanGrace);
        }
        builder.setRelaxVerificationKeyValidation();
        try {
            JwtConsumer jwtConsumer = builder.build();
            jwtConsumer.processToClaims(token);
        }
        catch (InvalidJwtException ex) {
            String detail = "";
            List details = ex.getErrorDetails();
            if (!details.isEmpty()) {
                detail = ((ErrorCodeValidator.Error)details.get(0)).getErrorMessage();
            }
            if (this.oidcConfig.clientId.isPresent()) {
                LOG.debugf("Verification of the token issued to client %s has failed: %s", this.oidcConfig.clientId.get(), (Object)detail);
            } else {
                LOG.debugf("Token verification has failed: %s", (Object)detail);
            }
            throw ex;
        }
        return new TokenVerificationResult(OidcUtils.decodeJwtContent(token), null);
    }

    public Uni<TokenVerificationResult> refreshJwksAndVerifyJwtToken(final String token) {
        return this.keyResolver.refresh().onItem().transformToUni((Function)new Function<Void, Uni<? extends TokenVerificationResult>>(){

            @Override
            public Uni<? extends TokenVerificationResult> apply(Void v) {
                try {
                    return Uni.createFrom().item((Object)OidcProvider.this.verifyJwtToken(token));
                }
                catch (Throwable t) {
                    return Uni.createFrom().failure(t);
                }
            }
        });
    }

    public Uni<TokenVerificationResult> introspectToken(String token) {
        return this.client.introspectToken(token).onItemOrFailure().transform((BiFunction)new BiFunction<JsonObject, Throwable, TokenVerificationResult>(){

            @Override
            public TokenVerificationResult apply(JsonObject jsonObject, Throwable t) {
                if (t != null) {
                    throw new AuthenticationFailedException(t);
                }
                if (!Boolean.TRUE.equals(jsonObject.getBoolean("active"))) {
                    LOG.debugf("Token issued to client %s is not active", OidcProvider.this.oidcConfig.clientId.get());
                    throw new AuthenticationFailedException();
                }
                Long exp = jsonObject.getLong("exp");
                if (exp != null) {
                    int lifespanGrace;
                    int n = lifespanGrace = OidcProvider.this.client.getOidcConfig().token.lifespanGrace.isPresent() ? OidcProvider.this.client.getOidcConfig().token.lifespanGrace.getAsInt() : 0;
                    if (System.currentTimeMillis() / 1000L > exp + (long)lifespanGrace) {
                        LOG.debugf("Token issued to client %s has expired", OidcProvider.this.oidcConfig.clientId.get());
                        throw new AuthenticationFailedException();
                    }
                }
                return new TokenVerificationResult(null, jsonObject);
            }
        });
    }

    public Uni<JsonObject> getUserInfo(RoutingContext vertxContext, TokenAuthenticationRequest request) {
        String accessToken = (String)vertxContext.get("access_token");
        if (accessToken == null) {
            accessToken = request.getToken().getToken();
        }
        return this.client.getUserInfo(accessToken);
    }

    public Uni<AuthorizationCodeTokens> getCodeFlowTokens(String code, String redirectUri) {
        return this.client.getAuthorizationCodeTokens(code, redirectUri);
    }

    public Uni<AuthorizationCodeTokens> refreshTokens(String refreshToken) {
        return this.client.refreshAuthorizationCodeTokens(refreshToken);
    }

    public OidcConfigurationMetadata getMetadata() {
        return this.client.getMetadata();
    }

    private static interface RefreshableVerificationKeyResolver
    extends VerificationKeyResolver {
        default public Uni<Void> refresh() {
            return Uni.createFrom().voidItem();
        }
    }

    private static class LocalPublicKeyResolver
    implements RefreshableVerificationKeyResolver {
        Key key;

        LocalPublicKeyResolver(String publicKeyEnc) {
            try {
                this.key = KeyUtils.decodePublicKey((String)publicKeyEnc);
            }
            catch (Exception ex) {
                throw new OIDCException(ex);
            }
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            return this.key;
        }
    }

    private class JsonWebKeyResolver
    implements RefreshableVerificationKeyResolver {
        volatile JsonWebKeySet jwks;
        volatile long lastForcedRefreshTime;
        volatile long forcedJwksRefreshIntervalMilliSecs;

        JsonWebKeyResolver(JsonWebKeySet jwks, Duration forcedJwksRefreshInterval) {
            this.jwks = jwks;
            this.forcedJwksRefreshIntervalMilliSecs = forcedJwksRefreshInterval.toMillis();
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            String kid = jws.getKeyIdHeaderValue();
            if (kid == null) {
                throw new UnresolvableKeyException("Token 'kid' header is not set");
            }
            Key key = this.jwks.getKey(kid);
            if (key == null) {
                throw new UnresolvableKeyException(String.format("JWK with kid '%s' is not available", kid));
            }
            return key;
        }

        @Override
        public Uni<Void> refresh() {
            long now = System.currentTimeMillis();
            if (now > this.lastForcedRefreshTime + this.forcedJwksRefreshIntervalMilliSecs) {
                this.lastForcedRefreshTime = now;
                return OidcProvider.this.client.getJsonWebKeySet().onItem().transformToUni((Function)new Function<JsonWebKeySet, Uni<? extends Void>>(){

                    @Override
                    public Uni<? extends Void> apply(JsonWebKeySet t) {
                        JsonWebKeyResolver.this.jwks = t;
                        return Uni.createFrom().voidItem();
                    }
                });
            }
            return Uni.createFrom().voidItem();
        }
    }
}

