/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.lang.UnresolvableKeyException;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger LOG = Logger.getLogger(OidcIdentityProvider.class);
    static final String REFRESH_TOKEN_GRANT_RESPONSE = "refresh_token_grant_response";
    static final String NEW_AUTHENTICATION = "new_authentication";
    private static final Uni<TokenVerificationResult> NULL_CODE_ACCESS_TOKEN_UNI = Uni.createFrom().nullItem();
    private static final Uni<UserInfo> NULL_USER_INFO_UNI = Uni.createFrom().nullItem();
    private static final String CODE_ACCESS_TOKEN_RESULT = "code_flow_access_token_result";
    @Inject
    DefaultTenantConfigResolver tenantResolver;
    private BlockingTaskRunner<Void> uniVoidOidcContext = new BlockingTaskRunner();
    private BlockingTaskRunner<TokenIntrospection> getIntrospectionRequestContext = new BlockingTaskRunner();
    private BlockingTaskRunner<UserInfo> getUserInfoRequestContext = new BlockingTaskRunner();

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        if (!(request.getToken() instanceof AccessTokenCredential) && !(request.getToken() instanceof IdTokenCredential)) {
            return Uni.createFrom().nullItem();
        }
        LOG.debug((Object)"Starting creating SecurityIdentity");
        final RoutingContext vertxContext = HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request);
        vertxContext.put(AuthenticationRequestContext.class.getName(), (Object)context);
        Uni<TenantConfigContext> tenantConfigContext = this.tenantResolver.resolveContext(vertxContext);
        return tenantConfigContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final TenantConfigContext tenantConfigContext) {
                return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> get() {
                        return OidcIdentityProvider.this.authenticate(request, vertxContext, tenantConfigContext);
                    }
                });
            }
        });
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, RoutingContext vertxContext, TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig.publicKey.isPresent()) {
            LOG.debug((Object)"Performing token verification with a configured public key");
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        return this.validateAllTokensWithOidcServer(vertxContext, request, resolvedContext);
    }

    private Uni<SecurityIdentity> validateAllTokensWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig.token.verifyAccessTokenWithUserInfo && this.isOpaqueAccessToken(vertxContext, request, resolvedContext)) {
            Uni<UserInfo> userInfo = resolvedContext.oidcConfig.authentication.isUserInfoRequired().orElse(false) != false ? this.getUserInfoUni(vertxContext, request, resolvedContext) : NULL_USER_INFO_UNI;
            return userInfo.onItemOrFailure().transformToUni((BiFunction)new BiFunction<UserInfo, Throwable, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(UserInfo userInfo, Throwable t) {
                    if (t != null) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                    }
                    return OidcIdentityProvider.this.validateTokenWithUserInfoAndCreateIdentity(vertxContext, request, resolvedContext, userInfo);
                }
            });
        }
        Uni<TokenVerificationResult> codeAccessTokenUni = this.verifyCodeFlowAccessTokenUni(vertxContext, request, resolvedContext, null);
        return codeAccessTokenUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult codeAccessTokenResult, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure(t instanceof AuthenticationFailedException ? t : new AuthenticationFailedException(t));
                }
                if (codeAccessTokenResult != null) {
                    if (OidcIdentityProvider.tokenAutoRefreshPrepared(codeAccessTokenResult, vertxContext, resolvedContext.oidcConfig)) {
                        return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException(null));
                    }
                    vertxContext.put(OidcIdentityProvider.CODE_ACCESS_TOKEN_RESULT, (Object)codeAccessTokenResult);
                }
                return OidcIdentityProvider.this.getUserInfoAndCreateIdentity(vertxContext, request, resolvedContext);
            }
        });
    }

    private Uni<SecurityIdentity> validateTokenWithUserInfoAndCreateIdentity(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext, final UserInfo userInfo) {
        Uni<TokenVerificationResult> codeAccessTokenUni = this.verifyCodeFlowAccessTokenUni(vertxContext, request, resolvedContext, userInfo);
        return codeAccessTokenUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult codeAccessToken, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                }
                if (codeAccessToken != null) {
                    vertxContext.put(OidcIdentityProvider.CODE_ACCESS_TOKEN_RESULT, (Object)codeAccessToken);
                }
                return OidcIdentityProvider.this.createSecurityIdentityWithOidcServer(vertxContext, request, resolvedContext, userInfo);
            }
        });
    }

    private Uni<SecurityIdentity> getUserInfoAndCreateIdentity(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        Uni<UserInfo> userInfo = resolvedContext.oidcConfig.authentication.isUserInfoRequired().orElse(false) != false ? this.getUserInfoUni(vertxContext, request, resolvedContext) : NULL_USER_INFO_UNI;
        return userInfo.onItemOrFailure().transformToUni((BiFunction)new BiFunction<UserInfo, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(UserInfo userInfo, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                }
                return OidcIdentityProvider.this.createSecurityIdentityWithOidcServer(vertxContext, request, resolvedContext, userInfo);
            }
        });
    }

    private boolean isOpaqueAccessToken(RoutingContext vertxContext, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        if (request.getToken() instanceof AccessTokenCredential) {
            return ((AccessTokenCredential)request.getToken()).isOpaque();
        }
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig.authentication.verifyAccessToken || resolvedContext.oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)vertxContext.get("access_token");
            return OidcUtils.isOpaqueToken(codeAccessToken);
        }
        return false;
    }

    private Uni<SecurityIdentity> createSecurityIdentityWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext, final UserInfo userInfo) {
        Object tokenUni = null;
        tokenUni = OidcIdentityProvider.isInternalIdToken(request) ? (vertxContext.get(NEW_AUTHENTICATION) == Boolean.TRUE ? Uni.createFrom().item((Object)new TokenVerificationResult(OidcUtils.decodeJwtContent(request.getToken().getToken()), null)) : this.verifySelfSignedTokenUni(resolvedContext, request.getToken().getToken())) : this.verifyTokenUni(resolvedContext, request.getToken().getToken(), userInfo);
        return tokenUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult result, Throwable t) {
                String userName;
                QuarkusSecurityIdentity.Builder builder;
                TokenCredential tokenCred;
                block17: {
                    if (t != null) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                    }
                    tokenCred = request.getToken();
                    JsonObject tokenJson = result.localVerificationResult;
                    if (tokenJson == null) {
                        tokenJson = OidcUtils.decodeJwtContent(tokenCred.getToken());
                    }
                    if (tokenJson != null) {
                        try {
                            OidcUtils.validatePrimaryJwtTokenType(resolvedContext.oidcConfig.token, tokenJson);
                            JsonObject rolesJson = OidcIdentityProvider.getRolesJson(vertxContext, resolvedContext, tokenCred, tokenJson, userInfo);
                            QuarkusSecurityIdentity securityIdentity = OidcUtils.validateAndCreateIdentity(vertxContext, tokenCred, resolvedContext, tokenJson, rolesJson, userInfo, result.introspectionResult);
                            if (tokenCred instanceof IdTokenCredential && OidcIdentityProvider.tokenAutoRefreshPrepared(result, vertxContext, resolvedContext.oidcConfig)) {
                                return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException((SecurityIdentity)securityIdentity));
                            }
                            return Uni.createFrom().item((Object)securityIdentity);
                        }
                        catch (Throwable ex) {
                            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(ex));
                        }
                    }
                    if (tokenCred instanceof IdTokenCredential || tokenCred instanceof AccessTokenCredential && !((AccessTokenCredential)tokenCred).isOpaque()) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("JWT token can not be converted to JSON"));
                    }
                    builder = QuarkusSecurityIdentity.builder();
                    builder.addCredential((Credential)tokenCred);
                    OidcUtils.setSecurityIdentityUserInfo(builder, userInfo);
                    OidcUtils.setSecurityIdentityConfigMetadata(builder, resolvedContext);
                    if (result.introspectionResult == null) {
                        if (resolvedContext.oidcConfig.token.allowOpaqueTokenIntrospection && resolvedContext.oidcConfig.token.verifyAccessTokenWithUserInfo) {
                            userName = "";
                            break block17;
                        } else {
                            LOG.debug((Object)"Illegal state - token introspection result is not available.");
                            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
                        }
                    }
                    OidcUtils.setSecurityIdentityIntrospection(builder, result.introspectionResult);
                    String principalMember = "";
                    if (result.introspectionResult.contains("username")) {
                        principalMember = "username";
                    } else if (result.introspectionResult.contains("sub")) {
                        principalMember = "sub";
                    }
                    String string = userName = principalMember.isEmpty() ? "" : result.introspectionResult.getString(principalMember);
                    if (result.introspectionResult.contains("scope")) {
                        for (String role : result.introspectionResult.getString("scope").split(" ")) {
                            builder.addRole(role.trim());
                        }
                    }
                }
                builder.setPrincipal(new Principal(){

                    @Override
                    public String getName() {
                        return userName;
                    }
                });
                if (userInfo != null) {
                    OidcUtils.setSecurityIdentityRoles(builder, resolvedContext.oidcConfig, new JsonObject(userInfo.getJsonObject().toString()));
                }
                OidcUtils.setBlockingApiAttribute(builder, vertxContext);
                OidcUtils.setTenantIdAttribute(builder, resolvedContext.oidcConfig);
                OidcUtils.setRoutingContextAttribute(builder, vertxContext);
                QuarkusSecurityIdentity identity = builder.build();
                if (tokenCred instanceof IdTokenCredential && OidcIdentityProvider.tokenAutoRefreshPrepared(result, vertxContext, resolvedContext.oidcConfig)) {
                    return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException((SecurityIdentity)identity));
                }
                return Uni.createFrom().item((Object)identity);
            }
        });
    }

    private static boolean isInternalIdToken(TokenAuthenticationRequest request) {
        return request.getToken() instanceof IdTokenCredential && ((IdTokenCredential)request.getToken()).isInternal();
    }

    private static boolean tokenAutoRefreshPrepared(TokenVerificationResult result, RoutingContext vertxContext, OidcTenantConfig oidcConfig) {
        if (result != null && oidcConfig.token.refreshExpired && oidcConfig.token.getRefreshTokenTimeSkew().isPresent() && vertxContext.get(REFRESH_TOKEN_GRANT_RESPONSE) != Boolean.TRUE && vertxContext.get(NEW_AUTHENTICATION) != Boolean.TRUE) {
            Long expiry = null;
            if (result.localVerificationResult != null) {
                expiry = result.localVerificationResult.getLong(Claims.exp.name());
            } else if (result.introspectionResult != null) {
                expiry = result.introspectionResult.getLong("exp");
            }
            if (expiry != null) {
                long refreshTokenTimeSkew = oidcConfig.token.getRefreshTokenTimeSkew().get().getSeconds();
                long now = System.currentTimeMillis() / 1000L;
                return now + refreshTokenTimeSkew > expiry;
            }
        }
        return false;
    }

    private static JsonObject getRolesJson(RoutingContext vertxContext, TenantConfigContext resolvedContext, TokenCredential tokenCred, JsonObject tokenJson, UserInfo userInfo) {
        JsonObject rolesJson = tokenJson;
        if (resolvedContext.oidcConfig.roles.source.isPresent()) {
            if (resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.userinfo) {
                rolesJson = new JsonObject(userInfo.getJsonObject().toString());
            } else if (tokenCred instanceof IdTokenCredential && resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.accesstoken && (rolesJson = ((TokenVerificationResult)vertxContext.get((String)CODE_ACCESS_TOKEN_RESULT)).localVerificationResult) == null) {
                rolesJson = OidcUtils.decodeJwtContent((String)vertxContext.get("access_token"));
            }
        }
        return rolesJson;
    }

    private Uni<TokenVerificationResult> verifyCodeFlowAccessTokenUni(RoutingContext vertxContext, TokenAuthenticationRequest request, TenantConfigContext resolvedContext, UserInfo userInfo) {
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig.authentication.verifyAccessToken || resolvedContext.oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)vertxContext.get("access_token");
            return this.verifyTokenUni(resolvedContext, codeAccessToken, userInfo);
        }
        return NULL_CODE_ACCESS_TOKEN_UNI;
    }

    private Uni<TokenVerificationResult> verifyTokenUni(TenantConfigContext resolvedContext, String token, UserInfo userInfo) {
        if (OidcUtils.isOpaqueToken(token)) {
            if (!resolvedContext.oidcConfig.token.allowOpaqueTokenIntrospection) {
                LOG.debug((Object)"Token is opaque but the opaque token introspection is not allowed");
                throw new AuthenticationFailedException();
            }
            if (resolvedContext.oidcConfig.token.verifyAccessTokenWithUserInfo && resolvedContext.provider.getMetadata().getIntrospectionUri() == null) {
                if (userInfo == null) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Opaque access token verification failed as user info is null."));
                }
                return Uni.createFrom().item((Object)new TokenVerificationResult(null, null));
            }
            LOG.debug((Object)"Starting the opaque token introspection");
            return this.introspectTokenUni(resolvedContext, token);
        }
        if (resolvedContext.provider.getMetadata().getJsonWebKeySetUri() == null || resolvedContext.oidcConfig.token.requireJwtIntrospectionOnly) {
            LOG.debug((Object)"Starting the JWT token introspection");
            return this.introspectTokenUni(resolvedContext, token);
        }
        try {
            LOG.debug((Object)"Verifying the JWT token with the local JWK keys");
            return Uni.createFrom().item((Object)resolvedContext.provider.verifyJwtToken(token));
        }
        catch (Throwable t) {
            if (t.getCause() instanceof UnresolvableKeyException) {
                LOG.debug((Object)"No matching JWK key is found, refreshing and repeating the verification");
                return this.refreshJwksAndVerifyTokenUni(resolvedContext, token);
            }
            LOG.debugf("Token verification has failed: %s", (Object)t.getMessage());
            return Uni.createFrom().failure(t);
        }
    }

    private Uni<TokenVerificationResult> verifySelfSignedTokenUni(TenantConfigContext resolvedContext, String token) {
        try {
            return Uni.createFrom().item((Object)resolvedContext.provider.verifySelfSignedJwtToken(token));
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(t);
        }
    }

    private Uni<TokenVerificationResult> refreshJwksAndVerifyTokenUni(TenantConfigContext resolvedContext, String token) {
        return resolvedContext.provider.refreshJwksAndVerifyJwtToken(token).onFailure(f -> f.getCause() instanceof UnresolvableKeyException && resolvedContext.oidcConfig.token.allowJwtIntrospection).recoverWithUni(f -> this.introspectTokenUni(resolvedContext, token));
    }

    private Uni<TokenVerificationResult> introspectTokenUni(TenantConfigContext resolvedContext, String token) {
        TokenIntrospectionCache tokenIntrospectionCache = this.tenantResolver.getTokenIntrospectionCache();
        Object tokenIntrospectionUni = tokenIntrospectionCache == null ? null : tokenIntrospectionCache.getIntrospection(token, resolvedContext.oidcConfig, this.getIntrospectionRequestContext);
        tokenIntrospectionUni = tokenIntrospectionUni == null ? this.newTokenIntrospectionUni(resolvedContext, token) : tokenIntrospectionUni.onItem().ifNull().switchTo(this.newTokenIntrospectionUni(resolvedContext, token));
        return tokenIntrospectionUni.onItem().transform(t -> new TokenVerificationResult(null, (TokenIntrospection)t));
    }

    private Uni<TokenIntrospection> newTokenIntrospectionUni(final TenantConfigContext resolvedContext, final String token) {
        Uni<TokenIntrospection> tokenIntrospectionUni = resolvedContext.provider.introspectToken(token);
        if (this.tenantResolver.getTokenIntrospectionCache() == null || !resolvedContext.oidcConfig.allowTokenIntrospectionCache) {
            return tokenIntrospectionUni;
        }
        return tokenIntrospectionUni.call(new Function<TokenIntrospection, Uni<?>>(){

            @Override
            public Uni<?> apply(TokenIntrospection introspection) {
                return OidcIdentityProvider.this.tenantResolver.getTokenIntrospectionCache().addIntrospection(token, introspection, resolvedContext.oidcConfig, OidcIdentityProvider.this.uniVoidOidcContext);
            }
        });
    }

    private static Uni<SecurityIdentity> validateTokenWithoutOidcServer(TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        try {
            TokenVerificationResult result = resolvedContext.provider.verifyJwtToken(request.getToken().getToken());
            return Uni.createFrom().item((Object)OidcUtils.validateAndCreateIdentity(null, request.getToken(), resolvedContext, result.localVerificationResult, result.localVerificationResult, null, null));
        }
        catch (Throwable t) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
        }
    }

    private Uni<UserInfo> getUserInfoUni(RoutingContext vertxContext, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        UserInfoCache userInfoCache;
        JsonObject userInfo;
        if (OidcIdentityProvider.isInternalIdToken(request) && resolvedContext.oidcConfig.cacheUserInfoInIdtoken && (userInfo = OidcUtils.decodeJwtContent(request.getToken().getToken()).getJsonObject("userinfo")) != null) {
            return Uni.createFrom().item((Object)new UserInfo(userInfo.encode()));
        }
        LOG.debug((Object)"Requesting UserInfo");
        String accessToken = (String)vertxContext.get("access_token");
        if (accessToken == null) {
            accessToken = request.getToken().getToken();
        }
        Object userInfoUni = (userInfoCache = this.tenantResolver.getUserInfoCache()) == null ? null : userInfoCache.getUserInfo(accessToken, resolvedContext.oidcConfig, this.getUserInfoRequestContext);
        userInfoUni = userInfoUni == null ? this.newUserInfoUni(resolvedContext, accessToken) : userInfoUni.onItem().ifNull().switchTo(this.newUserInfoUni(resolvedContext, accessToken));
        return userInfoUni;
    }

    private Uni<UserInfo> newUserInfoUni(final TenantConfigContext resolvedContext, final String accessToken) {
        Uni<UserInfo> userInfoUni = resolvedContext.provider.getUserInfo(accessToken);
        if (this.tenantResolver.getUserInfoCache() == null || !resolvedContext.oidcConfig.allowUserInfoCache || resolvedContext.oidcConfig.cacheUserInfoInIdtoken) {
            return userInfoUni;
        }
        return userInfoUni.call(new Function<UserInfo, Uni<?>>(){

            @Override
            public Uni<?> apply(UserInfo userInfo) {
                return OidcIdentityProvider.this.tenantResolver.getUserInfoCache().addUserInfo(accessToken, userInfo, resolvedContext.oidcConfig, OidcIdentityProvider.this.uniVoidOidcContext);
            }
        });
    }
}

