/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcProviderClient;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.lang.annotation.Annotation;
import java.security.Key;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;

@Recorder
public class OidcRecorder {
    private static final Logger LOG = Logger.getLogger(OidcRecorder.class);
    private static final Map<String, TenantConfigContext> dynamicTenantsConfig = new ConcurrentHashMap<String, TenantConfigContext>();

    public Supplier<DefaultTokenIntrospectionUserInfoCache> setupTokenCache(OidcConfig config, Supplier<Vertx> vertx) {
        return () -> new DefaultTokenIntrospectionUserInfoCache(config, (Vertx)vertx.get());
    }

    public Supplier<TenantConfigBean> setup(OidcConfig config, Supplier<Vertx> vertx, final TlsConfig tlsConfig) {
        final Vertx vertxValue = vertx.get();
        String defaultTenantId = config.defaultTenant.getTenantId().orElse("Default");
        final TenantConfigContext defaultTenantContext = this.createStaticTenantContext(vertxValue, config.defaultTenant, tlsConfig, defaultTenantId);
        final HashMap<String, TenantConfigContext> staticTenantsConfig = new HashMap<String, TenantConfigContext>();
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants.entrySet()) {
            OidcCommonUtils.verifyConfigurationId((String)defaultTenantId, (String)tenant.getKey(), tenant.getValue().getTenantId());
            staticTenantsConfig.put(tenant.getKey(), this.createStaticTenantContext(vertxValue, tenant.getValue(), tlsConfig, tenant.getKey()));
        }
        return new Supplier<TenantConfigBean>(){

            @Override
            public TenantConfigBean get() {
                return new TenantConfigBean(staticTenantsConfig, dynamicTenantsConfig, defaultTenantContext, new Function<OidcTenantConfig, Uni<TenantConfigContext>>(){

                    @Override
                    public Uni<TenantConfigContext> apply(OidcTenantConfig config) {
                        return OidcRecorder.this.createDynamicTenantContext(vertxValue, config, tlsConfig, config.getTenantId().get());
                    }
                }, ExecutorRecorder.getCurrent());
            }
        };
    }

    private Uni<TenantConfigContext> createDynamicTenantContext(Vertx vertx, OidcTenantConfig oidcConfig, TlsConfig tlsConfig, final String tenantId) {
        if (oidcConfig.logout.backchannel.path.isPresent()) {
            throw new ConfigurationException("BackChannel Logout is currently not supported for dynamic tenants");
        }
        if (!dynamicTenantsConfig.containsKey(tenantId)) {
            Uni<TenantConfigContext> uniContext = this.createTenantContext(vertx, oidcConfig, tlsConfig, tenantId);
            uniContext.onFailure().transform(t -> OidcRecorder.logTenantConfigContextFailure(t, tenantId));
            return uniContext.onItem().transform((Function)new Function<TenantConfigContext, TenantConfigContext>(){

                @Override
                public TenantConfigContext apply(TenantConfigContext t) {
                    dynamicTenantsConfig.putIfAbsent(tenantId, t);
                    return t;
                }
            });
        }
        return Uni.createFrom().item((Object)dynamicTenantsConfig.get(tenantId));
    }

    private TenantConfigContext createStaticTenantContext(Vertx vertx, final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, final String tenantId) {
        Uni<TenantConfigContext> uniContext = this.createTenantContext(vertx, oidcConfig, tlsConfig, tenantId);
        return (TenantConfigContext)uniContext.onFailure().recoverWithItem((Function)new Function<Throwable, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(Throwable t) {
                if (t instanceof OIDCException) {
                    LOG.warnf("Tenant '%s': '%s'. OIDC server is not available yet, an attempt to connect will be made duiring the first request. Access to resources protected by this tenant may fail if OIDC server will not become available", (Object)tenantId, (Object)t.getMessage());
                    return new TenantConfigContext(null, oidcConfig, false);
                }
                OidcRecorder.logTenantConfigContextFailure(t, tenantId);
                if (t instanceof ConfigurationException && !oidcConfig.authServerUrl.isPresent() && LaunchMode.DEVELOPMENT == LaunchMode.current()) {
                    return new TenantConfigContext(null, oidcConfig, false);
                }
                throw new OIDCException(t);
            }
        }).await().indefinitely();
    }

    private static Throwable logTenantConfigContextFailure(Throwable t, String tenantId) {
        LOG.debugf("'%s' tenant is not initialized: '%s'. Access to resources protected by this tenant will fail.", (Object)tenantId, (Object)t.getMessage());
        return t;
    }

    private Uni<TenantConfigContext> createTenantContext(Vertx vertx, OidcTenantConfig oidcTenantConfig, TlsConfig tlsConfig, String tenantId) {
        if (!oidcTenantConfig.tenantId.isPresent()) {
            oidcTenantConfig.tenantId = Optional.of(tenantId);
        }
        OidcTenantConfig oidcConfig = OidcUtils.resolveProviderConfig(oidcTenantConfig);
        if (!oidcConfig.tenantEnabled) {
            LOG.debugf("'%s' tenant configuration is disabled", (Object)tenantId);
            return Uni.createFrom().item((Object)new TenantConfigContext(new OidcProvider(null, null, null, null), oidcConfig));
        }
        if (oidcConfig.getPublicKey().isPresent()) {
            return Uni.createFrom().item((Object)OidcRecorder.createTenantContextFromPublicKey(oidcConfig));
        }
        try {
            OidcRecorder.verifyAuthServerUrl(oidcConfig);
            OidcCommonUtils.verifyCommonConfiguration((OidcCommonConfig)oidcConfig, (boolean)OidcRecorder.isServiceApp(oidcConfig), (boolean)true);
        }
        catch (ConfigurationException t) {
            return Uni.createFrom().failure((Throwable)t);
        }
        if (!oidcConfig.discoveryEnabled.orElse(true).booleanValue()) {
            if (!(OidcRecorder.isServiceApp(oidcConfig) || oidcConfig.authorizationPath.isPresent() && oidcConfig.tokenPath.isPresent())) {
                throw new ConfigurationException("'web-app' applications must have 'authorization-path' and 'token-path' properties set when the discovery is disabled.", Set.of("quarkus.oidc.authorization-path", "quarkus.oidc.token-path"));
            }
            if (!oidcConfig.jwksPath.isPresent() && !oidcConfig.introspectionPath.isPresent()) {
                if (!oidcConfig.authentication.isIdTokenRequired().orElse(true).booleanValue() && oidcConfig.authentication.isUserInfoRequired().orElse(false).booleanValue()) {
                    LOG.debugf("tenant %s supports only UserInfo", (Object)oidcConfig.tenantId.get());
                } else {
                    throw new ConfigurationException("Either 'jwks-path' or 'introspection-path' properties must be set when the discovery is disabled.", Set.of("quarkus.oidc.jwks-path", "quarkus.oidc.introspection-path"));
                }
            }
        }
        if (OidcRecorder.isServiceApp(oidcConfig)) {
            if (oidcConfig.token.refreshExpired) {
                throw new ConfigurationException("The 'token.refresh-expired' property can only be enabled for " + OidcTenantConfig.ApplicationType.WEB_APP + " application types");
            }
            if (oidcConfig.logout.path.isPresent()) {
                throw new ConfigurationException("The 'logout.path' property can only be enabled for " + OidcTenantConfig.ApplicationType.WEB_APP + " application types");
            }
            if (oidcConfig.roles.source.isPresent() && oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.idtoken) {
                throw new ConfigurationException("The 'roles.source' property can only be set to 'idtoken' for " + OidcTenantConfig.ApplicationType.WEB_APP + " application types");
            }
        }
        if (oidcConfig.tokenStateManager.strategy != OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (oidcConfig.authentication.isUserInfoRequired().orElse(false).booleanValue() || oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.userinfo) {
                throw new ConfigurationException("UserInfo is required but DefaultTokenStateManager is configured to not keep the access token");
            }
            if (oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken) {
                throw new ConfigurationException("Access token is required to check the roles but DefaultTokenStateManager is configured to not keep the access token");
            }
        }
        if (oidcConfig.token.verifyAccessTokenWithUserInfo) {
            if (!oidcConfig.authentication.isUserInfoRequired().orElse(false).booleanValue()) {
                throw new ConfigurationException("UserInfo is not required but 'verifyAccessTokenWithUserInfo' is enabled");
            }
            if (!oidcConfig.isDiscoveryEnabled().orElse(true).booleanValue()) {
                if (oidcConfig.userInfoPath.isEmpty()) {
                    throw new ConfigurationException("UserInfo path is missing but 'verifyAccessTokenWithUserInfo' is enabled");
                }
                if (oidcConfig.introspectionPath.isPresent()) {
                    throw new ConfigurationException("Introspection path is configured and 'verifyAccessTokenWithUserInfo' is enabled, these options are mutually exclusive");
                }
            }
        }
        return OidcRecorder.createOidcProvider(oidcConfig, tlsConfig, vertx).onItem().transform(p -> new TenantConfigContext((OidcProvider)p, oidcConfig));
    }

    private static TenantConfigContext createTenantContextFromPublicKey(OidcTenantConfig oidcConfig) {
        if (!OidcRecorder.isServiceApp(oidcConfig)) {
            throw new ConfigurationException("'public-key' property can only be used with the 'service' applications");
        }
        LOG.debug((Object)"'public-key' property for the local token verification is set, no connection to the OIDC server will be created");
        return new TenantConfigContext(new OidcProvider(oidcConfig.publicKey.get(), oidcConfig, OidcRecorder.readTokenDecryptionKey(oidcConfig)), oidcConfig);
    }

    public void setSecurityEventObserved(boolean isSecurityEventObserved) {
        DefaultTenantConfigResolver bean = (DefaultTenantConfigResolver)Arc.container().instance(DefaultTenantConfigResolver.class, new Annotation[0]).get();
        bean.setSecurityEventObserved(isSecurityEventObserved);
    }

    public static Optional<ProxyOptions> toProxyOptions(OidcCommonConfig.Proxy proxyConfig) {
        return OidcCommonUtils.toProxyOptions((OidcCommonConfig.Proxy)proxyConfig);
    }

    protected static OIDCException toOidcException(Throwable cause, String authServerUrl) {
        String message = OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrl);
        LOG.warn((Object)message);
        return new OIDCException("OIDC Server is not available", cause);
    }

    protected static Uni<OidcProvider> createOidcProvider(final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, Vertx vertx) {
        return OidcRecorder.createOidcClientUni(oidcConfig, tlsConfig, vertx).onItem().transformToUni((Function)new Function<OidcProviderClient, Uni<? extends OidcProvider>>(){

            @Override
            public Uni<OidcProvider> apply(final OidcProviderClient client) {
                if (client.getMetadata().getJsonWebKeySetUri() != null && !oidcConfig.token.requireJwtIntrospectionOnly) {
                    return OidcRecorder.getJsonWebSetUni(client, oidcConfig).onItem().transform((Function)new Function<JsonWebKeySet, OidcProvider>(){

                        @Override
                        public OidcProvider apply(JsonWebKeySet jwks) {
                            return new OidcProvider(client, oidcConfig, jwks, OidcRecorder.readTokenDecryptionKey(oidcConfig));
                        }
                    });
                }
                return Uni.createFrom().item((Object)new OidcProvider(client, oidcConfig, null, OidcRecorder.readTokenDecryptionKey(oidcConfig)));
            }
        });
    }

    private static Key readTokenDecryptionKey(OidcTenantConfig oidcConfig) {
        if (oidcConfig.token.decryptionKeyLocation.isPresent()) {
            try {
                List keys;
                PrivateKey key = null;
                String keyContent = KeyUtils.readKeyContent((String)oidcConfig.token.decryptionKeyLocation.get());
                if (keyContent != null && (keys = KeyUtils.loadJsonWebKeys((String)keyContent)) != null && keys.size() == 1 && (((JsonWebKey)keys.get(0)).getAlgorithm() == null || ((JsonWebKey)keys.get(0)).getAlgorithm().equals(KeyEncryptionAlgorithm.RSA_OAEP.getAlgorithm())) && ("enc".equals(((JsonWebKey)keys.get(0)).getUse()) || ((JsonWebKey)keys.get(0)).getUse() == null)) {
                    key = ((PublicJsonWebKey)PublicJsonWebKey.class.cast(keys.get(0))).getPrivateKey();
                }
                if (key == null) {
                    key = KeyUtils.decodeDecryptionPrivateKey((String)keyContent);
                }
                return key;
            }
            catch (Exception ex) {
                throw new ConfigurationException(String.format("Token decryption key for tenant %s can not be read from %s", oidcConfig.tenantId.get(), oidcConfig.token.decryptionKeyLocation.get()), (Throwable)ex);
            }
        }
        return null;
    }

    protected static Uni<JsonWebKeySet> getJsonWebSetUni(OidcProviderClient client, OidcTenantConfig oidcConfig) {
        if (!oidcConfig.isDiscoveryEnabled().orElse(true).booleanValue()) {
            long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
            return client.getJsonWebKeySet().onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(OidcCommonUtils.CONNECTION_BACKOFF_DURATION, OidcCommonUtils.CONNECTION_BACKOFF_DURATION).expireIn(connectionDelayInMillisecs).onFailure().transform(t -> OidcRecorder.toOidcException(t, (String)oidcConfig.authServerUrl.get())).onFailure().invoke(client::close);
        }
        return client.getJsonWebKeySet();
    }

    protected static Uni<OidcProviderClient> createOidcClientUni(final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, Vertx vertx) {
        final String authServerUriString = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
        WebClientOptions options = new WebClientOptions();
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (TlsConfig)tlsConfig, (HttpClientOptions)options);
        final WebClient client = WebClient.create((io.vertx.mutiny.core.Vertx)new io.vertx.mutiny.core.Vertx(vertx), (WebClientOptions)options);
        Uni metadataUni = null;
        if (!oidcConfig.discoveryEnabled.orElse(true).booleanValue()) {
            metadataUni = Uni.createFrom().item((Object)OidcRecorder.createLocalMetadata(oidcConfig, authServerUriString));
        } else {
            long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
            metadataUni = OidcCommonUtils.discoverMetadata((WebClient)client, (String)authServerUriString, (long)connectionDelayInMillisecs).onItem().transform(json -> new OidcConfigurationMetadata((JsonObject)json, OidcRecorder.createLocalMetadata(oidcConfig, authServerUriString)));
        }
        return metadataUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<OidcConfigurationMetadata, Throwable, Uni<? extends OidcProviderClient>>(){

            @Override
            public Uni<OidcProviderClient> apply(OidcConfigurationMetadata metadata, Throwable t) {
                if (t != null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)OidcRecorder.toOidcException(t, authServerUriString));
                }
                if (metadata == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("OpenId Connect Provider configuration metadata is not configured and can not be discovered"));
                }
                if (oidcConfig.logout.path.isPresent() && !oidcConfig.endSessionPath.isPresent() && metadata.getEndSessionUri() == null) {
                    client.close();
                    return Uni.createFrom().failure((Throwable)new ConfigurationException("The application supports RP-Initiated Logout but the OpenID Provider does not advertise the end_session_endpoint"));
                }
                return Uni.createFrom().item((Object)new OidcProviderClient(client, metadata, oidcConfig));
            }
        });
    }

    private static OidcConfigurationMetadata createLocalMetadata(OidcTenantConfig oidcConfig, String authServerUriString) {
        String tokenUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.tokenPath);
        String introspectionUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.introspectionPath);
        String authorizationUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.authorizationPath);
        String jwksUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.jwksPath);
        String userInfoUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.userInfoPath);
        String endSessionUri = OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, oidcConfig.endSessionPath);
        return new OidcConfigurationMetadata(tokenUri, introspectionUri, authorizationUri, jwksUri, userInfoUri, endSessionUri, oidcConfig.token.issuer.orElse(null));
    }

    private static boolean isServiceApp(OidcTenantConfig oidcConfig) {
        return OidcTenantConfig.ApplicationType.SERVICE.equals((Object)oidcConfig.applicationType.orElse(OidcTenantConfig.ApplicationType.SERVICE));
    }

    private static void verifyAuthServerUrl(OidcCommonConfig oidcConfig) {
        if (!oidcConfig.getAuthServerUrl().isPresent()) {
            throw new ConfigurationException("'quarkus.oidc.auth-server-url' property must be configured");
        }
        OidcCommonUtils.verifyEndpointUrl((String)((String)oidcConfig.getAuthServerUrl().get()));
    }
}

