/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.redis.client.RedisClient;
import io.quarkus.redis.client.reactive.ReactiveRedisClient;
import io.quarkus.redis.client.runtime.MutinyRedis;
import io.quarkus.redis.client.runtime.MutinyRedisAPI;
import io.quarkus.redis.client.runtime.RedisAPIContainer;
import io.quarkus.redis.client.runtime.RedisAPIProducer;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

@Recorder
public class RedisClientRecorder {
    public Supplier<RedisClient> redisClientSupplier(final String clientName) {
        return new Supplier<RedisClient>(){

            @Override
            public RedisClient get() {
                RedisAPIContainer redisAPIContainer = RedisClientRecorder.this.getRedisAPIContainer(clientName);
                return redisAPIContainer.getRedisClient();
            }
        };
    }

    public Supplier<ReactiveRedisClient> reactiveRedisClientSupplier(final String clientName) {
        return new Supplier<ReactiveRedisClient>(){

            @Override
            public ReactiveRedisClient get() {
                RedisAPIContainer redisAPIContainer = RedisClientRecorder.this.getRedisAPIContainer(clientName);
                return redisAPIContainer.getReactiveClient();
            }
        };
    }

    public Supplier<MutinyRedis> mutinyRedisSupplier(final String clientName) {
        return new Supplier<MutinyRedis>(){

            @Override
            public MutinyRedis get() {
                RedisAPIContainer redisAPIContainer = RedisClientRecorder.this.getRedisAPIContainer(clientName);
                return redisAPIContainer.getMutinyRedis();
            }
        };
    }

    public Supplier<MutinyRedisAPI> mutinyRedisAPISupplier(final String clientName) {
        return new Supplier<MutinyRedisAPI>(){

            @Override
            public MutinyRedisAPI get() {
                RedisAPIContainer redisApiContainer = RedisClientRecorder.this.getRedisAPIContainer(clientName);
                return redisApiContainer.getMutinyRedisAPI();
            }
        };
    }

    public Supplier<RedisAPI> redisAPISupplier(final String clientName) {
        return new Supplier<RedisAPI>(){

            @Override
            public RedisAPI get() {
                RedisAPIContainer redisAPIContainer = RedisClientRecorder.this.getRedisAPIContainer(clientName);
                return redisAPIContainer.getRedisAPI();
            }
        };
    }

    public Supplier<Redis> redisSupplier(final String clientName) {
        return new Supplier<Redis>(){

            @Override
            public Redis get() {
                RedisAPIContainer redisAPIContainer = RedisClientRecorder.this.getRedisAPIContainer(clientName);
                return redisAPIContainer.getRedis();
            }
        };
    }

    private RedisAPIContainer getRedisAPIContainer(String clientName) {
        RedisAPIProducer redisAPIProducer = (RedisAPIProducer)Arc.container().instance(RedisAPIProducer.class, new Annotation[0]).get();
        return redisAPIProducer.getRedisAPIContainer(clientName);
    }
}

