/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.search.DistanceMetric;
import io.quarkus.redis.datasource.search.VectorAlgorithm;
import io.quarkus.redis.datasource.search.VectorType;
import java.util.ArrayList;
import java.util.List;

public class FieldOptions {
    private boolean sortable;
    private boolean unf;
    private boolean noStem;
    private boolean noIndex;
    private String phonetic;
    private double weight = -1.0;
    private char separator;
    private boolean caseSensitive;
    private boolean withSuffixTrie;
    private VectorAlgorithm vectorAlgorithm;
    private VectorType vectorType;
    private Integer dimension;
    private DistanceMetric distanceMetric;
    private Integer initialCap;
    private Integer blockSize;

    public FieldOptions sortable() {
        this.sortable = true;
        return this;
    }

    public FieldOptions unf() {
        this.unf = true;
        return this;
    }

    public FieldOptions noStem() {
        this.noStem = true;
        return this;
    }

    public FieldOptions noIndex() {
        this.noIndex = true;
        return this;
    }

    public FieldOptions phonetic(String phonetic) {
        this.phonetic = phonetic;
        return this;
    }

    public FieldOptions weight(double weight) {
        this.weight = weight;
        return this;
    }

    public FieldOptions separator(char separator) {
        this.separator = separator;
        return this;
    }

    public FieldOptions caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public FieldOptions withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    public FieldOptions vectorAlgorithm(VectorAlgorithm vectorAlgorithm) {
        this.vectorAlgorithm = vectorAlgorithm;
        return this;
    }

    public FieldOptions vectorType(VectorType vectorType) {
        this.vectorType = vectorType;
        return this;
    }

    public FieldOptions dimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public FieldOptions distanceMetric(DistanceMetric distanceMetric) {
        this.distanceMetric = distanceMetric;
        return this;
    }

    public FieldOptions initialCap(int initialCap) {
        this.initialCap = initialCap;
        return this;
    }

    public FieldOptions blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public List<String> toArgs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.vectorAlgorithm != null) {
            list.add(this.vectorAlgorithm.name());
            list.add(String.valueOf(this.vectorSimilarityArgumentsCount()));
        }
        if (this.vectorType != null) {
            list.add("TYPE");
            list.add(this.vectorType.name());
        }
        if (this.dimension != null) {
            list.add("DIM");
            list.add(this.dimension.toString());
        }
        if (this.distanceMetric != null) {
            list.add("DISTANCE_METRIC");
            list.add(this.distanceMetric.name());
        }
        if (this.initialCap != null) {
            list.add("INITIAL_CAP");
            list.add(this.initialCap.toString());
        }
        if (this.blockSize != null) {
            list.add("BLOCK_SIZE");
            list.add(this.blockSize.toString());
        }
        if (this.sortable) {
            list.add("SORTABLE");
        }
        if (this.unf) {
            if (!this.sortable) {
                throw new IllegalArgumentException("Using `UNF` requires `SORTABLE`");
            }
            list.add("UNF");
        }
        if (this.noStem) {
            list.add("NOSTEM");
        }
        if (this.noIndex) {
            list.add("NOINDEX");
        }
        if (this.phonetic != null) {
            list.add("PHONETIC");
            list.add(this.phonetic);
        }
        if (this.weight != -1.0) {
            list.add("WEIGHT");
            list.add(Double.toString(this.weight));
        }
        if (this.separator != '\u0000') {
            list.add("SEPARATOR");
            list.add(Character.toString(this.separator));
        }
        if (this.caseSensitive) {
            list.add("CASESENSITIVE");
        }
        if (this.withSuffixTrie) {
            list.add("WITHSUFFIXTRIE");
        }
        return list;
    }

    private int vectorSimilarityArgumentsCount() {
        int count = 0;
        if (this.vectorType != null) {
            count += 2;
        }
        if (this.dimension != null) {
            count += 2;
        }
        if (this.distanceMetric != null) {
            count += 2;
        }
        if (this.initialCap != null) {
            count += 2;
        }
        if (this.blockSize != null) {
            count += 2;
        }
        return count;
    }
}

