/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.sortedset;

import java.util.Objects;

public class ScoredValue<V> {
    public static ScoredValue<?> EMPTY = new ScoredValue<Object>(null, 0.0);
    public final V value;
    public final double score;

    public static <V> ScoredValue<V> of(V v, double score) {
        return new ScoredValue<V>(v, score);
    }

    public static <T> ScoredValue<T> empty() {
        return EMPTY;
    }

    public ScoredValue(V value, double score) {
        this.value = value;
        this.score = score;
    }

    public V value() {
        return this.value;
    }

    public double score() {
        return this.score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoredValue that = (ScoredValue)o;
        return Double.compare(that.score, this.score) == 0 && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.score);
    }

    public String toString() {
        return "ScoredValue{value=" + String.valueOf(this.value) + ", score=" + this.score + "}";
    }
}

