/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.auth.cdi.NullJsonWebToken;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Priority(value=1)
@Alternative
@RequestScoped
public class JwtPrincipalProducer {
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    JsonWebToken currentJWTPrincipalOrNull() {
        if (this.identity.isAnonymous()) {
            return new NullJsonWebToken();
        }
        if (this.identity.getPrincipal() instanceof JsonWebToken) {
            return (JsonWebToken)this.identity.getPrincipal();
        }
        throw new IllegalStateException("Current principal " + this.identity.getPrincipal() + " is not a JSON web token");
    }
}

