/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.keycloak.server;

import io.quarkus.runtime.configuration.ConfigurationException;
import io.restassured.RestAssured;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    private static final String KEYCLOAK_VERSION = System.getProperty("keycloak.version");
    private static final String KEYCLOAK_DOCKER_IMAGE = System.getProperty("keycloak.docker.image");
    private boolean useHttps;
    private Integer fixedPort;
    private final boolean legacy;

    private static String getKeycloakImageName() {
        if (KEYCLOAK_DOCKER_IMAGE != null) {
            return KEYCLOAK_DOCKER_IMAGE;
        }
        if (KEYCLOAK_VERSION != null) {
            return "quay.io/keycloak/keycloak:" + KEYCLOAK_VERSION;
        }
        throw new ConfigurationException("Please set either 'keycloak.docker.image' or 'keycloak.version' system property");
    }

    public KeycloakContainer() {
        this(DockerImageName.parse((String)KeycloakContainer.getKeycloakImageName()));
    }

    public KeycloakContainer(DockerImageName keycloakImageName) {
        super(keycloakImageName);
        this.legacy = keycloakImageName.getVersionPart().endsWith("-legacy");
        this.withExposedPorts(new Integer[]{8080, 8443});
        this.withEnv("KC_HTTP_ENABLED", "true");
        this.withEnv("KEYCLOAK_ADMIN", "admin");
        this.withEnv("KEYCLOAK_ADMIN_PASSWORD", "admin");
        this.withEnv("KC_HOSTNAME_STRICT", "false");
        this.withEnv("KC_HOSTNAME_STRICT_HTTPS", "false");
        this.withEnv("KC_STORAGE", "chm");
        this.withEnv("DB_VENDOR", "H2");
        this.withEnv("KEYCLOAK_USER", "admin");
        this.withEnv("KEYCLOAK_PASSWORD", "admin");
        this.withEnv("KEYCLOAK_HTTPS_PORT", "8443");
        this.withNetwork(Network.SHARED);
        this.withNetworkAliases(new String[]{"keycloak"});
    }

    public KeycloakContainer withUseHttps(boolean useHttps) {
        this.useHttps = useHttps;
        return this;
    }

    public KeycloakContainer withFixedPort(int fixedPort) {
        this.fixedPort = fixedPort;
        return this;
    }

    protected void doStart() {
        if (!this.legacy && this.getCommandParts().length == 0) {
            this.withCommand("start-dev");
        }
        if (this.fixedPort != null) {
            this.addFixedExposedPort(this.fixedPort, this.getPort());
        }
        if (this.useHttps) {
            RestAssured.useRelaxedHTTPSValidation();
            this.waitingFor((WaitStrategy)Wait.forHttps((String)this.getAuthPath()).forPort(8443).allowInsecure());
        } else {
            this.waitingFor((WaitStrategy)Wait.forHttp((String)this.getAuthPath()).forPort(8080));
        }
        super.doStart();
    }

    public int getPort() {
        return this.useHttps ? 8443 : 8080;
    }

    private String getAuthPath() {
        return this.legacy ? "/auth" : "";
    }

    public String getServerUrl() {
        return String.format("%s://%s:%d" + this.getAuthPath(), this.useHttps ? "https" : "http", this.getHost(), this.getMappedPort(this.getPort()));
    }

    public String getInternalUrl() {
        return String.format("%s://keycloak:%d" + this.getAuthPath(), this.useHttps ? "https" : "http", this.getPort());
    }
}

