/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime;

import io.quarkus.tls.runtime.config.JKSTrustStoreConfig;
import io.quarkus.tls.runtime.config.KeyStoreConfig;
import io.quarkus.tls.runtime.config.P12TrustStoreConfig;
import io.quarkus.tls.runtime.config.PemCertsConfig;
import io.quarkus.tls.runtime.config.TlsBucketConfig;
import io.quarkus.tls.runtime.config.TrustStoreConfig;
import io.quarkus.tls.runtime.config.TrustStoreCredentialProviderConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

class JavaNetSslTlsBucketConfig
implements TlsBucketConfig {
    private static final Logger log = Logger.getLogger(JavaNetSslTlsBucketConfig.class);

    JavaNetSslTlsBucketConfig() {
    }

    @Override
    public Optional<KeyStoreConfig> keyStore() {
        return Optional.empty();
    }

    @Override
    public Optional<TrustStoreConfig> trustStore() {
        Optional<P12TrustStoreConfig> p12Config;
        Path tsPath = JavaNetSslTlsBucketConfig.defaultTrustStorePath();
        String tsType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()).toLowerCase(Locale.US);
        Optional<String> password = Optional.ofNullable(System.getProperty("javax.net.ssl.trustStorePassword", "changeit"));
        JavaNetSslTrustStoreConfig tsCfg = new JavaNetSslTrustStoreConfig(p12Config, switch (tsType) {
            case "pkcs12" -> {
                p12Config = Optional.of(new JavaNetSslStoreConfig(tsPath, password, Optional.empty(), null));
                yield Optional.empty();
            }
            case "jks" -> {
                p12Config = Optional.empty();
                yield Optional.of(new JavaNetSslStoreConfig(tsPath, password, Optional.empty(), null));
            }
            default -> throw new IllegalArgumentException("Unexpected javax.net.ssl.trustStoreType: " + tsType);
        }, TrustStoreConfig.CertificateExpiryPolicy.WARN);
        return Optional.of(tsCfg);
    }

    static Path defaultTrustStorePath() {
        String rawTsPath = System.getProperty("javax.net.ssl.trustStore");
        if (rawTsPath != null && !rawTsPath.isEmpty()) {
            log.debugf("Honoring javax.net.ssl.trustStore property value: %s", (Object)rawTsPath);
            return Path.of(rawTsPath, new String[0]);
        }
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || javaHome.isEmpty()) {
            throw new IllegalStateException("Could not locate the default Java truststore because the 'java.home' property is not set");
        }
        Path javaHomePath = Path.of(javaHome, new String[0]);
        if (!Files.isDirectory(javaHomePath, new LinkOption[0])) {
            throw new IllegalStateException("Could not locate the default Java truststore because the 'java.home' path '" + javaHome + "' is not a directory");
        }
        Path jssecacerts = javaHomePath.resolve("lib/security/jssecacerts");
        if (Files.isRegularFile(jssecacerts, new LinkOption[0])) {
            log.debugf("Using %s as a truststore", (Object)jssecacerts);
            return jssecacerts;
        }
        Path cacerts = javaHomePath.resolve("lib/security/cacerts");
        if (Files.isRegularFile(cacerts, new LinkOption[0])) {
            log.debugf("Using %s as a truststore", (Object)cacerts);
            return cacerts;
        }
        throw new IllegalStateException("Could not locate the default Java truststore. Tried javax.net.ssl.trustStore system property, " + String.valueOf(jssecacerts) + " and " + String.valueOf(cacerts));
    }

    @Override
    public Optional<List<String>> cipherSuites() {
        return Optional.empty();
    }

    @Override
    public Set<String> protocols() {
        return Set.of("TLSv1.3", "TLSv1.2");
    }

    @Override
    public Duration handshakeTimeout() {
        return Duration.parse("10S");
    }

    @Override
    public boolean alpn() {
        return true;
    }

    @Override
    public Optional<List<Path>> certificateRevocationList() {
        return Optional.empty();
    }

    @Override
    public boolean trustAll() {
        return false;
    }

    @Override
    public Optional<String> hostnameVerificationAlgorithm() {
        return Optional.empty();
    }

    @Override
    public Optional<Duration> reloadPeriod() {
        return Optional.empty();
    }

    record JavaNetSslStoreConfig(Path path, Optional<String> password, Optional<String> alias, Optional<String> provider) implements P12TrustStoreConfig,
    JKSTrustStoreConfig
    {
    }

    record JavaNetSslTrustStoreConfig(Optional<P12TrustStoreConfig> p12, Optional<JKSTrustStoreConfig> jks, TrustStoreConfig.CertificateExpiryPolicy certificateExpirationPolicy) implements TrustStoreConfig
    {
        @Override
        public Optional<PemCertsConfig> pem() {
            return Optional.empty();
        }

        @Override
        public TrustStoreCredentialProviderConfig credentialsProvider() {
            return null;
        }
    }
}

