/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment.devmode;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.deployment.devmode.ReplacementDebugPage;
import io.quarkus.undertow.runtime.UndertowDeploymentTemplate;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;

public class UndertowHotReplacementSetup
implements HotReplacementSetup {
    private volatile long nextUpdate;
    private HotReplacementContext context;
    private static final long TWO_SECONDS = 2000L;

    public void setupHotDeployment(HotReplacementContext context) {
        this.context = context;
        HandlerWrapper wrapper = this.createHandlerWrapper();
        UndertowDeploymentTemplate.setHotDeployment((HandlerWrapper)wrapper);
    }

    private HandlerWrapper createHandlerWrapper() {
        return new HandlerWrapper(){

            public HttpHandler wrap(final HttpHandler handler) {
                return new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        if (exchange.isInIoThread()) {
                            exchange.dispatch((HttpHandler)this);
                            return;
                        }
                        UndertowHotReplacementSetup.this.handleHotDeploymentRequest(exchange, handler);
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleHotDeploymentRequest(HttpServerExchange exchange, HttpHandler next) throws Exception {
        if (this.nextUpdate > System.currentTimeMillis()) {
            if (this.context.getDeploymentProblem() != null) {
                this.handleDeploymentProblem(exchange, this.context.getDeploymentProblem());
                return;
            }
            next.handleRequest(exchange);
            return;
        }
        UndertowHotReplacementSetup undertowHotReplacementSetup = this;
        synchronized (undertowHotReplacementSetup) {
            if (this.nextUpdate < System.currentTimeMillis()) {
                this.context.doScan();
                this.nextUpdate = System.currentTimeMillis() + 2000L;
            }
        }
        if (this.context.getDeploymentProblem() != null) {
            this.handleDeploymentProblem(exchange, this.context.getDeploymentProblem());
            return;
        }
        next.handleRequest(exchange);
    }

    private void handleDeploymentProblem(HttpServerExchange exchange, Throwable exception) {
        String bodyText = ReplacementDebugPage.generateHtml((Throwable)exception);
        exchange.setStatusCode(500);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html; charset=UTF-8");
        exchange.getResponseSender().send(bodyText);
    }
}

