/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.runtime.TemplateHtmlBuilder;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public class QuarkusErrorServlet
extends HttpServlet {
    public static final String SHOW_STACK = "show-stack";
    public static final String SHOW_DECORATION = "show-decoration";
    public static final String SRC_MAIN_JAVA = "src-main-java";
    public static final String KNOWN_CLASSES = "known-classes";

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean showStack;
        Object details = "";
        String stack = "";
        Object uuid = req.getAttribute("quarkus.error.id");
        Throwable exception = (Throwable)req.getAttribute("jakarta.servlet.error.exception");
        String errorMessage = (String)req.getAttribute("jakarta.servlet.error.message");
        if (errorMessage != null) {
            details = errorMessage;
        }
        if ((showStack = Boolean.parseBoolean(this.getInitParameter(SHOW_STACK))) && exception != null) {
            details = QuarkusErrorServlet.generateHeaderMessage(exception, uuid == null ? null : uuid.toString());
            stack = QuarkusErrorServlet.generateStackTrace(exception);
        } else if (uuid != null) {
            details = (String)details + "Error id " + uuid;
        }
        String accept = req.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            resp.setContentType("application/json");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String escapedDetails = QuarkusErrorServlet.escapeJsonString((String)details);
            String escapedStack = QuarkusErrorServlet.escapeJsonString(stack);
            StringBuilder jsonPayload = new StringBuilder("{\"details\":\"").append(escapedDetails).append("\",\"stack\":\"").append(escapedStack).append("\"}");
            resp.getWriter().write(jsonPayload.toString());
        } else {
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            TemplateHtmlBuilder htmlBuilder = new TemplateHtmlBuilder("Internal Server Error", (String)details, (String)details);
            if (showStack && exception != null) {
                htmlBuilder.stack(exception);
            }
            boolean showDecoration = Boolean.parseBoolean(this.getInitParameter(SHOW_DECORATION));
            String srcMainJava = this.getInitParameter(SRC_MAIN_JAVA);
            String knownClassesString = this.getInitParameter(KNOWN_CLASSES);
            ArrayList<String> knownClasses = null;
            if (knownClassesString != null) {
                knownClasses = new ArrayList<String>(Arrays.asList(knownClassesString.split(",")));
            }
            if (showDecoration && exception != null && srcMainJava != null && knownClasses != null) {
                htmlBuilder.decorate(exception, srcMainJava, knownClasses);
            }
            resp.getWriter().write(htmlBuilder.toString());
        }
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().trim();
    }

    private static String generateHeaderMessage(Throwable exception, String uuid) {
        return String.format("Error id %s, %s: %s", uuid, exception.getClass().getName(), QuarkusErrorServlet.extractFirstLine(exception.getMessage()));
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    private static String escapeJsonString(String text) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

