/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.deployment.BuildTimeConstBuildItem;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.InternalImportMapBuildItem;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.deployment.MvnpmBuildItem;
import io.quarkus.devui.deployment.ThemeVarsBuildItem;
import io.quarkus.devui.deployment.extension.Extension;
import io.quarkus.devui.spi.DevUIContent;
import io.quarkus.devui.spi.buildtime.QuteTemplateBuildItem;
import io.quarkus.devui.spi.buildtime.StaticContentBuildItem;
import io.quarkus.devui.spi.page.AbstractPageBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.MenuPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.vertx.core.json.jackson.DatabindCodec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.mvnpm.importmap.Aggregator;

public class BuildTimeContentProcessor {
    private static final Logger log = Logger.getLogger(BuildTimeContentProcessor.class);
    private static final String SLASH = "/";
    private static final String DEV_UI = "dev-ui";
    private static final String BUILD_TIME_PATH = "dev-ui-templates/build-time";
    final Config config = ConfigProvider.getConfig();
    private static final List<String> LEVELS = List.of(Level.OFF.getName(), Level.SEVERE.getName(), org.jboss.logmanager.Level.ERROR.getName(), org.jboss.logmanager.Level.FATAL.getName(), Level.WARNING.getName(), org.jboss.logmanager.Level.WARN.getName(), org.jboss.logmanager.Level.INFO.getName(), org.jboss.logmanager.Level.DEBUG.getName(), org.jboss.logmanager.Level.TRACE.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName());
    private static final Color QUARKUS_BLUE = Color.from(211, 63, 54);
    private static final Color QUARKUS_RED = Color.from(343, 100, 50);
    private static final Color QUARKUS_DARK = Color.from(180, 36, 5);
    private static final Color QUARKUS_LIGHT = Color.from(0, 0, 90);

    @BuildStep(onlyIf={IsDevelopment.class})
    InternalImportMapBuildItem createKnownInternalImportMap(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        String contextRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath() + "dev-ui/";
        InternalImportMapBuildItem internalImportMapBuildItem = new InternalImportMapBuildItem();
        internalImportMapBuildItem.add("devui/", contextRoot);
        internalImportMapBuildItem.add("qwc/", contextRoot + "qwc/");
        internalImportMapBuildItem.add("qwc-no-data", contextRoot + "qwc/qwc-no-data.js");
        internalImportMapBuildItem.add("qwc-hot-reload-element", contextRoot + "qwc/qwc-hot-reload-element.js");
        internalImportMapBuildItem.add("qwc-server-log", contextRoot + "qwc/qwc-server-log.js");
        internalImportMapBuildItem.add("qwc-extension-link", contextRoot + "qwc/qwc-extension-link.js");
        internalImportMapBuildItem.add("qui/", contextRoot + "qui/");
        internalImportMapBuildItem.add("qui-card", contextRoot + "qui/qui-card.js");
        internalImportMapBuildItem.add("qui-badge", contextRoot + "qui/qui-badge.js");
        internalImportMapBuildItem.add("qui-alert", contextRoot + "qui/qui-alert.js");
        internalImportMapBuildItem.add("qui-code-block", contextRoot + "qui/qui-code-block.js");
        internalImportMapBuildItem.add("qui-ide-link", contextRoot + "qui/qui-ide-link.js");
        internalImportMapBuildItem.add("echarts/", contextRoot + "echarts/");
        internalImportMapBuildItem.add("echarts-gauge-grade", contextRoot + "echarts/echarts-gauge-grade.js");
        internalImportMapBuildItem.add("echarts-pie", contextRoot + "echarts/echarts-pie.js");
        internalImportMapBuildItem.add("echarts-horizontal-stacked-bar", contextRoot + "echarts/echarts-horizontal-stacked-bar.js");
        internalImportMapBuildItem.add("echarts-force-graph", contextRoot + "echarts/echarts-force-graph.js");
        internalImportMapBuildItem.add("echarts-bar-stack", contextRoot + "echarts/echarts-bar-stack.js");
        internalImportMapBuildItem.add("icon/", contextRoot + "icon/");
        internalImportMapBuildItem.add("controller/", contextRoot + "controller/");
        internalImportMapBuildItem.add("log-controller", contextRoot + "controller/log-controller.js");
        internalImportMapBuildItem.add("storage-controller", contextRoot + "controller/storage-controller.js");
        internalImportMapBuildItem.add("router-controller", contextRoot + "controller/router-controller.js");
        internalImportMapBuildItem.add("notifier", contextRoot + "controller/notifier.js");
        internalImportMapBuildItem.add("jsonrpc", contextRoot + "controller/jsonrpc.js");
        internalImportMapBuildItem.add("state/", contextRoot + "state/");
        internalImportMapBuildItem.add("theme-state", contextRoot + "state/theme-state.js");
        internalImportMapBuildItem.add("connection-state", contextRoot + "state/connection-state.js");
        internalImportMapBuildItem.add("devui-state", contextRoot + "state/devui-state.js");
        return internalImportMapBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void mapPageBuildTimeData(List<CardPageBuildItem> cards, List<MenuPageBuildItem> menus, List<FooterPageBuildItem> footers, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<BuildTimeConstBuildItem> buildTimeConstProducer) {
        Map<String, Object> buildTimeData;
        String extensionPathName;
        for (CardPageBuildItem card : cards) {
            extensionPathName = card.getExtensionPathName(curateOutcomeBuildItem);
            buildTimeData = this.getBuildTimeDataForCard(curateOutcomeBuildItem, card);
            if (buildTimeData.isEmpty()) continue;
            buildTimeConstProducer.produce((BuildItem)new BuildTimeConstBuildItem(extensionPathName, buildTimeData));
        }
        for (MenuPageBuildItem menu : menus) {
            extensionPathName = menu.getExtensionPathName(curateOutcomeBuildItem);
            buildTimeData = this.getBuildTimeDataForPage((AbstractPageBuildItem)menu);
            if (buildTimeData.isEmpty()) continue;
            buildTimeConstProducer.produce((BuildItem)new BuildTimeConstBuildItem(extensionPathName, buildTimeData));
        }
        for (FooterPageBuildItem footer : footers) {
            extensionPathName = footer.getExtensionPathName(curateOutcomeBuildItem);
            buildTimeData = this.getBuildTimeDataForPage((AbstractPageBuildItem)footer);
            if (buildTimeData.isEmpty()) continue;
            buildTimeConstProducer.produce((BuildItem)new BuildTimeConstBuildItem(extensionPathName, buildTimeData));
        }
    }

    private Map<String, Object> getBuildTimeDataForPage(AbstractPageBuildItem pageBuildItem) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (pageBuildItem.hasBuildTimeData()) {
            m.putAll(pageBuildItem.getBuildTimeData());
        }
        return m;
    }

    private Map<String, Object> getBuildTimeDataForCard(CurateOutcomeBuildItem curateOutcomeBuildItem, CardPageBuildItem pageBuildItem) {
        Map<String, Object> m = this.getBuildTimeDataForPage((AbstractPageBuildItem)pageBuildItem);
        if (pageBuildItem.getOptionalCard().isPresent()) {
            ArrayList<Page> pages = new ArrayList<Page>();
            List pageBuilders = pageBuildItem.getPages();
            for (PageBuilder pageBuilder : pageBuilders) {
                String path = pageBuildItem.getExtensionPathName(curateOutcomeBuildItem);
                pageBuilder.namespace(path);
                pageBuilder.extension(path);
                pages.add(pageBuilder.build());
            }
            m.put("pages", pages);
        }
        return m;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void createBuildTimeConstJsTemplate(CurateOutcomeBuildItem curateOutcomeBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, List<BuildTimeConstBuildItem> buildTimeConstBuildItems, BuildProducer<QuteTemplateBuildItem> quteTemplateProducer, BuildProducer<InternalImportMapBuildItem> internalImportMapProducer) {
        String contextRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath() + "dev-ui/";
        QuteTemplateBuildItem quteTemplateBuildItem = new QuteTemplateBuildItem("devui");
        InternalImportMapBuildItem internalImportMapBuildItem = new InternalImportMapBuildItem();
        for (BuildTimeConstBuildItem buildTimeConstBuildItem : buildTimeConstBuildItems) {
            HashMap<String, String> data = new HashMap<String, String>();
            if (buildTimeConstBuildItem.hasBuildTimeData()) {
                for (Map.Entry<String, Object> pageData : buildTimeConstBuildItem.getBuildTimeData().entrySet()) {
                    try {
                        String key = pageData.getKey();
                        String value = DatabindCodec.prettyMapper().writeValueAsString(pageData.getValue());
                        data.put(key, value);
                    }
                    catch (JsonProcessingException ex) {
                        log.error((Object)"Could not create Json Data for Dev UI page", (Throwable)ex);
                    }
                }
            }
            if (data.isEmpty()) continue;
            HashMap<String, HashMap<String, String>> qutedata = new HashMap<String, HashMap<String, String>>();
            qutedata.put("buildTimeData", data);
            String ref = buildTimeConstBuildItem.getExtensionPathName(curateOutcomeBuildItem) + "-data";
            String file = ref + ".js";
            quteTemplateBuildItem.add("build-time-data.js", file, qutedata);
            internalImportMapBuildItem.add(ref, contextRoot + file);
        }
        quteTemplateProducer.produce((BuildItem)quteTemplateBuildItem);
        internalImportMapProducer.produce((BuildItem)internalImportMapBuildItem);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void gatherMvnpmJars(BuildProducer<MvnpmBuildItem> mvnpmProducer, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        HashSet<URL> mvnpmJars = new HashSet<URL>();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> jarsWithImportMaps = tccl.getResources("META-INF/importmap.json");
            while (jarsWithImportMaps.hasMoreElements()) {
                URL jarUrl = jarsWithImportMaps.nextElement();
                JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
                mvnpmJars.add(connection.getJarFileURL());
            }
            mvnpmProducer.produce((BuildItem)new MvnpmBuildItem(mvnpmJars));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    QuteTemplateBuildItem createIndexHtmlTemplate(MvnpmBuildItem mvnpmBuildItem, ThemeVarsBuildItem themeVarsBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, List<InternalImportMapBuildItem> internalImportMapBuildItems) {
        QuteTemplateBuildItem quteTemplateBuildItem = new QuteTemplateBuildItem("devui");
        Aggregator aggregator = new Aggregator(mvnpmBuildItem.getMvnpmJars());
        for (InternalImportMapBuildItem importMapBuildItem : internalImportMapBuildItems) {
            Map<String, String> importMap = importMapBuildItem.getImportMap();
            aggregator.addMappings(importMap);
        }
        String importmap = aggregator.aggregateAsJson(nonApplicationRootPathBuildItem.getNonApplicationRootPath());
        aggregator.reset();
        String themeVars = themeVarsBuildItem.getTemplateValue();
        String nonApplicationRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath();
        String contextRoot = nonApplicationRoot + "dev-ui/";
        Map<String, String> data = Map.of("nonApplicationRoot", nonApplicationRoot, "contextRoot", contextRoot, "importmap", importmap, "themeVars", themeVars);
        quteTemplateBuildItem.add("index.html", data);
        return quteTemplateBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void loadAllBuildTimeTemplates(BuildProducer<StaticContentBuildItem> buildTimeContentProducer, List<QuteTemplateBuildItem> templates) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (QuteTemplateBuildItem template : templates) {
            ArrayList<DevUIContent> contentPerExtension = new ArrayList<DevUIContent>();
            List templatesWithData = template.getTemplateDatas();
            for (QuteTemplateBuildItem.TemplateData e : templatesWithData) {
                String templateName = e.getTemplateName();
                Map data = e.getData();
                String resourceName = "dev-ui-templates/build-time/" + templateName;
                String fileName = e.getFileName();
                try {
                    InputStream templateStream = cl.getResourceAsStream(resourceName);
                    try {
                        if (templateStream == null) continue;
                        byte[] templateContent = IoUtil.readBytes((InputStream)templateStream);
                        DevUIContent content = DevUIContent.builder().fileName(fileName).template(templateContent).addData(data).build();
                        contentPerExtension.add(content);
                    }
                    finally {
                        if (templateStream == null) continue;
                        templateStream.close();
                    }
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("An error occurred while processing " + resourceName, ioe);
                }
            }
            buildTimeContentProducer.produce((BuildItem)new StaticContentBuildItem("devui", contentPerExtension));
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void createBuildTimeData(BuildProducer<BuildTimeConstBuildItem> buildTimeConstProducer, BuildProducer<ThemeVarsBuildItem> themeVarsProducer, List<InternalPageBuildItem> internalPages, ExtensionsBuildItem extensionsBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchModeBuildItem, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem) {
        BuildTimeConstBuildItem internalBuildTimeData = new BuildTimeConstBuildItem("devui");
        this.addThemeBuildTimeData(internalBuildTimeData, themeVarsProducer);
        this.addMenuSectionBuildTimeData(internalBuildTimeData, internalPages, extensionsBuildItem);
        this.addFooterTabBuildTimeData(internalBuildTimeData, extensionsBuildItem);
        this.addVersionInfoBuildTimeData(internalBuildTimeData, nonApplicationRootPathBuildItem);
        this.addIdeBuildTimeData(internalBuildTimeData, effectiveIdeBuildItem, launchModeBuildItem);
        buildTimeConstProducer.produce((BuildItem)internalBuildTimeData);
    }

    private void addThemeBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, BuildProducer<ThemeVarsBuildItem> themeVarsProducer) {
        HashMap<String, Map<String, String>> themes = new HashMap<String, Map<String, String>>();
        HashMap<String, String> dark = new HashMap<String, String>();
        HashMap<String, String> light = new HashMap<String, String>();
        BuildTimeContentProcessor.computeColors(themes, dark, light);
        internalBuildTimeData.addBuildTimeData("themes", themes);
        themeVarsProducer.produce((BuildItem)new ThemeVarsBuildItem(light.keySet(), QUARKUS_BLUE.toString()));
    }

    private void addMenuSectionBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, List<InternalPageBuildItem> internalPages, ExtensionsBuildItem extensionsBuildItem) {
        ArrayList<Page> sectionMenu = new ArrayList<Page>();
        Collections.sort(internalPages, (t, t1) -> Integer.valueOf(t.getPosition()).compareTo(t1.getPosition()));
        for (InternalPageBuildItem internalPageBuildItem : internalPages) {
            List<Page> pages = internalPageBuildItem.getPages();
            for (Page page : pages) {
                sectionMenu.add(page);
            }
            internalBuildTimeData.addAllBuildTimeData(internalPageBuildItem.getBuildTimeData());
        }
        for (Extension e : extensionsBuildItem.getSectionMenuExtensions()) {
            List<Page> pagesFromExtension = e.getMenuPages();
            sectionMenu.addAll(pagesFromExtension);
        }
        internalBuildTimeData.addBuildTimeData("menuItems", sectionMenu);
    }

    private void addFooterTabBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, ExtensionsBuildItem extensionsBuildItem) {
        ArrayList<Page> footerTabs = new ArrayList<Page>();
        Page serverLog = ((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace("devui-logstream")).title("Server")).icon("font-awesome-solid:server")).componentLink("qwc-server-log.js").build();
        footerTabs.add(serverLog);
        Page testLog = ((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace("devui-continuous-testing")).title("Testing")).icon("font-awesome-solid:flask-vial")).componentLink("qwc-test-log.js").build();
        footerTabs.add(testLog);
        if (Version.getVersion().equalsIgnoreCase("999-SNAPSHOT")) {
            Page devUiLog = ((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace("devui-jsonrpcstream")).title("Dev UI")).icon("font-awesome-solid:satellite-dish")).componentLink("qwc-jsonrpc-messages.js").build();
            footerTabs.add(devUiLog);
        }
        for (Extension e : extensionsBuildItem.getFooterTabsExtensions()) {
            List<Page> tabsFromExtension = e.getFooterPages();
            footerTabs.addAll(tabsFromExtension);
        }
        internalBuildTimeData.addBuildTimeData("footerTabs", footerTabs);
        internalBuildTimeData.addBuildTimeData("loggerLevels", LEVELS);
    }

    private void addVersionInfoBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        String contextRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath() + "dev-ui/";
        HashMap<String, Object> applicationInfo = new HashMap<String, Object>();
        applicationInfo.put("contextRoot", contextRoot);
        applicationInfo.put("quarkusVersion", Version.getVersion());
        applicationInfo.put("applicationName", this.config.getOptionalValue("quarkus.application.name", String.class).orElse(""));
        applicationInfo.put("applicationVersion", this.config.getOptionalValue("quarkus.application.version", String.class).orElse(""));
        internalBuildTimeData.addBuildTimeData("applicationInfo", applicationInfo);
    }

    private void addIdeBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        HashMap<String, Object> ideInfo = new HashMap<String, Object>();
        boolean disable = launchModeBuildItem.getDevModeType().orElse(DevModeType.LOCAL) != DevModeType.LOCAL;
        ideInfo.put("disable", disable);
        if (effectiveIdeBuildItem.isPresent()) {
            EffectiveIdeBuildItem eibi = effectiveIdeBuildItem.get();
            if (!disable) {
                Ide ide = eibi.getIde();
                ideInfo.put("ideName", ide.name());
                ideInfo.put("idePackages", this.getAllUserPackages());
            }
        }
        internalBuildTimeData.addBuildTimeData("ideInfo", ideInfo);
    }

    private List<String> getAllUserPackages() {
        List sourcesDir = DevConsoleManager.getHotReplacementContext().getSourcesDir();
        ArrayList<String> packages = new ArrayList<String>();
        for (Path sourcePaths : sourcesDir) {
            packages.addAll(this.sourcePackagesForRoot(sourcePaths));
        }
        return packages;
    }

    private List<String> sourcePackagesForRoot(Path langPath) {
        if (!Files.exists(langPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        File[] rootFiles = langPath.toFile().listFiles();
        ArrayList<Path> rootPackages = new ArrayList<Path>(1);
        if (rootFiles != null) {
            for (File rootFile : rootFiles) {
                if (!rootFile.isDirectory()) continue;
                rootPackages.add(rootFile.toPath());
            }
        }
        if (rootPackages.isEmpty()) {
            return List.of("");
        }
        ArrayList<String> result = new ArrayList<String>(rootPackages.size());
        for (Path rootPackage : rootPackages) {
            ArrayList<String> paths = new ArrayList<String>();
            DetectPackageFileVisitor simpleFileVisitor = new DetectPackageFileVisitor(paths);
            try {
                Files.walkFileTree(rootPackage, simpleFileVisitor);
                if (paths.isEmpty()) continue;
                String commonPath = this.commonPath(paths);
                String rootPackageStr = commonPath.replace(langPath.toAbsolutePath().toString(), "").replace(File.separator, ".");
                if (rootPackageStr.startsWith(".")) {
                    rootPackageStr = rootPackageStr.substring(1);
                }
                if (rootPackageStr.endsWith(".")) {
                    rootPackageStr = rootPackageStr.substring(0, rootPackageStr.length() - 1);
                }
                result.add(rootPackageStr);
            }
            catch (IOException e) {
                log.debug((Object)"Unable to determine the sources directories", (Throwable)e);
            }
        }
        return result;
    }

    private String commonPath(List<String> paths) {
        Object commonPath = "";
        ArrayList<String[]> dirs = new ArrayList<String[]>(paths.size());
        for (int i = 0; i < paths.size(); ++i) {
            dirs.add(i, paths.get(i).split(Pattern.quote(File.separator)));
        }
        for (int j = 0; j < ((String[])dirs.get(0)).length; ++j) {
            String thisDir = ((String[])dirs.get(0))[j];
            boolean allMatched = true;
            for (int i = 1; i < dirs.size() && allMatched; ++i) {
                if (((String[])dirs.get(i)).length < j) {
                    allMatched = false;
                    break;
                }
                allMatched = ((String[])dirs.get(i))[j].equals(thisDir);
            }
            if (!allMatched) break;
            commonPath = (String)commonPath + thisDir + File.separator;
        }
        return commonPath;
    }

    private static void computeColors(Map<String, Map<String, String>> themes, Map<String, String> dark, Map<String, String> light) {
        light.put("--quarkus-blue", QUARKUS_BLUE.toString());
        dark.put("--quarkus-blue", QUARKUS_BLUE.toString());
        light.put("--quarkus-red", QUARKUS_RED.toString());
        dark.put("--quarkus-red", QUARKUS_RED.toString());
        light.put("--quarkus-center", QUARKUS_DARK.toString());
        dark.put("--quarkus-center", QUARKUS_LIGHT.toString());
        light.put("--lumo-base-color", Color.from(0, 100, 100).toString());
        dark.put("--lumo-base-color", Color.from(210, 10, 23).toString());
        light.put("--lumo-contrast-5pct", Color.from(214, 61, 25, 0.05).toString());
        dark.put("--lumo-contrast-5pct", Color.from(214, 65, 85, 0.06).toString());
        light.put("--lumo-contrast-10pct", Color.from(214, 57, 24, 0.1).toString());
        dark.put("--lumo-contrast-10pct", Color.from(214, 60, 80, 0.14).toString());
        light.put("--lumo-contrast-20pct", Color.from(214, 53, 23, 0.16).toString());
        dark.put("--lumo-contrast-20pct", Color.from(214, 64, 82, 0.23).toString());
        light.put("--lumo-contrast-30pct", Color.from(214, 50, 22, 0.26).toString());
        dark.put("--lumo-contrast-30pct", Color.from(214, 69, 84, 0.32).toString());
        light.put("--lumo-contrast-40pct", Color.from(214, 47, 21, 0.38).toString());
        dark.put("--lumo-contrast-40pct", Color.from(214, 73, 86, 0.41).toString());
        light.put("--lumo-contrast-50pct", Color.from(214, 45, 20, 0.52).toString());
        dark.put("--lumo-contrast-50pct", Color.from(214, 78, 88, 0.5).toString());
        light.put("--lumo-contrast-60pct", Color.from(214, 43, 19, 0.6).toString());
        dark.put("--lumo-contrast-60pct", Color.from(214, 82, 90, 0.6).toString());
        light.put("--lumo-contrast-70pct", Color.from(214, 42, 18, 0.69).toString());
        dark.put("--lumo-contrast-70pct", Color.from(214, 87, 92, 0.7).toString());
        light.put("--lumo-contrast-80pct", Color.from(214, 41, 17, 0.83).toString());
        dark.put("--lumo-contrast-80pct", Color.from(214, 91, 94, 0.8).toString());
        light.put("--lumo-contrast-90pct", Color.from(214, 40, 16, 0.94).toString());
        dark.put("--lumo-contrast-90pct", Color.from(214, 96, 96, 0.9).toString());
        light.put("--lumo-contrast", Color.from(214, 35, 15).toString());
        dark.put("--lumo-contrast", Color.from(214, 100, 98).toString());
        light.put("--lumo-primary-color-10pct", Color.from(214, 100, 60, 0.13).toString());
        dark.put("--lumo-primary-color-10pct", Color.from(214, 90, 63, 0.1).toString());
        light.put("--lumo-primary-color-50pct", Color.from(QUARKUS_BLUE, 0.76).toString());
        dark.put("--lumo-primary-color-50pct", Color.from(QUARKUS_BLUE, 0.5).toString());
        light.put("--lumo-primary-color", QUARKUS_BLUE.toString());
        dark.put("--lumo-primary-color", QUARKUS_BLUE.toString());
        light.put("--lumo-primary-text-color", QUARKUS_BLUE.toString());
        dark.put("--lumo-primary-text-color", QUARKUS_BLUE.toString());
        light.put("--lumo-primary-contrast-color", Color.from(0, 100, 100).toString());
        dark.put("--lumo-primary-contrast-color", Color.from(0, 100, 100).toString());
        light.put("--lumo-error-color-10pct", Color.from(3, 85, 49, 0.1).toString());
        dark.put("--lumo-error-color-10pct", Color.from(3, 90, 63, 0.1).toString());
        light.put("--lumo-error-color-50pct", Color.from(3, 85, 49, 0.5).toString());
        dark.put("--lumo-error-color-50pct", Color.from(3, 90, 63, 0.5).toString());
        light.put("--lumo-error-color", Color.from(3, 85, 48).toString());
        dark.put("--lumo-error-color", Color.from(3, 90, 63).toString());
        light.put("--lumo-error-text-color", Color.from(3, 89, 42).toString());
        dark.put("--lumo-error-text-color", Color.from(3, 100, 67).toString());
        light.put("--lumo-error-contrast-color", Color.from(0, 100, 100).toString());
        dark.put("--lumo-error-contrast-color", Color.from(0, 100, 100).toString());
        light.put("--lumo-warning-color-10pct", Color.from(30, 100, 50, 0.1).toString());
        dark.put("--lumo-warning-color-10pct", Color.from(30, 100, 50, 0.1).toString());
        light.put("--lumo-warning-color-50pct", Color.from(30, 100, 50, 0.5).toString());
        dark.put("--lumo-warning-color-50pct", Color.from(30, 100, 50, 0.5).toString());
        light.put("--lumo-warning-color", Color.from(30, 100, 50).toString());
        dark.put("--lumo-warning-color", Color.from(30, 100, 50).toString());
        light.put("--lumo-warning-text-color", Color.from(30, 89, 42).toString());
        dark.put("--lumo-warning-text-color", Color.from(30, 100, 67).toString());
        light.put("--lumo-warning-contrast-color", Color.from(0, 100, 100).toString());
        dark.put("--lumo-warning-contrast-color", Color.from(0, 100, 100).toString());
        light.put("--lumo-success-color-10pct", Color.from(145, 72, 31, 0.1).toString());
        dark.put("--lumo-success-color-10pct", Color.from(145, 65, 42, 0.1).toString());
        light.put("--lumo-success-color-50pct", Color.from(145, 72, 31, 0.5).toString());
        dark.put("--lumo-success-color-50pct", Color.from(145, 65, 42, 0.5).toString());
        light.put("--lumo-success-color", Color.from(145, 72, 30).toString());
        dark.put("--lumo-success-color", Color.from(145, 65, 42).toString());
        light.put("--lumo-success-text-color", Color.from(145, 85, 25).toString());
        dark.put("--lumo-success-text-color", Color.from(145, 85, 47).toString());
        light.put("--lumo-success-contrast-color", Color.from(0, 100, 100).toString());
        dark.put("--lumo-success-contrast-color", Color.from(0, 100, 100).toString());
        light.put("--lumo-header-text-color", Color.from(214, 35, 15).toString());
        dark.put("--lumo-header-text-color", Color.from(214, 100, 98).toString());
        light.put("--lumo-body-text-color", Color.from(214, 40, 16, 0.94).toString());
        dark.put("--lumo-body-text-color", Color.from(214, 96, 96, 0.9).toString());
        light.put("--lumo-secondary-text-color", Color.from(214, 42, 18, 0.69).toString());
        dark.put("--lumo-secondary-text-color", Color.from(214, 87, 92, 0.7).toString());
        light.put("--lumo-tertiary-text-color", Color.from(214, 45, 20, 0.52).toString());
        dark.put("--lumo-tertiary-text-color", Color.from(214, 78, 88, 0.5).toString());
        light.put("--lumo-disabled-text-color", Color.from(214, 50, 22, 0.26).toString());
        dark.put("--lumo-disabled-text-color", Color.from(214, 69, 84, 0.32).toString());
        themes.put("dark", dark);
        themes.put("light", light);
    }

    private static class DetectPackageFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<String> paths;

        public DetectPackageFileVisitor(List<String> paths) {
            this.paths = paths;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            boolean hasRegularFiles = false;
            File[] files = dir.toFile().listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    hasRegularFiles = true;
                    break;
                }
            }
            if (hasRegularFiles) {
                this.paths.add(dir.toAbsolutePath().toString());
            }
            return FileVisitResult.CONTINUE;
        }
    }

    static class Color {
        private int hue;
        private int saturation;
        private int lightness;
        private double alpha;

        private Color(int hue, int saturation, int lightness, double alpha) {
            if (hue < 0 || hue > 360) {
                throw new RuntimeException("Invalid hue, number needs to be between 0 and 360. Defines a degree on the color wheel");
            }
            this.hue = hue;
            if (saturation < 0 || saturation > 100) {
                throw new RuntimeException("Invalid saturation, number needs to be between 0 and 100. 0% is a shade of gray and 100% is the full color (full saturation)");
            }
            this.saturation = saturation;
            if (lightness < 0 || lightness > 100) {
                throw new RuntimeException("Invalid lightness, number needs to be between 0 and 100. 0% is black, 50% is normal, and 100% is white");
            }
            this.lightness = lightness;
            if (alpha < 0.0 || alpha > 1.0) {
                throw new RuntimeException("Invalid alpha, number needs to be between 0 and 1. 0 is fully transparent, 1 is not transparent at all");
            }
            this.alpha = alpha;
        }

        public String toString() {
            return "hsla(" + this.hue + ", " + this.saturation + "%, " + this.lightness + "%, " + this.alpha + ")";
        }

        static Color from(Color color, double alpha) {
            return new Color(color.hue, color.saturation, color.lightness, alpha);
        }

        static Color from(int hue, int saturation, int lightness) {
            return new Color(hue, saturation, lightness, 1.0);
        }

        static Color from(int hue, int saturation, int lightness, double alpha) {
            return new Color(hue, saturation, lightness, alpha);
        }
    }
}

