/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.LiveReloadConfig;
import io.quarkus.runtime.QuarkusBindException;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.runtime.shutdown.ShutdownConfig;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.HttpServerOptionsCustomizer;
import io.quarkus.vertx.http.runtime.AccessLogConfig;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.ForwardedServerRequestWrapper;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HeaderConfig;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.QuarkusErrorHandler;
import io.quarkus.vertx.http.runtime.ResumingRequestWrapper;
import io.quarkus.vertx.http.runtime.SameSiteCookieConfig;
import io.quarkus.vertx.http.runtime.SameSiteNoneIncompatibleClientChecker;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.devmode.RemoteSyncHandler;
import io.quarkus.vertx.http.runtime.devmode.VertxHttpHotReplacementSetup;
import io.quarkus.vertx.http.runtime.filters.Filter;
import io.quarkus.vertx.http.runtime.filters.Filters;
import io.quarkus.vertx.http.runtime.filters.GracefulShutdownFilter;
import io.quarkus.vertx.http.runtime.filters.QuarkusRequestWrapper;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogHandler;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogReceiver;
import io.quarkus.vertx.http.runtime.filters.accesslog.DefaultAccessLogReceiver;
import io.quarkus.vertx.http.runtime.filters.accesslog.JBossLoggingAccessLogReceiver;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import jakarta.enterprise.event.Event;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;
import org.jboss.logging.Logger;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class VertxHttpRecorder {
    public static final String REQUEST_START_TIME = "io.quarkus.request-start-time";
    public static final String MAX_REQUEST_SIZE_KEY = "io.quarkus.max-request-size";
    public static final int BEFORE_DEFAULT_ROUTE_ORDER_MARK = 1000;
    public static final int DEFAULT_ROUTE_ORDER = 10000;
    public static final int AFTER_DEFAULT_ROUTE_ORDER_MARK = 20000;
    private static final Logger LOGGER = Logger.getLogger((String)VertxHttpRecorder.class.getName());
    private static volatile Handler<RoutingContext> hotReplacementHandler;
    private static volatile HotReplacementContext hotReplacementContext;
    private static volatile RemoteSyncHandler remoteSyncHandler;
    private static volatile Runnable closeTask;
    static volatile Handler<HttpServerRequest> rootHandler;
    private static volatile Handler<RoutingContext> nonApplicationRedirectHandler;
    private static volatile int actualHttpPort;
    private static volatile int actualHttpsPort;
    public static final String GET = "GET";
    private static final Handler<HttpServerRequest> ACTUAL_ROOT;
    final HttpBuildTimeConfig httpBuildTimeConfig;
    final RuntimeValue<HttpConfiguration> httpConfiguration;
    protected static ServerBootstrap virtualBootstrap;
    protected static ChannelFuture virtualBootstrapChannel;
    public static VirtualAddress VIRTUAL_HTTP;
    private static final List<HttpMethod> CAN_HAVE_BODY;

    public VertxHttpRecorder(HttpBuildTimeConfig httpBuildTimeConfig, RuntimeValue<HttpConfiguration> httpConfiguration) {
        this.httpBuildTimeConfig = httpBuildTimeConfig;
        this.httpConfiguration = httpConfiguration;
    }

    public static void setHotReplacement(Handler<RoutingContext> handler, HotReplacementContext hrc) {
        hotReplacementHandler = handler;
        hotReplacementContext = hrc;
    }

    public static void shutDownDevMode() {
        if (closeTask != null) {
            closeTask.run();
            closeTask = null;
        }
        rootHandler = null;
        hotReplacementHandler = null;
    }

    public static void startServerAfterFailedStart() {
        Vertx vertx;
        Supplier supplier;
        if (closeTask != null) {
            Handler<RoutingContext> prevHotReplacementHandler = hotReplacementHandler;
            VertxHttpRecorder.shutDownDevMode();
            hotReplacementHandler = prevHotReplacementHandler;
        }
        if ((supplier = VertxCoreRecorder.getVertx()) == null) {
            VertxConfiguration vertxConfiguration = new VertxConfiguration();
            ConfigInstantiator.handleObject((Object)vertxConfiguration);
            vertx = (Vertx)VertxCoreRecorder.recoverFailedStart((VertxConfiguration)vertxConfiguration).get();
        } else {
            vertx = (Vertx)supplier.get();
        }
        try {
            HttpBuildTimeConfig buildConfig = new HttpBuildTimeConfig();
            ConfigInstantiator.handleObject((Object)buildConfig);
            HttpConfiguration config = new HttpConfiguration();
            ConfigInstantiator.handleObject((Object)config);
            if (config.host == null) {
                config.host = "localhost";
            }
            Router router = Router.router((Vertx)vertx);
            if (hotReplacementHandler != null) {
                router.route().order(Integer.MIN_VALUE).blockingHandler(hotReplacementHandler);
            }
            Object root = router;
            LiveReloadConfig liveReloadConfig = new LiveReloadConfig();
            ConfigInstantiator.handleObject((Object)liveReloadConfig);
            if (liveReloadConfig.password.isPresent() && hotReplacementContext.getDevModeType() == DevModeType.REMOTE_SERVER_SIDE) {
                remoteSyncHandler = new RemoteSyncHandler((String)liveReloadConfig.password.get(), (Handler<HttpServerRequest>)root, hotReplacementContext);
                root = remoteSyncHandler;
            }
            rootHandler = root;
            VertxHttpRecorder.doServerStart(vertx, buildConfig, config, LaunchMode.DEVELOPMENT, new Supplier<Integer>(){

                @Override
                public Integer get() {
                    return ProcessorInfo.availableProcessors();
                }
            }, null, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeValue<Router> initializeRouter(Supplier<Vertx> vertxRuntimeValue) {
        Vertx vertx = vertxRuntimeValue.get();
        Router router = Router.router((Vertx)vertx);
        return new RuntimeValue((Object)router);
    }

    public RuntimeValue<io.vertx.mutiny.ext.web.Router> createMutinyRouter(RuntimeValue<Router> router) {
        return new RuntimeValue((Object)new io.vertx.mutiny.ext.web.Router((Router)router.getValue()));
    }

    public void startServer(Supplier<Vertx> vertx, ShutdownContext shutdown, LaunchMode launchMode, boolean startVirtual, boolean startSocket, Supplier<Integer> ioThreads, List<String> websocketSubProtocols, boolean auxiliaryApplication) throws IOException {
        if (startVirtual) {
            VertxHttpRecorder.initializeVirtual(vertx.get());
            shutdown.addShutdownTask(() -> {
                try {
                    virtualBootstrapChannel.channel().close().sync();
                }
                catch (InterruptedException e) {
                    LOGGER.warn((Object)"Unable to close virtualBootstrapChannel");
                }
                finally {
                    virtualBootstrapChannel = null;
                    virtualBootstrap = null;
                }
            });
        }
        HttpConfiguration httpConfiguration = (HttpConfiguration)this.httpConfiguration.getValue();
        if (startSocket && (httpConfiguration.hostEnabled || httpConfiguration.domainSocketEnabled) && closeTask == null) {
            VertxHttpRecorder.doServerStart(vertx.get(), this.httpBuildTimeConfig, httpConfiguration, launchMode, ioThreads, websocketSubProtocols, auxiliaryApplication);
            if (launchMode != LaunchMode.DEVELOPMENT) {
                shutdown.addShutdownTask(closeTask);
            } else {
                shutdown.addShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        VertxHttpHotReplacementSetup.handleDevModeRestart();
                    }
                });
            }
        }
    }

    public void mountFrameworkRouter(RuntimeValue<Router> mainRouter, RuntimeValue<Router> frameworkRouter, String frameworkPath) {
        ((Router)mainRouter.getValue()).mountSubRouter(frameworkPath, (Router)frameworkRouter.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public void finalizeRouter(BeanContainer container, Consumer<Route> defaultRouteHandler, List<Filter> filterList, Supplier<Vertx> vertx, LiveReloadConfig liveReloadConfig, Optional<RuntimeValue<Router>> mainRouterRuntimeValue, RuntimeValue<Router> httpRouterRuntimeValue, RuntimeValue<io.vertx.mutiny.ext.web.Router> mutinyRouter, RuntimeValue<Router> frameworkRouter, String rootPath, String nonRootPath, LaunchMode launchMode, boolean requireBodyHandler, final Handler<RoutingContext> bodyHandler, GracefulShutdownFilter gracefulShutdownFilter, ShutdownConfig shutdownConfig, Executor executor) {
        void var24_44;
        void var24_41;
        Map<String, HeaderConfig> map;
        Map<String, FilterConfig> filtersInConfig;
        HttpConfiguration httpConfiguration = (HttpConfiguration)this.httpConfiguration.getValue();
        Router httpRouteRouter = (Router)httpRouterRuntimeValue.getValue();
        Event event = Arc.container().beanManager().getEvent();
        Filters filters = new Filters();
        event.select(Filters.class, new Annotation[0]).fire((Object)filters);
        filterList.addAll(filters.getFilters());
        event.select(Router.class, new Annotation[0]).fire((Object)httpRouteRouter);
        event.select(io.vertx.mutiny.ext.web.Router.class, new Annotation[0]).fire((Object)((io.vertx.mutiny.ext.web.Router)mutinyRouter.getValue()));
        for (Filter filter : filterList) {
            if (filter.getHandler() == null) continue;
            if (filter.isFailureHandler()) {
                httpRouteRouter.route().order(-1 * filter.getPriority()).failureHandler(filter.getHandler());
                continue;
            }
            httpRouteRouter.route().order(-1 * filter.getPriority()).handler(filter.getHandler());
        }
        if (defaultRouteHandler != null) {
            defaultRouteHandler.accept(httpRouteRouter.route().order(10000));
        }
        if (this.httpBuildTimeConfig.enableCompression) {
            httpRouteRouter.route().order(0).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext ctx) {
                    ctx.response().putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY);
                    ctx.next();
                }
            });
        }
        httpRouteRouter.route().last().failureHandler((Handler)new QuarkusErrorHandler(launchMode.isDevOrTest(), httpConfiguration.unhandledErrorContentTypeDefault));
        if (requireBodyHandler) {
            httpRouteRouter.route().order(-2147483647).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext routingContext) {
                    routingContext.request().resume();
                    bodyHandler.handle((Object)routingContext);
                }
            });
        }
        if (httpConfiguration.limits.maxBodySize.isPresent()) {
            final long limit = httpConfiguration.limits.maxBodySize.get().asLongValue();
            final Long l = limit;
            httpRouteRouter.route().order(-2).handler((Handler)new Handler<RoutingContext>(){

                public void handle(final RoutingContext event) {
                    String lengthString = event.request().headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    if (lengthString != null) {
                        long length = Long.parseLong(lengthString);
                        if (length > limit) {
                            event.response().headers().add((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)"close");
                            event.response().setStatusCode(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.code());
                            event.response().endHandler((Handler)new Handler<Void>(){

                                public void handle(Void e) {
                                    event.request().connection().close();
                                }
                            });
                            event.response().end();
                            return;
                        }
                    } else {
                        event.put(VertxHttpRecorder.MAX_REQUEST_SIZE_KEY, (Object)l);
                    }
                    event.next();
                }
            });
        }
        if (!(filtersInConfig = httpConfiguration.filter).isEmpty()) {
            for (Map.Entry<String, FilterConfig> entry : filtersInConfig.entrySet()) {
                FilterConfig filterConfig = entry.getValue();
                String matches = filterConfig.matches;
                int order = filterConfig.order.orElse(Integer.MIN_VALUE);
                Optional<List<String>> methods = filterConfig.methods;
                final Map<String, String> headers2 = filterConfig.header;
                if (methods.isEmpty()) {
                    httpRouteRouter.routeWithRegex(matches).order(order).handler((Handler)new Handler<RoutingContext>(){

                        public void handle(RoutingContext event) {
                            event.response().headers().setAll(headers2);
                            event.next();
                        }
                    });
                    continue;
                }
                for (String method : methods.get()) {
                    httpRouteRouter.routeWithRegex(HttpMethod.valueOf((String)method.toUpperCase(Locale.ROOT)), matches).order(order).handler((Handler)new Handler<RoutingContext>(){

                        public void handle(RoutingContext event) {
                            event.response().headers().setAll(headers2);
                            event.next();
                        }
                    });
                }
            }
        }
        if (!(map = httpConfiguration.header).isEmpty()) {
            for (Map.Entry<String, HeaderConfig> entry : map.entrySet()) {
                final String name = entry.getKey();
                final HeaderConfig config = entry.getValue();
                if (config.methods.isEmpty()) {
                    httpRouteRouter.route(config.path).order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                        public void handle(RoutingContext event) {
                            event.response().headers().set(name, config.value);
                            event.next();
                        }
                    });
                    continue;
                }
                for (String method : config.methods.get()) {
                    httpRouteRouter.route(HttpMethod.valueOf((String)method.toUpperCase(Locale.ROOT)), config.path).order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                        public void handle(RoutingContext event) {
                            event.response().headers().add(name, config.value);
                            event.next();
                        }
                    });
                }
            }
        }
        if (rootPath.equals("/")) {
            if (hotReplacementHandler != null) {
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                httpRouteRouter.route().order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                    public void handle(RoutingContext event) {
                        Thread.currentThread().setContextClassLoader(classLoader);
                        hotReplacementHandler.handle((Object)event);
                    }
                });
            }
            Router router = httpRouteRouter;
        } else {
            Router router = mainRouterRuntimeValue.isPresent() ? (Router)mainRouterRuntimeValue.get().getValue() : Router.router((Vertx)vertx.get());
            router.mountSubRouter(rootPath, httpRouteRouter);
            if (hotReplacementHandler != null) {
                final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
                router.route().order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                    public void handle(RoutingContext event) {
                        Thread.currentThread().setContextClassLoader(currentCl);
                        hotReplacementHandler.handle((Object)event);
                    }
                });
            }
            Router router2 = router;
        }
        this.warnIfProxyAddressForwardingAllowedWithMultipleHeaders(httpConfiguration);
        ForwardingProxyOptions forwardingProxyOptions = ForwardingProxyOptions.from(httpConfiguration);
        if (forwardingProxyOptions.proxyAddressForwarding) {
            void var24_35;
            void delegate = var24_35;
            Handler<HttpServerRequest> handler = new Handler<HttpServerRequest>((Handler)delegate, forwardingProxyOptions){
                final /* synthetic */ Handler val$delegate;
                final /* synthetic */ ForwardingProxyOptions val$forwardingProxyOptions;
                {
                    this.val$delegate = handler;
                    this.val$forwardingProxyOptions = forwardingProxyOptions;
                }

                public void handle(HttpServerRequest event) {
                    this.val$delegate.handle((Object)new ForwardedServerRequestWrapper(event, this.val$forwardingProxyOptions));
                }
            };
        }
        boolean quarkusWrapperNeeded = false;
        if (shutdownConfig.isShutdownTimeoutSet()) {
            void var24_37;
            gracefulShutdownFilter.next((Handler<HttpServerRequest>)var24_37);
            GracefulShutdownFilter gracefulShutdownFilter2 = gracefulShutdownFilter;
            quarkusWrapperNeeded = true;
        }
        AccessLogConfig accessLog = httpConfiguration.accessLog;
        if (accessLog.enabled) {
            AccessLogReceiver receiver;
            if (accessLog.logToFile) {
                File outputDir = accessLog.logDirectory.isPresent() ? new File(accessLog.logDirectory.get()) : new File("");
                receiver = new DefaultAccessLogReceiver(executor, outputDir, accessLog.baseFileName, accessLog.logSuffix, accessLog.rotate);
            } else {
                receiver = new JBossLoggingAccessLogReceiver(accessLog.category);
            }
            AccessLogHandler handler = new AccessLogHandler(receiver, accessLog.pattern, this.getClass().getClassLoader(), accessLog.excludePattern);
            if (rootPath.equals("/") || nonRootPath.equals("/")) {
                ((Router)mainRouterRuntimeValue.orElse(httpRouterRuntimeValue).getValue()).route().order(Integer.MIN_VALUE).handler((Handler)handler);
            } else if (nonRootPath.startsWith(rootPath)) {
                httpRouteRouter.route().order(Integer.MIN_VALUE).handler((Handler)handler);
            } else if (rootPath.startsWith(nonRootPath)) {
                ((Router)frameworkRouter.getValue()).route().order(Integer.MIN_VALUE).handler((Handler)handler);
            } else {
                httpRouteRouter.route().order(Integer.MIN_VALUE).handler((Handler)handler);
                ((Router)frameworkRouter.getValue()).route().order(Integer.MIN_VALUE).handler((Handler)handler);
            }
            quarkusWrapperNeeded = true;
        }
        BiConsumer<Cookie, HttpServerRequest> cookieFunction = null;
        if (!httpConfiguration.sameSiteCookie.isEmpty()) {
            cookieFunction = this.processSameSiteConfig(httpConfiguration.sameSiteCookie);
            quarkusWrapperNeeded = true;
        }
        BiConsumer<Cookie, HttpServerRequest> cookieConsumer = cookieFunction;
        if (quarkusWrapperNeeded) {
            void var24_39;
            void old = var24_39;
            Handler<HttpServerRequest> handler = new Handler<HttpServerRequest>((Handler)old, cookieConsumer){
                final /* synthetic */ Handler val$old;
                final /* synthetic */ BiConsumer val$cookieConsumer;
                {
                    this.val$old = handler;
                    this.val$cookieConsumer = biConsumer;
                }

                public void handle(HttpServerRequest event) {
                    this.val$old.handle((Object)new QuarkusRequestWrapper(event, this.val$cookieConsumer));
                }
            };
        }
        void delegate = var24_41;
        Handler<HttpServerRequest> handler = new Handler<HttpServerRequest>((Handler)delegate){
            final /* synthetic */ Handler val$delegate;
            {
                this.val$delegate = handler;
            }

            public void handle(final HttpServerRequest event) {
                if (!VertxContext.isOnDuplicatedContext()) {
                    io.vertx.core.Context context = VertxContext.createNewDuplicatedContext();
                    context.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void x) {
                            VertxContextSafetyToggle.setCurrentContextSafe((boolean)true);
                            val$delegate.handle((Object)new ResumingRequestWrapper(event));
                        }
                    });
                } else {
                    VertxContextSafetyToggle.setCurrentContextSafe((boolean)true);
                    this.val$delegate.handle((Object)new ResumingRequestWrapper(event));
                }
            }
        };
        if (httpConfiguration.recordRequestStartTime) {
            httpRouteRouter.route().order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext event) {
                    event.put(VertxHttpRecorder.REQUEST_START_TIME, (Object)System.nanoTime());
                    event.next();
                }
            });
        }
        if (launchMode == LaunchMode.DEVELOPMENT && liveReloadConfig.password.isPresent() && hotReplacementContext.getDevModeType() == DevModeType.REMOTE_SERVER_SIDE) {
            RemoteSyncHandler remoteSyncHandler = VertxHttpRecorder.remoteSyncHandler = new RemoteSyncHandler((String)liveReloadConfig.password.get(), handler, hotReplacementContext);
        }
        rootHandler = var24_44;
    }

    private void warnIfProxyAddressForwardingAllowedWithMultipleHeaders(HttpConfiguration httpConfiguration) {
        ProxyConfig proxyConfig = httpConfiguration.proxy;
        boolean proxyAddressForwardingActivated = proxyConfig.proxyAddressForwarding;
        boolean forwardedActivated = proxyConfig.allowForwarded;
        boolean xForwardedActivated = httpConfiguration.proxy.allowXForwarded.orElse(!forwardedActivated);
        if (proxyAddressForwardingActivated && forwardedActivated && xForwardedActivated) {
            LOGGER.warn((Object)"The X-Forwarded-* and Forwarded headers will be considered when determining the proxy address. This configuration can cause a security issue as clients can forge requests and send a forwarded header that is not overwritten by the proxy. Please consider use one of these headers just to forward the proxy address in requests.");
        }
    }

    private static void doServerStart(final Vertx vertx, HttpBuildTimeConfig httpBuildTimeConfig, final HttpConfiguration httpConfiguration, final LaunchMode launchMode, Supplier<Integer> eventLoops, List<String> websocketSubProtocols, boolean auxiliaryApplication) throws IOException {
        final HttpServerOptions httpServerOptions = VertxHttpRecorder.createHttpServerOptions(httpBuildTimeConfig, httpConfiguration, launchMode, websocketSubProtocols);
        final HttpServerOptions domainSocketOptions = VertxHttpRecorder.createDomainSocketOptions(httpBuildTimeConfig, httpConfiguration, websocketSubProtocols);
        HttpServerOptions tmpSslConfig = VertxHttpRecorder.createSslOptions(httpBuildTimeConfig, httpConfiguration, launchMode, websocketSubProtocols);
        if (Arc.container() != null) {
            List instances = Arc.container().listAll(HttpServerOptionsCustomizer.class, new Annotation[0]);
            for (InstanceHandle instance : instances) {
                HttpServerOptionsCustomizer customizer = (HttpServerOptionsCustomizer)instance.get();
                if (httpServerOptions != null) {
                    customizer.customizeHttpServer(httpServerOptions);
                }
                if (tmpSslConfig != null) {
                    customizer.customizeHttpsServer(tmpSslConfig);
                }
                if (domainSocketOptions == null) continue;
                customizer.customizeDomainSocketServer(domainSocketOptions);
            }
        }
        if (tmpSslConfig != null && tmpSslConfig.getKeyCertOptions() == null) {
            tmpSslConfig = null;
        }
        final HttpServerOptions sslConfig = tmpSslConfig;
        if (httpConfiguration.insecureRequests != HttpConfiguration.InsecureRequests.ENABLED && sslConfig == null) {
            throw new IllegalStateException("Cannot set quarkus.http.redirect-insecure-requests without enabling SSL.");
        }
        int eventLoopCount = eventLoops.get();
        int ioThreads = httpConfiguration.ioThreads.isPresent() ? Math.min(httpConfiguration.ioThreads.getAsInt(), eventLoopCount) : (launchMode.isDevOrTest() ? Math.min(2, eventLoopCount) : eventLoopCount);
        final CompletableFuture futureResult = new CompletableFuture();
        final AtomicInteger connectionCount = new AtomicInteger();
        vertx.deployVerticle((Supplier)new Supplier<Verticle>(){

            @Override
            public Verticle get() {
                return new WebDeploymentVerticle(httpServerOptions, sslConfig, domainSocketOptions, launchMode, httpConfiguration.insecureRequests, httpConfiguration, connectionCount);
            }
        }, new DeploymentOptions().setInstances(ioThreads), (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> event) {
                if (event.failed()) {
                    Throwable effectiveCause = event.cause();
                    if (effectiveCause instanceof BindException) {
                        List<Object> portsUsed = Collections.emptyList();
                        if (sslConfig == null && httpServerOptions != null) {
                            portsUsed = List.of(Integer.valueOf(httpServerOptions.getPort()));
                        } else if (httpConfiguration.insecureRequests == HttpConfiguration.InsecureRequests.DISABLED && sslConfig != null) {
                            portsUsed = List.of(Integer.valueOf(sslConfig.getPort()));
                        } else if (sslConfig != null && httpConfiguration.insecureRequests == HttpConfiguration.InsecureRequests.ENABLED && httpServerOptions != null) {
                            portsUsed = List.of(Integer.valueOf(httpServerOptions.getPort()), Integer.valueOf(sslConfig.getPort()));
                        }
                        effectiveCause = new QuarkusBindException((BindException)effectiveCause, portsUsed);
                    }
                    futureResult.completeExceptionally(effectiveCause);
                } else {
                    futureResult.complete((String)event.result());
                }
            }
        });
        try {
            final String deploymentId = (String)futureResult.get();
            VertxCoreRecorder.setWebDeploymentId((String)deploymentId);
            closeTask = new Runnable(){

                @Override
                public synchronized void run() {
                    if (closeTask == this) {
                        if (vertx.deploymentIDs().contains(deploymentId)) {
                            final CountDownLatch latch = new CountDownLatch(1);
                            try {
                                vertx.undeploy(deploymentId, (Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> event) {
                                        latch.countDown();
                                    }
                                });
                            }
                            catch (Exception e) {
                                LOGGER.warn((Object)"Failed to undeploy deployment ", (Throwable)e);
                            }
                            try {
                                latch.await();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        closeTask = null;
                        if (remoteSyncHandler != null) {
                            remoteSyncHandler.close();
                            remoteSyncHandler = null;
                        }
                    }
                }
            };
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to start HTTP server", e);
        }
        VertxHttpRecorder.setHttpServerTiming(httpConfiguration.insecureRequests, httpServerOptions, sslConfig, domainSocketOptions, auxiliaryApplication);
    }

    private static void setHttpServerTiming(HttpConfiguration.InsecureRequests insecureRequests, HttpServerOptions httpServerOptions, HttpServerOptions sslConfig, HttpServerOptions domainSocketOptions, boolean auxiliaryApplication) {
        StringBuilder serverListeningMessage = new StringBuilder("Listening on: ");
        int socketCount = 0;
        if (httpServerOptions != null && !HttpConfiguration.InsecureRequests.DISABLED.equals((Object)insecureRequests)) {
            serverListeningMessage.append(String.format("http://%s:%s", httpServerOptions.getHost(), actualHttpPort));
            ++socketCount;
        }
        if (sslConfig != null) {
            if (socketCount > 0) {
                serverListeningMessage.append(" and ");
            }
            serverListeningMessage.append(String.format("https://%s:%s", sslConfig.getHost(), actualHttpsPort));
            ++socketCount;
        }
        if (domainSocketOptions != null) {
            if (socketCount > 0) {
                serverListeningMessage.append(" and ");
            }
            serverListeningMessage.append(String.format("unix:%s", domainSocketOptions.getHost()));
        }
        Timing.setHttpServer((String)serverListeningMessage.toString(), (boolean)auxiliaryApplication);
    }

    private static HttpServerOptions createSslOptions(HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, LaunchMode launchMode, List<String> websocketSubProtocols) throws IOException {
        KeyStoreOptions options;
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        ServerSslConfig sslConfig = httpConfiguration.ssl;
        Optional<Path> certFile = sslConfig.certificate.file;
        Optional<Path> keyFile = sslConfig.certificate.keyFile;
        ArrayList<Path> keys = new ArrayList<Path>();
        ArrayList<Path> certificates = new ArrayList<Path>();
        if (sslConfig.certificate.keyFiles.isPresent()) {
            keys.addAll((Collection)sslConfig.certificate.keyFiles.get());
        }
        if (sslConfig.certificate.files.isPresent()) {
            certificates.addAll((Collection)sslConfig.certificate.files.get());
        }
        if (keyFile.isPresent()) {
            keys.add(keyFile.get());
        }
        if (certFile.isPresent()) {
            certificates.add(certFile.get());
        }
        Map credentials = Map.of();
        if (sslConfig.certificate.credentialsProvider.isPresent()) {
            String beanName = sslConfig.certificate.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = sslConfig.certificate.credentialsProvider.get();
            credentials = credentialsProvider.getCredentials(name);
        }
        Optional<Path> keyStoreFile = sslConfig.certificate.keyStoreFile;
        Optional<String> keyStorePassword = VertxHttpRecorder.getCredential(sslConfig.certificate.keyStorePassword, credentials, sslConfig.certificate.keyStorePasswordKey);
        Optional<String> keyStoreKeyPassword = VertxHttpRecorder.getCredential(sslConfig.certificate.keyStoreKeyPassword, credentials, sslConfig.certificate.keyStoreKeyPasswordKey);
        Optional<Path> trustStoreFile = sslConfig.certificate.trustStoreFile;
        Optional<String> trustStorePassword = VertxHttpRecorder.getCredential(sslConfig.certificate.trustStorePassword, credentials, sslConfig.certificate.trustStorePasswordKey);
        HttpServerOptions serverOptions = new HttpServerOptions();
        if (JdkSSLEngineOptions.isAlpnAvailable()) {
            serverOptions.setUseAlpn(httpConfiguration.http2);
            if (httpConfiguration.http2) {
                serverOptions.setAlpnVersions(Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1));
            }
        }
        VertxHttpRecorder.setIdleTimeout(httpConfiguration, serverOptions);
        if (!certificates.isEmpty() && !keys.isEmpty()) {
            VertxHttpRecorder.createPemKeyCertOptions(certificates, keys, serverOptions);
        } else if (keyStoreFile.isPresent()) {
            options = VertxHttpRecorder.createKeyStoreOptions(keyStoreFile.get(), keyStorePassword.orElse("password"), sslConfig.certificate.keyStoreFileType, sslConfig.certificate.keyStoreProvider, sslConfig.certificate.keyStoreKeyAlias, keyStoreKeyPassword);
            serverOptions.setKeyCertOptions((KeyCertOptions)options);
        }
        if (trustStoreFile.isPresent()) {
            if (!trustStorePassword.isPresent()) {
                throw new IllegalArgumentException("No trust store password provided");
            }
            options = VertxHttpRecorder.createKeyStoreOptions(trustStoreFile.get(), trustStorePassword.get(), sslConfig.certificate.trustStoreFileType, sslConfig.certificate.trustStoreProvider, sslConfig.certificate.trustStoreCertAlias, Optional.empty());
            serverOptions.setTrustOptions((TrustOptions)options);
        }
        for (String cipher : sslConfig.cipherSuites.orElse(Collections.emptyList())) {
            serverOptions.addEnabledCipherSuite(cipher);
        }
        for (String protocol : sslConfig.protocols) {
            if (protocol.isEmpty()) continue;
            serverOptions.addEnabledSecureTransportProtocol(protocol);
        }
        serverOptions.setSsl(true);
        serverOptions.setSni(sslConfig.sni);
        int sslPort = httpConfiguration.determineSslPort(launchMode);
        serverOptions.setPort(sslPort == 0 ? -2 : sslPort);
        serverOptions.setClientAuth(buildTimeConfig.tlsClientAuth);
        VertxHttpRecorder.applyCommonOptions(serverOptions, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        return serverOptions;
    }

    private static Optional<String> getCredential(Optional<String> password, Map<String, String> credentials, Optional<String> passwordKey) {
        if (password.isPresent()) {
            return password;
        }
        if (passwordKey.isPresent()) {
            return Optional.ofNullable(credentials.get(passwordKey.get()));
        }
        return Optional.empty();
    }

    private static void applyCommonOptions(HttpServerOptions httpServerOptions, HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, List<String> websocketSubProtocols) {
        httpServerOptions.setHost(httpConfiguration.host);
        VertxHttpRecorder.setIdleTimeout(httpConfiguration, httpServerOptions);
        httpServerOptions.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        httpServerOptions.setMaxChunkSize(httpConfiguration.limits.maxChunkSize.asBigInteger().intValueExact());
        httpServerOptions.setMaxFormAttributeSize(httpConfiguration.limits.maxFormAttributeSize.asBigInteger().intValueExact());
        httpServerOptions.setWebSocketSubProtocols(websocketSubProtocols);
        httpServerOptions.setReusePort(httpConfiguration.soReusePort);
        httpServerOptions.setTcpQuickAck(httpConfiguration.tcpQuickAck);
        httpServerOptions.setTcpCork(httpConfiguration.tcpCork);
        httpServerOptions.setAcceptBacklog(httpConfiguration.acceptBacklog);
        httpServerOptions.setTcpFastOpen(httpConfiguration.tcpFastOpen);
        httpServerOptions.setCompressionSupported(buildTimeConfig.enableCompression);
        if (buildTimeConfig.compressionLevel.isPresent()) {
            httpServerOptions.setCompressionLevel(buildTimeConfig.compressionLevel.getAsInt());
        }
        httpServerOptions.setDecompressionSupported(buildTimeConfig.enableDecompression);
        httpServerOptions.setMaxInitialLineLength(httpConfiguration.limits.maxInitialLineLength);
        httpServerOptions.setHandle100ContinueAutomatically(httpConfiguration.handle100ContinueAutomatically);
    }

    private static KeyStoreOptions createKeyStoreOptions(Path path, String password, Optional<String> fileType, Optional<String> provider, Optional<String> alias, Optional<String> aliasPassword) throws IOException {
        String type = fileType.isPresent() ? fileType.get().toLowerCase() : VertxHttpRecorder.findKeystoreFileType(path);
        byte[] data = VertxHttpRecorder.getFileContent(path);
        KeyStoreOptions options = new KeyStoreOptions().setPassword(password).setValue(Buffer.buffer((byte[])data)).setType(type.toUpperCase()).setProvider((String)provider.orElse(null)).setAlias((String)alias.orElse(null)).setAliasPassword((String)aliasPassword.orElse(null));
        return options;
    }

    private static byte[] getFileContent(Path path) throws IOException {
        byte[] data;
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)path));
        if (resource != null) {
            try (InputStream is = resource;){
                data = VertxHttpRecorder.doRead(is);
            }
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            data = VertxHttpRecorder.doRead(is);
        }
        return data;
    }

    private static void createPemKeyCertOptions(List<Path> certFile, List<Path> keyFile, HttpServerOptions serverOptions) throws IOException {
        if (certFile.size() != keyFile.size()) {
            throw new ConfigurationException("Invalid certificate configuration - `files` and `keyFiles` must have the same number of elements");
        }
        ArrayList<Buffer> certificates = new ArrayList<Buffer>();
        ArrayList<Buffer> keys = new ArrayList<Buffer>();
        for (Path p : certFile) {
            byte[] cert = VertxHttpRecorder.getFileContent(p);
            certificates.add(Buffer.buffer((byte[])cert));
        }
        for (Path p : keyFile) {
            byte[] key = VertxHttpRecorder.getFileContent(p);
            keys.add(Buffer.buffer((byte[])key));
        }
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions().setCertValues(certificates).setKeyValues(keys);
        serverOptions.setPemKeyCertOptions(pemKeyCertOptions);
    }

    private static String findKeystoreFileType(Path storePath) {
        String pathName = storePath.toString();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "pkcs12";
        }
        return "jks";
    }

    private static byte[] doRead(InputStream is) throws IOException {
        return is.readAllBytes();
    }

    private static HttpServerOptions createHttpServerOptions(HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, LaunchMode launchMode, List<String> websocketSubProtocols) {
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        int port = httpConfiguration.determinePort(launchMode);
        options.setPort(port == 0 ? -1 : port);
        VertxHttpRecorder.applyCommonOptions(options, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        return options;
    }

    private static HttpServerOptions createDomainSocketOptions(HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, List<String> websocketSubProtocols) {
        if (!httpConfiguration.domainSocketEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        VertxHttpRecorder.applyCommonOptions(options, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        options.setHost(httpConfiguration.domainSocket);
        File file = new File(httpConfiguration.domainSocket);
        if (!file.getParentFile().canWrite()) {
            LOGGER.warnf("Unable to write in the domain socket directory (`%s`). Binding to the socket is likely going to fail.", (Object)httpConfiguration.domainSocket);
        }
        return options;
    }

    private static void setIdleTimeout(HttpConfiguration httpConfiguration, HttpServerOptions options) {
        int idleTimeout = (int)httpConfiguration.idleTimeout.toMillis();
        options.setIdleTimeout(idleTimeout);
        options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
    }

    public void addRoute(RuntimeValue<Router> router, Function<Router, Route> route, Handler<RoutingContext> handler, HandlerType blocking) {
        Route vr = route.apply((Router)router.getValue());
        if (blocking == HandlerType.BLOCKING) {
            vr.blockingHandler(handler, false);
        } else if (blocking == HandlerType.FAILURE) {
            vr.failureHandler(handler);
        } else {
            vr.handler(handler);
        }
    }

    public void setNonApplicationRedirectHandler(final String nonApplicationPath, final String rootPath) {
        nonApplicationRedirectHandler = new Handler<RoutingContext>(){

            public void handle(RoutingContext context) {
                String absoluteURI = context.request().path();
                String target = absoluteURI.substring(rootPath.length());
                String redirectTo = nonApplicationPath + target;
                String query = context.request().query();
                if (query != null && !query.isEmpty()) {
                    redirectTo = redirectTo + "?" + query;
                }
                context.response().setStatusCode(HttpResponseStatus.MOVED_PERMANENTLY.code()).putHeader((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)redirectTo).end();
            }
        };
    }

    public Handler<RoutingContext> getNonApplicationRedirectHandler() {
        return nonApplicationRedirectHandler;
    }

    public GracefulShutdownFilter createGracefulShutdownHandler() {
        return new GracefulShutdownFilter();
    }

    private static void initializeVirtual(Vertx vertxRuntime) {
        if (virtualBootstrap != null) {
            return;
        }
        final VertxInternal vertx = (VertxInternal)vertxRuntime;
        virtualBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)virtualBootstrap.group(vertx.getEventLoopGroup()).channel(VirtualServerChannel.class)).handler((ChannelHandler)new ChannelInitializer<VirtualServerChannel>(){

            public void initChannel(VirtualServerChannel ch) throws Exception {
            }
        })).childHandler((ChannelHandler)new ChannelInitializer<VirtualChannel>(){

            public void initChannel(VirtualChannel ch) throws Exception {
                EventLoopContext context = vertx.createEventLoopContext();
                VertxHandler handler = VertxHandler.create(chctx -> {
                    Http1xServerConnection conn = new Http1xServerConnection(() -> {
                        ContextInternal internal = (ContextInternal)VertxContext.getOrCreateDuplicatedContext((io.vertx.core.Context)context);
                        VertxContextSafetyToggle.setContextSafe((io.vertx.core.Context)internal, (boolean)true);
                        return internal;
                    }, null, new HttpServerOptions(), chctx, (ContextInternal)context, "localhost", null);
                    conn.handler(ACTUAL_ROOT);
                    return conn;
                });
                ch.pipeline().addLast("handler", (ChannelHandler)handler);
            }
        });
        try {
            virtualBootstrapChannel = virtualBootstrap.bind((java.net.SocketAddress)VIRTUAL_HTTP).sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("failed to bind virtual http");
        }
    }

    public static Handler<HttpServerRequest> getRootHandler() {
        return ACTUAL_ROOT;
    }

    public static Object getCurrentApplicationState() {
        return rootHandler;
    }

    public Handler<RoutingContext> createBodyHandler() {
        final BodyHandler bodyHandler = BodyHandler.create();
        Optional<MemorySize> maxBodySize = ((HttpConfiguration)this.httpConfiguration.getValue()).limits.maxBodySize;
        if (maxBodySize.isPresent()) {
            bodyHandler.setBodyLimit(maxBodySize.get().asLongValue());
        }
        BodyConfig bodyConfig = ((HttpConfiguration)this.httpConfiguration.getValue()).body;
        bodyHandler.setHandleFileUploads(bodyConfig.handleFileUploads);
        bodyHandler.setUploadsDirectory(bodyConfig.uploadsDirectory);
        bodyHandler.setDeleteUploadedFilesOnEnd(bodyConfig.deleteUploadedFilesOnEnd);
        bodyHandler.setMergeFormAttributes(bodyConfig.mergeFormAttributes);
        bodyHandler.setPreallocateBodyBuffer(bodyConfig.preallocateBodyBuffer);
        return new Handler<RoutingContext>(){

            public void handle(final RoutingContext event) {
                if (!io.vertx.core.Context.isOnEventLoopThread()) {
                    ((ConnectionBase)event.request().connection()).channel().eventLoop().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!event.request().isEnded()) {
                                    event.request().resume();
                                    if (CAN_HAVE_BODY.contains(event.request().method())) {
                                        bodyHandler.handle((Object)event);
                                    } else {
                                        event.next();
                                    }
                                } else {
                                    event.next();
                                }
                            }
                            catch (Throwable t) {
                                event.fail(t);
                            }
                        }
                    });
                } else {
                    if (!event.request().isEnded()) {
                        event.request().resume();
                    }
                    if (CAN_HAVE_BODY.contains(event.request().method())) {
                        bodyHandler.handle((Object)event);
                    } else {
                        event.next();
                    }
                }
            }
        };
    }

    private BiConsumer<Cookie, HttpServerRequest> processSameSiteConfig(Map<String, SameSiteCookieConfig> httpConfiguration) {
        final ArrayList<24> functions = new ArrayList<24>();
        BiFunction<Cookie, HttpServerRequest, Boolean> last = null;
        for (final Map.Entry<String, SameSiteCookieConfig> entry : new TreeMap<String, SameSiteCookieConfig>(httpConfiguration).entrySet()) {
            final Pattern p = Pattern.compile(entry.getKey(), entry.getValue().caseSensitive ? 0 : 2);
            BiFunction<Cookie, HttpServerRequest, Boolean> biFunction = new BiFunction<Cookie, HttpServerRequest, Boolean>(){

                @Override
                public Boolean apply(Cookie cookie, HttpServerRequest request) {
                    if (p.matcher(cookie.getName()).matches()) {
                        if (((SameSiteCookieConfig)entry.getValue()).value == CookieSameSite.NONE) {
                            String userAgent;
                            if (((SameSiteCookieConfig)entry.getValue()).enableClientChecker && (userAgent = request.getHeader(HttpHeaders.USER_AGENT)) != null && SameSiteNoneIncompatibleClientChecker.isSameSiteNoneIncompatible(userAgent)) {
                                return false;
                            }
                            if (((SameSiteCookieConfig)entry.getValue()).addSecureForNone) {
                                cookie.setSecure(true);
                            }
                        }
                        cookie.setSameSite(((SameSiteCookieConfig)entry.getValue()).value);
                        return true;
                    }
                    return false;
                }
            };
            if (entry.getKey().equals(".*")) {
                last = biFunction;
                continue;
            }
            functions.add(biFunction);
        }
        if (last != null) {
            functions.add(last);
        }
        return new BiConsumer<Cookie, HttpServerRequest>(){

            @Override
            public void accept(Cookie cookie, HttpServerRequest request) {
                for (BiFunction i : functions) {
                    if (!((Boolean)i.apply(cookie, request)).booleanValue()) continue;
                    return;
                }
            }
        };
    }

    static {
        actualHttpPort = -1;
        actualHttpsPort = -1;
        ACTUAL_ROOT = new Handler<HttpServerRequest>(){
            private static final String DISABLE_URI_VALIDATION_PROP_NAME = "vertx.disableURIValidation";
            private final boolean DISABLE_URI_VALIDATION = Boolean.getBoolean("vertx.disableURIValidation");

            public void handle(HttpServerRequest httpServerRequest) {
                if (!this.uriValid(httpServerRequest)) {
                    httpServerRequest.response().setStatusCode(400).end();
                    return;
                }
                httpServerRequest.pause();
                Handler<HttpServerRequest> rh = rootHandler;
                if (rh != null) {
                    rh.handle((Object)httpServerRequest);
                } else {
                    httpServerRequest.resume();
                    httpServerRequest.response().setStatusCode(503).end();
                }
            }

            private boolean uriValid(HttpServerRequest httpServerRequest) {
                if (this.DISABLE_URI_VALIDATION) {
                    return true;
                }
                try {
                    new URI(httpServerRequest.uri());
                    return true;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
        };
        VIRTUAL_HTTP = new VirtualAddress("netty-virtual-http");
        CAN_HAVE_BODY = Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE);
    }

    private static class WebDeploymentVerticle
    extends AbstractVerticle
    implements Resource {
        private HttpServer httpServer;
        private HttpServer httpsServer;
        private HttpServer domainSocketServer;
        private final HttpServerOptions httpOptions;
        private final HttpServerOptions httpsOptions;
        private final HttpServerOptions domainSocketOptions;
        private final LaunchMode launchMode;
        private volatile boolean clearHttpProperty = false;
        private volatile boolean clearHttpsProperty = false;
        private volatile Map<String, String> portPropertiesToRestore;
        private final HttpConfiguration.InsecureRequests insecureRequests;
        private final HttpConfiguration quarkusConfig;
        private final AtomicInteger connectionCount;

        public WebDeploymentVerticle(HttpServerOptions httpOptions, HttpServerOptions httpsOptions, HttpServerOptions domainSocketOptions, LaunchMode launchMode, HttpConfiguration.InsecureRequests insecureRequests, HttpConfiguration quarkusConfig, AtomicInteger connectionCount) {
            this.httpOptions = httpOptions;
            this.httpsOptions = httpsOptions;
            this.launchMode = launchMode;
            this.domainSocketOptions = domainSocketOptions;
            this.insecureRequests = insecureRequests;
            this.quarkusConfig = quarkusConfig;
            this.connectionCount = connectionCount;
            Core.getGlobalContext().register((Resource)this);
        }

        public void start(Promise<Void> startFuture) {
            boolean httpServerEnabled;
            AtomicInteger remainingCount = new AtomicInteger(0);
            boolean bl = httpServerEnabled = this.httpOptions != null && this.insecureRequests != HttpConfiguration.InsecureRequests.DISABLED;
            if (httpServerEnabled) {
                remainingCount.incrementAndGet();
            }
            if (this.httpsOptions != null) {
                remainingCount.incrementAndGet();
            }
            if (this.domainSocketOptions != null) {
                remainingCount.incrementAndGet();
            }
            if (remainingCount.get() == 0) {
                startFuture.fail((Throwable)new IllegalArgumentException("Must configure at least one of http, https or unix domain socket"));
            }
            if (httpServerEnabled) {
                this.httpServer = this.vertx.createHttpServer(this.httpOptions);
                if (this.insecureRequests == HttpConfiguration.InsecureRequests.ENABLED) {
                    this.httpServer.requestHandler(ACTUAL_ROOT);
                } else {
                    this.httpServer.requestHandler((Handler)new Handler<HttpServerRequest>(){

                        public void handle(HttpServerRequest req) {
                            try {
                                String host = req.getHeader((CharSequence)HttpHeaderNames.HOST);
                                if (host == null) {
                                    req.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
                                } else {
                                    int includedPort = host.indexOf(":");
                                    if (includedPort != -1) {
                                        host = host.substring(0, includedPort);
                                    }
                                    req.response().setStatusCode(301).putHeader("Location", "https://" + host + ":" + httpsOptions.getPort() + req.uri()).end();
                                }
                            }
                            catch (Exception e) {
                                req.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
                            }
                        }
                    });
                }
                this.setupTcpHttpServer(this.httpServer, this.httpOptions, false, startFuture, remainingCount, this.connectionCount);
            }
            if (this.domainSocketOptions != null) {
                this.domainSocketServer = this.vertx.createHttpServer(this.domainSocketOptions);
                this.domainSocketServer.requestHandler(ACTUAL_ROOT);
                this.setupUnixDomainSocketHttpServer(this.domainSocketServer, this.domainSocketOptions, startFuture, remainingCount);
            }
            if (this.httpsOptions != null) {
                this.httpsServer = this.vertx.createHttpServer(this.httpsOptions);
                this.httpsServer.requestHandler(ACTUAL_ROOT);
                this.setupTcpHttpServer(this.httpsServer, this.httpsOptions, true, startFuture, remainingCount, this.connectionCount);
            }
        }

        private void setupUnixDomainSocketHttpServer(HttpServer httpServer, HttpServerOptions options, Promise<Void> startFuture, AtomicInteger remainingCount) {
            httpServer.listen(SocketAddress.domainSocketAddress((String)options.getHost()), event -> {
                if (event.succeeded()) {
                    if (remainingCount.decrementAndGet() == 0) {
                        startFuture.complete(null);
                    }
                } else if (event.cause() != null && event.cause().getMessage() != null && event.cause().getMessage().contains("Permission denied")) {
                    startFuture.fail((Throwable)new IllegalStateException(String.format("Unable to bind to Unix domain socket (%s) as the application does not have the permission to write in the directory.", this.domainSocketOptions.getHost())));
                } else if (event.cause() instanceof IllegalArgumentException) {
                    startFuture.fail((Throwable)new IllegalArgumentException(String.format("Unable to bind to Unix domain socket. Consider adding the 'io.netty:%s' dependency. See the Quarkus Vert.x reference guide for more details.", Utils.isLinux() ? "netty-transport-native-epoll" : "netty-transport-native-kqueue")));
                } else {
                    startFuture.fail(event.cause());
                }
            });
        }

        private void setupTcpHttpServer(HttpServer httpServer, final HttpServerOptions options, final boolean https, final Promise<Void> startFuture, final AtomicInteger remainingCount, final AtomicInteger currentConnectionCount) {
            if (this.quarkusConfig.limits.maxConnections.isPresent() && this.quarkusConfig.limits.maxConnections.getAsInt() > 0) {
                final int maxConnections = this.quarkusConfig.limits.maxConnections.getAsInt();
                httpServer.connectionHandler((Handler)new Handler<HttpConnection>(){

                    public void handle(HttpConnection event) {
                        int current;
                        do {
                            if ((current = currentConnectionCount.get()) != maxConnections) continue;
                            LOGGER.debug((Object)"Rejecting connection as there are too many active connections");
                            event.close();
                            return;
                        } while (!currentConnectionCount.compareAndSet(current, current + 1));
                        event.closeHandler((Handler)new Handler<Void>(){

                            public void handle(Void event) {
                                LOGGER.debug((Object)"Connection closed");
                                connectionCount.decrementAndGet();
                            }
                        });
                    }
                });
            }
            httpServer.listen(options.getPort(), options.getHost(), (Handler)new Handler<AsyncResult<HttpServer>>(){

                public void handle(AsyncResult<HttpServer> event) {
                    if (event.cause() != null) {
                        startFuture.fail(event.cause());
                    } else {
                        int actualPort = ((HttpServer)event.result()).actualPort();
                        if (https) {
                            actualHttpsPort = actualPort;
                        } else {
                            actualHttpPort = actualPort;
                        }
                        if (remainingCount.decrementAndGet() == 0) {
                            if (actualPort != options.getPort()) {
                                String testPropName;
                                String prevTestPropPrevValue;
                                String schema;
                                if (https) {
                                    clearHttpsProperty = true;
                                    schema = "https";
                                } else {
                                    clearHttpProperty = true;
                                    actualHttpPort = actualPort;
                                    schema = "http";
                                }
                                portPropertiesToRestore = new HashMap<String, String>();
                                String portPropertyValue = String.valueOf(actualPort);
                                Object portPropertyName = "quarkus." + schema + ".port";
                                String prevPortPropertyValue = System.setProperty((String)portPropertyName, portPropertyValue);
                                if (!Objects.equals(prevPortPropertyValue, portPropertyValue)) {
                                    portPropertiesToRestore.put((String)portPropertyName, prevPortPropertyValue);
                                }
                                if (launchMode == LaunchMode.TEST && !Objects.equals(prevTestPropPrevValue = System.setProperty(testPropName = "quarkus." + schema + ".test-port", portPropertyValue), portPropertyValue)) {
                                    portPropertiesToRestore.put(testPropName, prevTestPropPrevValue);
                                }
                                if (launchMode.isDevOrTest() && !Objects.equals(prevPortPropertyValue = System.setProperty((String)(portPropertyName = this.propertyWithProfilePrefix((String)portPropertyName)), portPropertyValue), portPropertyValue)) {
                                    portPropertiesToRestore.put((String)portPropertyName, prevPortPropertyValue);
                                }
                            }
                            startFuture.complete(null);
                        }
                    }
                }
            });
        }

        public void stop(Promise<Void> stopFuture) {
            AtomicInteger remainingCount = new AtomicInteger(0);
            if (this.httpServer != null) {
                remainingCount.incrementAndGet();
            }
            if (this.httpsServer != null) {
                remainingCount.incrementAndGet();
            }
            if (this.domainSocketServer != null) {
                remainingCount.incrementAndGet();
            }
            Handler handleClose = event -> {
                if (remainingCount.decrementAndGet() == 0) {
                    String portPropertyName;
                    if (this.clearHttpProperty) {
                        portPropertyName = this.launchMode == LaunchMode.TEST ? "quarkus.http.test-port" : "quarkus.http.port";
                        System.clearProperty(portPropertyName);
                        if (this.launchMode.isDevOrTest()) {
                            System.clearProperty(this.propertyWithProfilePrefix(portPropertyName));
                        }
                    }
                    if (this.clearHttpsProperty) {
                        portPropertyName = this.launchMode == LaunchMode.TEST ? "quarkus.https.test-port" : "quarkus.https.port";
                        System.clearProperty(portPropertyName);
                        if (this.launchMode.isDevOrTest()) {
                            System.clearProperty(this.propertyWithProfilePrefix(portPropertyName));
                        }
                    }
                    if (this.portPropertiesToRestore != null) {
                        for (Map.Entry<String, String> entry : this.portPropertiesToRestore.entrySet()) {
                            if (entry.getValue() == null) {
                                System.clearProperty(entry.getKey());
                                continue;
                            }
                            System.setProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    stopFuture.complete();
                }
            };
            if (this.httpServer != null) {
                this.httpServer.close(handleClose);
            }
            if (this.httpsServer != null) {
                this.httpsServer.close(handleClose);
            }
            if (this.domainSocketServer != null) {
                this.domainSocketServer.close(handleClose);
            }
        }

        private String propertyWithProfilePrefix(String portPropertyName) {
            return "%" + this.launchMode.getDefaultProfile() + "." + portPropertyName;
        }

        public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
            Promise p = Promise.promise();
            this.stop((Promise<Void>)p);
            CountDownLatch latch = new CountDownLatch(1);
            p.future().onComplete(event -> latch.countDown());
            latch.await();
        }

        public void afterRestore(Context<? extends Resource> context) throws Exception {
            Promise p = Promise.promise();
            this.start((Promise<Void>)p);
            CountDownLatch latch = new CountDownLatch(1);
            p.future().onComplete(event -> latch.countDown());
            latch.await();
        }
    }
}

