/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.comms;

import io.quarkus.arc.Arc;
import io.quarkus.devui.runtime.comms.ReflectionInfo;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcKeys;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcReader;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcWriter;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

public class JsonRpcRouter {
    private final Map<Integer, Cancellable> subscriptions = new ConcurrentHashMap<Integer, Cancellable>();
    private final Map<String, ReflectionInfo> jsonRpcToJava = new HashMap<String, ReflectionInfo>();
    private static final List<ServerWebSocket> SESSIONS = Collections.synchronizedList(new ArrayList());
    @Inject
    Logger logger;
    private static final String DOT = ".";
    private static final String UNSUBSCRIBE = "unsubscribe";

    public void populateJsonRPCMethods(Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap) {
        for (Map.Entry<String, Map<JsonRpcMethodName, JsonRpcMethod>> extension : extensionMethodsMap.entrySet()) {
            String extensionName = extension.getKey();
            Map<JsonRpcMethodName, JsonRpcMethod> jsonRpcMethods = extension.getValue();
            for (Map.Entry<JsonRpcMethodName, JsonRpcMethod> method : jsonRpcMethods.entrySet()) {
                JsonRpcMethodName methodName = method.getKey();
                JsonRpcMethod jsonRpcMethod = method.getValue();
                Object providerInstance = Arc.container().select(jsonRpcMethod.getClazz(), new Annotation[0]).get();
                try {
                    Method javaMethod;
                    Map<String, Class> params = null;
                    if (jsonRpcMethod.hasParams()) {
                        params = jsonRpcMethod.getParams();
                        javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getMethodName(), params.values().toArray(new Class[0]));
                    } else {
                        javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getMethodName(), new Class[0]);
                    }
                    ReflectionInfo reflectionInfo = new ReflectionInfo(jsonRpcMethod.getClazz(), providerInstance, javaMethod, params, jsonRpcMethod.getExplicitlyBlocking(), jsonRpcMethod.getExplicitlyNonBlocking());
                    String jsonRpcMethodName = extensionName + DOT + methodName;
                    this.jsonRpcToJava.put(jsonRpcMethodName, reflectionInfo);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private Uni<?> invoke(ReflectionInfo info, Object target, Object[] args) {
        if (info.isReturningUni()) {
            try {
                Uni uni = (Uni)info.method.invoke(target, args);
                if (info.isExplicitlyBlocking()) {
                    return uni.runSubscriptionOn(Infrastructure.getDefaultExecutor());
                }
                return uni;
            }
            catch (Exception e) {
                return Uni.createFrom().failure((Throwable)e);
            }
        }
        Uni uni = Uni.createFrom().item(Unchecked.supplier(() -> info.method.invoke(target, args)));
        if (!info.isExplicitlyNonBlocking()) {
            return uni.runSubscriptionOn(Infrastructure.getDefaultExecutor());
        }
        return uni;
    }

    public void addSocket(ServerWebSocket socket) {
        SESSIONS.add(socket);
        socket.textMessageHandler(e -> {
            JsonRpcReader jsonRpcRequest = JsonRpcReader.read(e);
            this.route(jsonRpcRequest, socket);
        }).closeHandler(e -> this.purge());
        this.purge();
    }

    void onStart(@Observes StartupEvent ev) {
        this.purge();
        for (ServerWebSocket s : new ArrayList<ServerWebSocket>(SESSIONS)) {
            if (s.isClosed()) continue;
            s.writeTextMessage(JsonRpcWriter.writeResponse(-1, LocalDateTime.now().toString(), JsonRpcKeys.MessageType.HotReload).encode());
        }
    }

    private void purge() {
        for (ServerWebSocket s : new ArrayList<ServerWebSocket>(SESSIONS)) {
            if (!s.isClosed()) continue;
            SESSIONS.remove(s);
        }
    }

    private void route(JsonRpcReader jsonRpcRequest, ServerWebSocket s) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        if (jsonRpcMethodName.equalsIgnoreCase(UNSUBSCRIBE)) {
            JsonObject jsonRpcResponse = JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), null, JsonRpcKeys.MessageType.Void);
            if (this.subscriptions.containsKey(jsonRpcRequest.getId())) {
                Cancellable cancellable = this.subscriptions.remove(jsonRpcRequest.getId());
                cancellable.cancel();
            }
            s.writeTextMessage(jsonRpcResponse.encode());
        } else if (this.jsonRpcToJava.containsKey(jsonRpcMethodName)) {
            ReflectionInfo reflectionInfo = this.jsonRpcToJava.get(jsonRpcMethodName);
            Object target = Arc.container().select(reflectionInfo.bean, new Annotation[0]).get();
            if (reflectionInfo.isReturningMulti()) {
                Multi multi;
                try {
                    if (jsonRpcRequest.hasParams()) {
                        Object[] args = this.getArgsAsObjects(reflectionInfo.params, jsonRpcRequest);
                        multi = (Multi)reflectionInfo.method.invoke(target, args);
                    } else {
                        multi = (Multi)reflectionInfo.method.invoke(target, new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.logger.errorf((Throwable)e, "Unable to invoke method %s using JSON-RPC, request was: %s", (Object)jsonRpcMethodName, (Object)jsonRpcRequest);
                    s.writeTextMessage(JsonRpcWriter.writeErrorResponse(jsonRpcRequest.getId(), jsonRpcMethodName, e).encode());
                    return;
                }
                Cancellable cancellable = multi.subscribe().with(item -> {
                    JsonObject jsonResponse = JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), item, JsonRpcKeys.MessageType.SubscriptionMessage);
                    s.writeTextMessage(jsonResponse.encodePrettily());
                }, failure -> {
                    s.writeTextMessage(JsonRpcWriter.writeErrorResponse(jsonRpcRequest.getId(), jsonRpcMethodName, failure).encode());
                    this.subscriptions.remove(jsonRpcRequest.getId());
                }, () -> this.subscriptions.remove(jsonRpcRequest.getId()));
                this.subscriptions.put(jsonRpcRequest.getId(), cancellable);
                s.writeTextMessage(JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), null, JsonRpcKeys.MessageType.Void).encode());
            } else {
                Uni<?> uni;
                try {
                    if (jsonRpcRequest.hasParams()) {
                        Object[] args = this.getArgsAsObjects(reflectionInfo.params, jsonRpcRequest);
                        uni = this.invoke(reflectionInfo, target, args);
                    } else {
                        uni = this.invoke(reflectionInfo, target, new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.logger.errorf((Throwable)e, "Unable to invoke method %s using JSON-RPC, request was: %s", (Object)jsonRpcMethodName, (Object)jsonRpcRequest);
                    s.writeTextMessage(JsonRpcWriter.writeErrorResponse(jsonRpcRequest.getId(), jsonRpcMethodName, e).encode());
                    return;
                }
                uni.subscribe().with(item -> s.writeTextMessage(JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), item, JsonRpcKeys.MessageType.Response).encode()), failure -> s.writeTextMessage(JsonRpcWriter.writeErrorResponse(jsonRpcRequest.getId(), jsonRpcMethodName, failure).encode()));
            }
        } else {
            s.writeTextMessage(JsonRpcWriter.writeMethodNotFoundResponse(jsonRpcRequest.getId(), jsonRpcMethodName).encode());
        }
    }

    private Object[] getArgsAsObjects(Map<String, Class> params, JsonRpcReader jsonRpcRequest) {
        ArrayList objects = new ArrayList();
        for (Map.Entry<String, Class> expectedParams : params.entrySet()) {
            String paramName = expectedParams.getKey();
            Class paramType = expectedParams.getValue();
            Object param = jsonRpcRequest.getParam(paramName);
            Object casted = paramType.cast(param);
            objects.add(casted);
        }
        return objects.toArray(Object[]::new);
    }
}

