/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import org.h2.value.Value;
import org.h2.value.ValueFloat;

final class FloatCodec
extends AbstractCodec<Float> {
    FloatCodec() {
        super(Float.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 8;
    }

    @Override
    Float doDecode(Value value, Class<? extends Float> type) {
        return Float.valueOf(value.getFloat());
    }

    @Override
    Value doEncode(Float value) {
        return ValueFloat.get((float)Assert.requireNonNull(value, "value must not be null").floatValue());
    }
}

