/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.LocalDateTimeCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import reactor.util.annotation.Nullable;

final class DateCodec
extends AbstractCodec<Date> {
    private final LocalDateTimeCodec delegate;

    DateCodec(ByteBufAllocator byteBufAllocator) {
        super(Date.class);
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = new LocalDateTimeCodec(byteBufAllocator);
    }

    @Override
    public Parameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return this.delegate.getDataTypes();
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    Date doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends Date> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Object intermediary = this.delegate.doDecode(buffer, dataType, format, LocalDateTime.class);
        return Date.from(((LocalDateTime)intermediary).atZone(ZoneId.systemDefault()).toInstant());
    }

    @Override
    Parameter doEncode(Date value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(value.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
    }
}

