/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import ratpack.handling.ByContentHandler;
import ratpack.handling.Context;
import ratpack.http.internal.MimeParse;

public class DefaultByContentHandler
implements ByContentHandler {
    private final Map<String, Runnable> map = new LinkedHashMap<String, Runnable>(3);
    private String first;

    @Override
    public ByContentHandler type(String mimeType, Runnable runnable) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        String trimmed = mimeType.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("mimeType cannot be a blank string");
        }
        if (this.first == null) {
            this.first = trimmed;
        }
        this.map.put(trimmed, runnable);
        return this;
    }

    @Override
    public ByContentHandler plainText(Runnable runnable) {
        return this.type("text/plain", runnable);
    }

    @Override
    public ByContentHandler html(Runnable runnable) {
        return this.type("text/html", runnable);
    }

    @Override
    public ByContentHandler json(Runnable runnable) {
        return this.type("application/json", runnable);
    }

    @Override
    public ByContentHandler xml(Runnable runnable) {
        return this.type("application/xml", runnable);
    }

    @Override
    public void handle(Context context) {
        if (this.first == null) {
            context.clientError(406);
            return;
        }
        ArrayList<String> types = new ArrayList<String>(this.map.keySet());
        Collections.reverse(types);
        String winner = this.first;
        String acceptHeader = context.getRequest().getHeaders().get("Accept");
        if (acceptHeader != null && !acceptHeader.isEmpty()) {
            winner = MimeParse.bestMatch(types, acceptHeader);
        }
        if (winner == null || winner.isEmpty()) {
            context.clientError(406);
        } else {
            context.getResponse().contentType(winner);
            Runnable runnable = this.map.get(winner);
            runnable.run();
        }
    }
}

