/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.util.ExceptionUtils;

public class CachingRegistry
implements Registry {
    private final Registry delegate;
    private final LoadingCache<Class<?>, ? extends Optional<?>> cache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<?>>(){

        public Optional<?> load(Class<?> key) throws Exception {
            Object nullableReference = CachingRegistry.this.delegate.maybeGet(key);
            return Optional.fromNullable(nullableReference);
        }
    });
    private final LoadingCache<Class<?>, List<?>> allCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, List<?>>(){

        public List<?> load(Class<?> key) throws Exception {
            return CachingRegistry.this.delegate.getAll(key);
        }
    });

    public CachingRegistry(Registry delegate) {
        this.delegate = delegate;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        O o = this.maybeGet(type);
        if (o == null) {
            throw new NotInRegistryException(type);
        }
        return o;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        try {
            Object o = ((Optional)this.cache.get(type)).orNull();
            return (O)o;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        try {
            List objects = (List)this.allCache.get(type);
            return objects;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }
}

