/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;

public class MultiEntryRegistry
implements Registry {
    private final ImmutableList<RegistryEntry<?>> entries;

    public MultiEntryRegistry(ImmutableList<RegistryEntry<?>> entries) {
        this.entries = entries;
    }

    public String toString() {
        return "Registry{" + this.entries + '}';
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        for (RegistryEntry entry : this.entries) {
            if (!type.isAssignableFrom(entry.getType())) continue;
            return type.cast(entry.get());
        }
        return null;
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RegistryEntry entry : this.entries) {
            if (!type.isAssignableFrom(entry.getType())) continue;
            builder.add(type.cast(entry.get()));
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiEntryRegistry that = (MultiEntryRegistry)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

