/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.IoUtils;
import ratpack.util.internal.ReleasingAction;

public class RatpackVersion {
    private RatpackVersion() {
    }

    public static String getVersion() {
        ClassLoader classLoader = RatpackVersion.class.getClassLoader();
        InputStream resourceAsStream = classLoader.getResourceAsStream("ratpack/ratpack-version.txt");
        ReadAction action = new ReadAction(resourceAsStream);
        action.execute(Unpooled.buffer());
        return action.content;
    }

    private static class ReadAction
    extends ReleasingAction<ByteBuf> {
        private final InputStream resourceAsStream;
        String content;

        public ReadAction(InputStream resourceAsStream) {
            this.resourceAsStream = resourceAsStream;
        }

        @Override
        protected void doExecute(ByteBuf buffer) {
            try {
                IoUtils.writeTo(this.resourceAsStream, buffer);
                this.content = buffer.toString(CharsetUtil.UTF_8);
            }
            catch (IOException e) {
                throw ExceptionUtils.uncheck(e);
            }
        }
    }
}

