/*
 * Decompiled with CFR 0.152.
 */
package ratpack.websocket.internal;

import ratpack.func.Action;
import ratpack.func.Transformer;
import ratpack.handling.Context;
import ratpack.launch.LaunchConfig;
import ratpack.websocket.WebSocket;
import ratpack.websocket.WebSocketBuilder;
import ratpack.websocket.WebSocketClose;
import ratpack.websocket.WebSocketMessage;
import ratpack.websocket.internal.BuiltWebSocketHandler;
import ratpack.websocket.internal.WebSocketConnector;

public class DefaultWebSocketBuilder<T>
implements WebSocketBuilder<T> {
    private final Context context;
    private final Transformer<WebSocket, T> open;
    private String path = "/";
    private int maxLength;
    private Action<WebSocketMessage<T>> messageHandler = new Action<WebSocketMessage<T>>(){

        @Override
        public void execute(WebSocketMessage<T> thing) throws Exception {
        }
    };
    private Action<WebSocketClose<T>> closeHandler = new Action<WebSocketClose<T>>(){

        @Override
        public void execute(WebSocketClose<T> thing) throws Exception {
        }
    };

    public DefaultWebSocketBuilder(Context context, Transformer<WebSocket, T> open) {
        this.context = context;
        this.open = open;
        this.maxLength = context.get(LaunchConfig.class).getMaxContentLength();
    }

    @Override
    public WebSocketBuilder<T> path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public WebSocketBuilder<T> onClose(Action<WebSocketClose<T>> action) {
        this.closeHandler = action;
        return this;
    }

    @Override
    public WebSocketBuilder<T> onMessage(Action<WebSocketMessage<T>> action) {
        this.messageHandler = action;
        return this;
    }

    @Override
    public WebSocketBuilder<T> maxLength(int maxLength) {
        return null;
    }

    @Override
    public void connect() {
        WebSocketConnector.connect(this.context, this.path, this.maxLength, new BuiltWebSocketHandler<T>(this.open, this.closeHandler, this.messageHandler));
    }
}

