/*
 * Decompiled with CFR 0.152.
 */
package ratpack.background.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import ratpack.func.Action;
import ratpack.handling.Background;
import ratpack.handling.Context;
import ratpack.handling.ProcessingInterceptor;
import ratpack.handling.internal.ContextStorage;
import ratpack.handling.internal.FinishedOnThreadCallbackManager;
import ratpack.handling.internal.InterceptedOperation;
import ratpack.promise.SuccessOrErrorPromise;
import ratpack.promise.SuccessPromise;
import ratpack.util.ExceptionUtils;

public class DefaultBackground
implements Background {
    private final ExecutorService foregroundExecutor;
    private final ListeningExecutorService backgroundExecutor;
    private final ContextStorage contextStorage;

    public DefaultBackground(ExecutorService foregroundExecutor, ListeningExecutorService backgroundExecutor, ContextStorage contextStorage) {
        this.foregroundExecutor = foregroundExecutor;
        this.backgroundExecutor = backgroundExecutor;
        this.contextStorage = contextStorage;
    }

    @Override
    public <T> SuccessOrErrorPromise<T> exec(Callable<T> operation) {
        return new DefaultSuccessOrErrorPromise<T>(operation, this.contextStorage.get());
    }

    private class DefaultSuccessPromise<T>
    implements SuccessPromise<T> {
        private final Context context;
        private final Callable<T> backgroundAction;
        private final Action<Throwable> errorHandler;
        private FinishedOnThreadCallbackManager finishedOnThreadCallbackManager;

        DefaultSuccessPromise(Context context, Callable<T> backgroundAction, Action<Throwable> errorHandler) {
            this.context = context;
            this.backgroundAction = backgroundAction;
            this.errorHandler = errorHandler;
            this.finishedOnThreadCallbackManager = context.get(FinishedOnThreadCallbackManager.class);
        }

        @Override
        public void then(final Action<? super T> then) {
            this.finishedOnThreadCallbackManager.register(new Runnable(){

                @Override
                public void run() {
                    List<ProcessingInterceptor> interceptors = DefaultSuccessPromise.this.context.getAll(ProcessingInterceptor.class);
                    ListenableFuture future = DefaultBackground.this.backgroundExecutor.submit((Callable)new BackgroundOperation(interceptors));
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new ForegroundResume(interceptors, then), (Executor)DefaultBackground.this.foregroundExecutor);
                }
            });
        }

        private class ForegroundResume
        implements FutureCallback<T> {
            private final List<ProcessingInterceptor> interceptors;
            private final Action<? super T> then;
            private Exception exception;

            public ForegroundResume(List<ProcessingInterceptor> interceptors, Action<? super T> then) {
                this.interceptors = interceptors;
                this.then = then;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(final T result) {
                DefaultBackground.this.contextStorage.set(DefaultSuccessPromise.this.context);
                try {
                    new InterceptedOperation(ProcessingInterceptor.Type.FOREGROUND, this.interceptors, DefaultSuccessPromise.this.context){

                        @Override
                        protected void performOperation() {
                            try {
                                ForegroundResume.this.then.execute(result);
                                DefaultSuccessPromise.this.finishedOnThreadCallbackManager.fire();
                            }
                            catch (Exception e) {
                                ForegroundResume.this.exception = e;
                            }
                        }
                    }.run();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                }
                catch (Exception e) {
                    DefaultSuccessPromise.this.context.error(e);
                }
                finally {
                    DefaultBackground.this.contextStorage.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(final Throwable t) {
                DefaultBackground.this.contextStorage.set(DefaultSuccessPromise.this.context);
                try {
                    new InterceptedOperation(ProcessingInterceptor.Type.FOREGROUND, this.interceptors, DefaultSuccessPromise.this.context){

                        @Override
                        protected void performOperation() {
                            try {
                                DefaultSuccessPromise.this.errorHandler.execute(t);
                                DefaultSuccessPromise.this.finishedOnThreadCallbackManager.fire();
                            }
                            catch (Exception e) {
                                ForegroundResume.this.exception = e;
                            }
                        }
                    }.run();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                }
                catch (Exception e) {
                    DefaultSuccessPromise.this.context.error(e);
                }
                finally {
                    DefaultBackground.this.contextStorage.remove();
                }
            }
        }

        private class BackgroundOperation
        extends InterceptedOperation
        implements Callable<T> {
            private Exception exception;
            private T result;

            public BackgroundOperation(List<ProcessingInterceptor> interceptors) {
                super(ProcessingInterceptor.Type.BACKGROUND, interceptors, DefaultSuccessPromise.this.context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                DefaultBackground.this.contextStorage.set(DefaultSuccessPromise.this.context);
                try {
                    this.run();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    Object t = this.result;
                    return t;
                }
                finally {
                    DefaultBackground.this.contextStorage.remove();
                }
            }

            @Override
            protected void performOperation() {
                try {
                    this.result = DefaultSuccessPromise.this.backgroundAction.call();
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }
    }

    private class DefaultSuccessOrErrorPromise<T>
    implements SuccessOrErrorPromise<T> {
        private final Callable<T> backgroundAction;
        protected final Context context;

        DefaultSuccessOrErrorPromise(Callable<T> backgroundAction, Context context) {
            this.backgroundAction = backgroundAction;
            this.context = context;
        }

        @Override
        public SuccessPromise<T> onError(final Action<? super Throwable> errorHandler) {
            return new DefaultSuccessPromise<T>(this.context, this.backgroundAction, new Action<Throwable>(){

                @Override
                public void execute(Throwable t) {
                    try {
                        errorHandler.execute(t);
                    }
                    catch (Throwable errorHandlerError) {
                        new ForwardToContextErrorHandler().execute(errorHandlerError);
                    }
                }
            });
        }

        @Override
        public void then(Action<? super T> then) {
            new DefaultSuccessPromise<T>(this.context, this.backgroundAction, new ForwardToContextErrorHandler()).then(then);
        }

        class ForwardToContextErrorHandler
        implements Action<Throwable> {
            ForwardToContextErrorHandler() {
            }

            @Override
            public void execute(Throwable t) {
                DefaultSuccessOrErrorPromise.this.context.error(ExceptionUtils.toException(t));
            }
        }
    }
}

