/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.Callable;
import ratpack.file.internal.ChunkedInputAdapter;
import ratpack.file.internal.FileHttpTransmitter;
import ratpack.func.Action;
import ratpack.handling.Background;
import ratpack.http.internal.CustomHttpResponse;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.util.internal.NumberUtil;

public class DefaultFileHttpTransmitter
implements FileHttpTransmitter {
    private final FullHttpRequest request;
    private final HttpHeaders httpHeaders;
    private final Channel channel;
    private final boolean compress;
    private final long startTime;

    public DefaultFileHttpTransmitter(FullHttpRequest request, HttpHeaders httpHeaders, Channel channel, boolean compress, long startTime) {
        this.request = request;
        this.httpHeaders = httpHeaders;
        this.channel = channel;
        this.compress = compress;
        this.startTime = startTime;
    }

    private static boolean isNotNullAndStartsWith(String value, String ... prefixes) {
        if (value == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!value.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transmit(Background background, final BasicFileAttributes basicFileAttributes, final Path file) {
        boolean compressThis;
        boolean bl = compressThis = this.compress && basicFileAttributes.size() > 1024L && DefaultFileHttpTransmitter.isNotNullAndStartsWith(this.httpHeaders.get(HttpHeaderConstants.CONTENT_TYPE), "text/", "application/");
        if (this.compress && !compressThis) {
            this.httpHeaders.set(HttpHeaderConstants.CONTENT_ENCODING, (Object)"identity");
        }
        if (file.getFileSystem().equals(FileSystems.getDefault()) && !compressThis) {
            background.exec(new Callable<FileChannel>(){

                @Override
                public FileChannel call() throws Exception {
                    return new FileInputStream(file.toFile()).getChannel();
                }
            }).then(new Action<FileChannel>(){

                @Override
                public void execute(FileChannel fileChannel) {
                    DefaultFileRegion defaultFileRegion = new DefaultFileRegion(fileChannel, 0L, basicFileAttributes.size());
                    DefaultFileHttpTransmitter.this.transmit(basicFileAttributes, defaultFileRegion);
                }
            });
        } else {
            background.exec(new Callable<ReadableByteChannel>(){

                @Override
                public ReadableByteChannel call() throws Exception {
                    return Files.newByteChannel(file, new OpenOption[0]);
                }
            }).then(new Action<ReadableByteChannel>(){

                @Override
                public void execute(ReadableByteChannel fileChannel) {
                    DefaultFileHttpTransmitter.this.transmit(basicFileAttributes, new ChunkedInputAdapter((ChunkedInput<ByteBuf>)new ChunkedNioStream(fileChannel)));
                }
            });
        }
    }

    private void transmit(BasicFileAttributes basicFileAttributes, Object message) {
        CustomHttpResponse response = new CustomHttpResponse(HttpResponseStatus.OK, this.httpHeaders);
        response.headers().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)basicFileAttributes.size());
        if (HttpHeaders.isKeepAlive((HttpMessage)this.request)) {
            response.headers().set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.KEEP_ALIVE);
        }
        this.request.content().release();
        DefaultHttpResponse minimalResponse = new DefaultHttpResponse(response.getProtocolVersion(), response.getStatus());
        minimalResponse.headers().set(response.headers());
        long stopTime = System.nanoTime();
        if (this.startTime > 0L) {
            minimalResponse.headers().set("X-Response-Time", (Object)NumberUtil.toMillisDiffString(this.startTime, stopTime));
        }
        ChannelFuture writeFuture = this.channel.writeAndFlush((Object)minimalResponse);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    DefaultFileHttpTransmitter.this.channel.close();
                }
            }
        });
        writeFuture = this.channel.write(message);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    DefaultFileHttpTransmitter.this.channel.close();
                }
            }
        });
        ChannelFuture lastContentFuture = this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!HttpHeaders.isKeepAlive((HttpMessage)response)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

