/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.Extractions;
import ratpack.registry.Registries;
import ratpack.util.ExceptionUtils;

public abstract class InjectionHandler
implements Handler {
    private final List<Class<?>> types;
    private final Method handleMethod;

    protected InjectionHandler() throws NoSuitableHandleMethodException {
        Class<?> thisClass = this.getClass();
        Method handleMethod = null;
        for (Method method : thisClass.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals("handle") || (parameterTypes = method.getParameterTypes()).length < 2 || !parameterTypes[0].equals(Context.class)) continue;
            handleMethod = method;
            break;
        }
        if (handleMethod == null) {
            throw new NoSuitableHandleMethodException(thisClass);
        }
        this.handleMethod = handleMethod;
        Class<?>[] parameterTypes = handleMethod.getParameterTypes();
        this.types = ImmutableList.copyOf(Arrays.asList(parameterTypes).subList(1, parameterTypes.length));
    }

    @Override
    public final void handle(Context context) {
        Object[] args = new Object[this.types.size() + 1];
        args[0] = context;
        Extractions.extract(this.types, Registries.join(context.getRequest(), context), args, 1);
        try {
            this.handleMethod.invoke((Object)this, args);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.uncheck(e);
        }
        catch (InvocationTargetException e) {
            Throwable root = e.getTargetException();
            throw ExceptionUtils.uncheck(root);
        }
    }

    public static class NoSuitableHandleMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private NoSuitableHandleMethodException(Class<?> clazz) {
            super("No injectable handle method found for " + clazz.getName());
        }
    }
}

