/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ratpack.func.Factory;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.DefaultRegistryEntry;
import ratpack.registry.internal.LazyRegistryEntry;
import ratpack.registry.internal.MultiEntryRegistry;
import ratpack.registry.internal.RegistryEntry;

public class SimpleMutableRegistry<T>
implements MutableRegistry<T> {
    private final List<RegistryEntry<? extends T>> entries = new LinkedList<RegistryEntry<? extends T>>();
    private final Registry registry = new MultiEntryRegistry<T>(this.entries);

    @Override
    public <O extends T> void register(Class<O> type, O object) {
        this.entries.add(new DefaultRegistryEntry<O>(type, object));
    }

    @Override
    public void register(T object) {
        Class<?> type = object.getClass();
        this.entries.add(new DefaultRegistryEntry(type, object));
    }

    @Override
    public <O extends T> void registerLazy(Class<O> type, Factory<? extends O> factory) {
        this.entries.add(new LazyRegistryEntry<O>(type, factory));
    }

    @Override
    public <O extends T> void remove(Class<O> type) throws NotInRegistryException {
        Iterator<RegistryEntry<T>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().isAssignableFrom(type)) continue;
            iterator.remove();
        }
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        return this.registry.getAll(type);
    }
}

