/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.net.URI;
import java.net.URISyntaxException;
import ratpack.handling.Context;
import ratpack.server.BindAddress;
import ratpack.server.PublicAddress;

public class DefaultPublicAddress
implements PublicAddress {
    private final URI publicAddress;
    private final String uriScheme;

    public DefaultPublicAddress(URI publicAddress, String uriScheme) {
        this.publicAddress = publicAddress;
        this.uriScheme = uriScheme;
    }

    @Override
    public URI getAddress(Context context) {
        URI currentUrl = null;
        if (this.publicAddress == null) {
            BindAddress bindAddress = context.getBindAddress();
            try {
                currentUrl = new URI(this.uriScheme, null, bindAddress.getHost(), bindAddress.getPort(), null, null, null);
            }
            catch (URISyntaxException e) {
                context.error(e);
            }
        } else {
            currentUrl = this.publicAddress;
        }
        return currentUrl;
    }
}

