/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.OverlappingExecutionException;
import ratpack.exec.SuccessPromise;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.InternalRatpackError;

public class DefaultSuccessPromise<T>
implements SuccessPromise<T> {
    private final Factory<DefaultExecController.Execution> executionFactory;
    private final Action<? super Fulfiller<T>> action;
    private final Action<? super Throwable> errorHandler;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSuccessPromise.class);

    public DefaultSuccessPromise(Factory<DefaultExecController.Execution> executionFactory, Action<? super Fulfiller<T>> action, Action<? super Throwable> errorHandler) {
        this.executionFactory = executionFactory;
        this.action = action;
        this.errorHandler = errorHandler;
    }

    @Override
    public void then(final Action<? super T> then) {
        try {
            final DefaultExecController.Execution execution = this.executionFactory.create();
            execution.continueVia(new Runnable(){
                private final AtomicBoolean fulfilled = new AtomicBoolean();

                @Override
                public void run() {
                    try {
                        DefaultSuccessPromise.this.action.execute(new Fulfiller<T>(){

                            @Override
                            public void error(final Throwable throwable) {
                                if (!fulfilled.compareAndSet(false, true)) {
                                    LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
                                    return;
                                }
                                execution.join((Action<? super Execution>)new Action<Execution>(){

                                    @Override
                                    public void execute(Execution execution) throws Exception {
                                        DefaultSuccessPromise.this.errorHandler.execute(throwable);
                                    }
                                });
                            }

                            @Override
                            public void success(final T value) {
                                if (!fulfilled.compareAndSet(false, true)) {
                                    LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
                                    return;
                                }
                                execution.join((Action<? super Execution>)new Action<Execution>(){

                                    @Override
                                    public void execute(Execution execution) throws Exception {
                                        then.execute(value);
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!this.fulfilled.compareAndSet(false, true)) {
                            LOGGER.error("", (Throwable)new OverlappingExecutionException("exception thrown after promise was fulfilled", e));
                        }
                        execution.join((Action<? super Execution>)new Action<Execution>(){

                            @Override
                            public void execute(Execution execution) throws Exception {
                                throw ExceptionUtils.toException(e);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InternalRatpackError("failed to add promise resume action");
        }
    }
}

